    <g:if test="${inventoryMovementList.isEmpty()}">
        <br />
        No Inventory Movements.
        <br />
        <br />
    </g:if>
    <g:else>
        <div class="list">
            <table>
                <thead>
                    <tr>
                        <th>Inventory Item</th>
                        <th>Quantity</th>
                        <th>Movement Type</th>
                        <th>Date</th>
                        <th></th>
                    </tr>
                </thead>
                <tbody>
                    <g:each in="${inventoryMovementList}" status="i" var="inventoryMovementInstance">
                        <tr class="${(i % 2) == 0 ? 'clickableOdd' : 'clickableEven'}"/>

                            <td onclick='window.location = "${request.getContextPath()}/inventoryMovementDetailed/show/${inventoryMovementInstance.id}"'>
                                ${fieldValue(bean:inventoryMovementInstance, field:'inventoryItem')}
                            </td>

                            <td onclick='window.location = "${request.getContextPath()}/inventoryMovementDetailed/show/${inventoryMovementInstance.id}"'>
                                ${fieldValue(bean:inventoryMovementInstance, field:'quantity')}
                            </td>

                            <td onclick='window.location = "${request.getContextPath()}/inventoryMovementDetailed/show/${inventoryMovementInstance.id}"'>
                                ${fieldValue(bean:inventoryMovementInstance, field:'inventoryMovementType')}
                            </td>

                            <td onclick='window.location = "${request.getContextPath()}/inventoryMovementDetailed/show/${inventoryMovementInstance.id}"'>
                                <g:formatDate date="${inventoryMovementInstance.date}" format="EEE, dd-MMM-yyyy"/>
                            </td>

                            <td class="notClickable">
                                <g:link controller="inventoryMovementDetailed" action="show" id="${inventoryMovementInstance.id}">
                                    <img  src="${resource(dir:'images/skin',file:'database_go.png')}" alt="Show" title="Show" />
                                </g:link>
                            </td>

                        </tr>
                    </g:each>
                </tbody>
            </table>
        </div>
    </g:else>

    <g:form controller="inventoryItemDetailed" >
        <g:hiddenField name="task.id" value="${taskInstance?.id}" />
        <div class="buttons">
            <g:if test="${!inventoryMovementList.isEmpty()}">
                Results: ${inventoryMovementList.size()}
                <br />
            </g:if>
            <span class="button">
                <g:actionSubmit action="findInventoryItemForMovement" class="add" value="Add" />
            </span>
        </div>
    </g:form>