security {

	// see DefaultSecurityConfig.groovy for all settable/overridable properties

	active = true

	loginUserDomainClass = "Person"
    userName = 'loginName'
    password = 'password'
    enabled = 'isActive'

	authorityDomainClass = "Authority"

    //Required if we want to run "grails generate-manager"
    //Which recreates the controller and views, so save the views!
//     requestMapClass = 'Requestmap'

    useRequestMapDomainClass = false
    useControllerAnnotations = true

    //Set true especially if used across the internet.
    forceHttps = 'true'

    //Pessimistic locking, deny access to all URLs that don't 
    //have an applicable URL-Role configuration.
    //This forces us to set an annotation, static rule or
    //extend BaseController and prevents accidentally leaving pages open.
    controllerAnnotationsRejectIfNoRule = true
    
    //Static rules for controllers, actions and urls.
    //Since we are using pessimistic locking we have to set some things
    //here but most security should be set in the controllers.
    controllerAnnotationStaticRules = [
    '/': ['IS_AUTHENTICATED_FULLY'],
    '/index.gsp': ['IS_AUTHENTICATED_FULLY'],
    '/css/*': ['IS_AUTHENTICATED_ANONYMOUSLY'],
    '/images/**': ['IS_AUTHENTICATED_ANONYMOUSLY'],
    '/login*': ['IS_AUTHENTICATED_ANONYMOUSLY'],
    '/login/**': ['IS_AUTHENTICATED_ANONYMOUSLY'],
    '/logout*': ['IS_AUTHENTICATED_FULLY'],
    '/logout/**': ['IS_AUTHENTICATED_FULLY']
    ]

    //We always want to go to the home page so that bookmarks are not used.
    defaultTargetUrl = '/appCore/home'
    alwaysUseDefaultTargetUrl = true

}
