import org.codehaus.groovy.grails.plugins.springsecurity.Secured

class ModificationController extends BaseController {
    
    def index = { redirect(action:list,params:params) }

    // the delete, save and update actions only accept POST requests
    def allowedMethods = [delete:'POST', save:'POST', update:'POST']

    def list = {
        if(!params.max) params.max = 10
        [ modificationInstanceList: Modification.list( params ) ]
    }

    def show = {
        def modificationInstance = Modification.get( params.id )

        if(!modificationInstance) {
            flash.message = "Modification not found with id ${params.id}"
            redirect(action:list)
        }
        else { return [ modificationInstance : modificationInstance ] }
    }

    def delete = {
        def modificationInstance = Modification.get( params.id )
        if(modificationInstance) {
            modificationInstance.delete()
            flash.message = "Modification ${params.id} deleted"
            redirect(action:list)
        }
        else {
            flash.message = "Modification not found with id ${params.id}"
            redirect(action:list)
        }
    }

    def edit = {
        def modificationInstance = Modification.get( params.id )

        if(!modificationInstance) {
            flash.message = "Modification not found with id ${params.id}"
            redirect(action:list)
        }
        else {
            return [ modificationInstance : modificationInstance ]
        }
    }

    def update = {
        def modificationInstance = Modification.get( params.id )
        if(modificationInstance) {
            modificationInstance.properties = params
            if(!modificationInstance.hasErrors() && modificationInstance.save()) {
                flash.message = "Modification ${params.id} updated"
                redirect(action:show,id:modificationInstance.id)
            }
            else {
                render(view:'edit',model:[modificationInstance:modificationInstance])
            }
        }
        else {
            flash.message = "Modification not found with id ${params.id}"
            redirect(action:edit,id:params.id)
        }
    }

    def create = {
        def modificationInstance = new Modification()
        modificationInstance.properties = params
        return ['modificationInstance':modificationInstance]
    }

    def save = {
        def modificationInstance = new Modification(params)
        if(!modificationInstance.hasErrors() && modificationInstance.save()) {
            flash.message = "Modification ${modificationInstance.id} created"
            redirect(action:show,id:modificationInstance.id)
        }
        else {
            render(view:'create',model:[modificationInstance:modificationInstance])
        }
    }
}
