<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
        <meta name="layout" content="main" />
        <title>Inventory Item Purchase Search</title>
        <filterpane:includes />
        <nav:resources override="true"/>
        <export:resource />
    </head>
    <body>
        <div class="nav">
            <nav:renderSubItems group="navAlt"/>
        </div>

        <div class="body">
            <g:render template="/shared/messages" />
            <filterpane:currentCriteria domainBean="InventoryItemPurchase"
                                    action="search"
                                    dateFormat="EEE, dd-MMM-yyyy"
                                    removeImgDir="images"
                                    removeImgFile="bullet_delete.png"
                                    title="Advanced Search"/>

            <div class="paginateButtons">
                <span class="searchButtons">
                    <a href='' onclick="showElement('searchPane'); return false;">Quick</a>
                </span>
                Results: ${inventoryItemPurchaseList.size()} / ${inventoryItemPurchaseTotal}
                <span class="searchButtons">
                    <filterpane:filterButton text="Advanced" appliedText="Advanced" />
                </span>
            </div>

            <jsUtil:toggleControl toggleId="options"
                                                    imageId="optionsImg"
                                                    closedImgUrl="${resource(dir:'images/skin',file:'bullet_arrow_right.png')}"
                                                    openImgUrl="${resource(dir:'images/skin',file:'bullet_arrow_down.png')}"
                                                    text="${g.message(code: 'default.options.text')}"
                                                    />

            <div id="options" style="display:none;">
                <g:form method="post" action="setSearchParamsMax" >
                    <g:hiddenField name="params" value="${filterParams}" />
                    <div class="dialog">
                        <table>
                            <tbody>

                                <tr class="prop">
                                    <td valign="top" class="name">
                                        <label for="max">Results per page:</label>
                                    </td>
                                    <td valign="top" class="value">
                                        <input type="text" maxlength="4" id="description" name="newMax" value="${params.max}"/>

                                        <span class="buttons">
                                            <g:actionSubmit action="setSearchParamsMax" class="go" value="Update" />
                                        </span>
                                    </td>
                                </tr>

                            </tbody>
                        </table>
                    </div>
                <export:formats  params="${filterParams}" formats="['csv', 'excel', 'pdf', 'rtf']"/>
                </g:form>
            </div>

            <br />

            <g:if test="${inventoryItemPurchaseList.size() > 10}">
                <g:if test="${inventoryItemPurchaseTotal > inventoryItemPurchaseList.size()}">
                    <div class="paginateButtons">
                        <g:paginate action="search" total="${inventoryItemPurchaseTotal}" params="${filterParams}" />
                    </div>
                </g:if>
            </g:if>

            <g:if test="${inventoryItemPurchaseList.size() > 0}">
                <div class="list">
                    <table>
                        <thead>
                            <tr>
                                <g:sortableColumn property="purchaseOrderNumber"
                                                                    title="Order #"
                                                                    params="${filterParams}"  />
                                <g:sortableColumn property="date"
                                                                    title="Date"
                                                                    params="${filterParams}" />
                                <g:sortableColumn property="inventoryItem"
                                                                    title="Inventory Item"
                                                                    params="${filterParams}" />
                                <g:sortableColumn property="costCode"
                                                                    title="Cost Code"
                                                                    params="${filterParams}" />
                                <g:sortableColumn property="quantity"
                                                                    title="Quantity"
                                                                    params="${filterParams}" />
                                <g:sortableColumn property="orderValueAmount"
                                                                    title="Order \$"
                                                                    params="${filterParams}" />
                                <g:sortableColumn property="inventoryItemPurchaseType"
                                                                    title="Type"
                                                                    params="${filterParams}" />
                                <th>
                                    <img  src="${resource(dir:'images/skin',file:'database_go_grey.png')}" alt="Show" title="Show" />
                                </th>
                                <th>
                                    <img  src="${resource(dir:'images/skin',file:'basket_put_grey.png')}" alt="Receive" title="Receive" />
                                </th>
                                <th>
                                    <img  src="${resource(dir:'images/skin',file:'tick_grey.png')}" alt="Approve" title="Approve Payment" />
                                </th>
                            </tr>
                        </thead>
                        <tbody>
                            <g:each in="${inventoryItemPurchaseList}" status="i" var="purchase">
                                <tr class="${(i % 2) == 0 ? 'clickableOdd' : 'clickableEven'}"/>

                                    <td onclick='window.location = "${request.getContextPath()}/inventoryItemPurchaseDetailed/show/${purchase.id}?returnTo=search"'>
                                        ${fieldValue(bean:purchase, field:'purchaseOrderNumber')}
                                    </td>
                                    <td onclick='window.location = "${request.getContextPath()}/inventoryItemPurchaseDetailed/show/${purchase.id}?returnTo=search"'>
                                        <g:formatDate date="${purchase.date}" format="EEE, dd-MMM-yyyy"/>
                                    </td>
                                    <td onclick='window.location = "${request.getContextPath()}/inventoryItemPurchaseDetailed/show/${purchase.id}?returnTo=search"'>
                                        <b>${fieldValue(bean:purchase, field:'inventoryItem')}</b><br/>
                                        ${purchase.inventoryItem.description?.encodeAsHTML()}
                                    </td>
                                    <td onclick='window.location = "${request.getContextPath()}/inventoryItemPurchaseDetailed/show/${purchase.id}?returnTo=search"'>
                                        <b>${fieldValue(bean:purchase, field:'costCode')}</b><br/>
                                        <g:if test="${purchase.invoiceNumber}">
                                            Invoice # ${fieldValue(bean:purchase, field:'invoiceNumber')}<br/>
                                        </g:if>
                                        ${fieldValue(bean:purchase, field:'comment')}
                                    </td>
                                    <td onclick='window.location = "${request.getContextPath()}/inventoryItemPurchaseDetailed/show/${purchase.id}?returnTo=search"'>
                                        ${fieldValue(bean:purchase, field:'quantity')}
                                    </td>
                                    <td onclick='window.location = "${request.getContextPath()}/inventoryItemPurchaseDetailed/show/${purchase.id}?returnTo=search"'>
                                        ${fieldValue(bean:purchase, field:'orderValueAmount')}
                                        ${fieldValue(bean:purchase, field:'orderValueCurrency')}
                                    </td>
                                    <td onclick='window.location = "${request.getContextPath()}/inventoryItemPurchaseDetailed/show/${purchase.id}?returnTo=search"'>
                                        ${fieldValue(bean:purchase, field:'inventoryItemPurchaseType')}
                                    </td>
                                    <td class="notClickable">
                                        <g:link controller="inventoryItemPurchaseDetailed" action="show" params="[id: purchase.id, returnTo: 'search']">
                                            <img  src="${resource(dir:'images/skin',file:'database_go.png')}" alt="Show" title="Show" />
                                        </g:link>
                                    </td>

                                    <g:if test="${purchase.inventoryItemPurchaseType.id == 1}">
                                        <g:if test="${!purchase.receivedComplete}">
                                            <td class="notClickable">
                                                <g:link controller="inventoryItemPurchaseDetailed" action="receive" params="[id: purchase.id, returnTo: 'search']">
                                                    <img  src="${resource(dir:'images/skin',file:'basket_put.png')}" alt="Receive" title="Receive" />
                                                </g:link>
                                            </td>
                                            <td class="notClickable">
                                            </td>
                                        </g:if>
                                        <g:else>
                                            <td class="notClickable">
                                            </td>
                                            <td class="notClickable">
                                            </td>
                                        </g:else>
                                    </g:if>
                                    <g:elseif test="${(purchase.inventoryItemPurchaseType.id == 2)||(purchase.inventoryItemPurchaseType.id == 3)}">
                                        <g:if test="${!purchase.invoicePaymentApproved}">
                                            <td class="notClickable">
                                            </td>
                                            <td class="notClickable">
                                                <g:link controller="inventoryItemPurchaseDetailed" action="approveInvoicePayment" params="[id: purchase.id, returnTo: 'search']">
                                                    <img  src="${resource(dir:'images/skin',file:'tick.png')}" alt="Approve" title="Approve Payment" />
                                                </g:link>
                                            </td>
                                        </g:if>
                                        <g:else>
                                            <td class="notClickable">
                                            </td>
                                            <td class="notClickable">
                                            </td>
                                        </g:else>
                                    </g:elseif>
                                    <g:else>
                                        <td class="notClickable">
                                        </td>
                                        <td class="notClickable">
                                        </td>
                                    </g:else>

                                </tr>
                            </g:each>
                        </tbody>
                    </table>
                </div>
            </g:if>
            <div class="paginateButtons">
                <g:paginate action="search" total="${inventoryItemPurchaseTotal}" params="${filterParams}" />
            </div>

            <filterpane:filterPane domainBean="InventoryItemPurchase"
                                    title="Advanced Search"
                                    action="search"
                                    class="overlayPane"
                                    excludeProperties="orderValueCurrency, dateCreated"
                                    associatedProperties="inventoryItemPurchaseType.name"
                                    filterPropertyValues="${['inventoryItemPurchaseType.name':[values:InventoryItemPurchaseType.findAllByIsActive(true)],
                                                                                date:[years: associatedPropertyValues.yearRange,precision:'day']
                                                                                ]}"/>
        </div> <!-- end body  -->

        <!-- Start Search Pane -->
        <div class="overlayPane" id="searchPane" style="display:none;">
            <h2>Quick Search</h2>
            <g:form method="post" id="searchForm" name="searchForm" >
                <table>
                    <tbody>

                        <tr class="prop">
                            <td valign="top" class="name">
                                <label>Type:</label>
                            </td>
                            <td valign="top" class="value">
                                <g:link controller="inventoryItemPurchaseDetailed"
                                                action="search"
                                                params="[quickSearch: 'searchAllOrders']">
                                                All Orders
                                </g:link>
                                <br />
                                <g:link controller="inventoryItemPurchaseDetailed" 
                                                action="search"
                                                params="[quickSearch: 'searchAllReceived']">
                                                All Received
                                </g:link>
                            </td>
                        </tr>

                    </tbody>
                </table>
                <div class="buttons">
                    <span class="button">
                        <input type="button" value="${g.message(code:'fp.tag.filterPane.button.cancel.text', default:'Cancel')}" onclick="return hideElement('searchPane');" />
                    </span>
                </div>
            </g:form>
        </div> <!-- end search pane -->

    </body>
</html>
