import org.codehaus.groovy.grails.plugins.springsecurity.Secured

@Secured(['ROLE_AppAdmin', 'ROLE_Manager', 'ROLE_TaskManager'])
class UnitOfMeasureDetailedController extends BaseController {
    
    def index = { redirect(action:list,params:params) }

    // the delete, save and update actions only accept POST requests
    static allowedMethods = [delete:'POST', save:'POST', update:'POST']

    def list = {
        params.max = Math.min( params.max ? params.max.toInteger() : 10,  100)
        [ unitOfMeasureInstanceList: UnitOfMeasure.list( params ), unitOfMeasureInstanceTotal: UnitOfMeasure.count() ]
    }

    def show = {

        // In the case of an actionSubmit button, rewrite action name from 'index'.
        if(params._action_Show)
            params.action='show'

        def unitOfMeasureInstance = UnitOfMeasure.get( params.id )

        if(!unitOfMeasureInstance) {
            flash.message = "UnitOfMeasure not found with id ${params.id}"
            redirect(action:list)
        }
        else { return [ unitOfMeasureInstance : unitOfMeasureInstance ] }
    }

    def delete = {
        def unitOfMeasureInstance = UnitOfMeasure.get( params.id )
        if(unitOfMeasureInstance) {
            try {
                unitOfMeasureInstance.delete(flush:true)
                flash.message = "UnitOfMeasure ${params.id} deleted"
                redirect(action:list)
            }
            catch(org.springframework.dao.DataIntegrityViolationException e) {
                flash.message = "UnitOfMeasure ${params.id} could not be deleted"
                redirect(action:show,id:params.id)
            }
        }
        else {
            flash.message = "UnitOfMeasure not found with id ${params.id}"
            redirect(action:list)
        }
    }

    def edit = {

        // In the case of an actionSubmit button, rewrite action name from 'index'.
        if(params._action_Edit)
            params.action='edit'

        def unitOfMeasureInstance = UnitOfMeasure.get( params.id )

        if(!unitOfMeasureInstance) {
            flash.message = "UnitOfMeasure not found with id ${params.id}"
            redirect(action:list)
        }
        else {
            return [ unitOfMeasureInstance : unitOfMeasureInstance ]
        }
    }

    def update = {
        def unitOfMeasureInstance = UnitOfMeasure.get( params.id )
        if(unitOfMeasureInstance) {
            if(params.version) {
                def version = params.version.toLong()
                if(unitOfMeasureInstance.version > version) {
                    
                    unitOfMeasureInstance.errors.rejectValue("version", "default.optimistic.locking.failure")
                    render(view:'edit',model:[unitOfMeasureInstance:unitOfMeasureInstance])
                    return
                }
            }
            unitOfMeasureInstance.properties = params
            if(!unitOfMeasureInstance.hasErrors() && unitOfMeasureInstance.save(flush: true)) {
                flash.message = "UnitOfMeasure ${params.id} updated"
                redirect(action:show,id:unitOfMeasureInstance.id)
            }
            else {
                render(view:'edit',model:[unitOfMeasureInstance:unitOfMeasureInstance])
            }
        }
        else {
            flash.message = "UnitOfMeasure not found with id ${params.id}"
            redirect(action:list)
        }
    }

    def create = {
        def unitOfMeasureInstance = new UnitOfMeasure()
        unitOfMeasureInstance.properties = params
        return ['unitOfMeasureInstance':unitOfMeasureInstance]
    }

    def save = {
        def unitOfMeasureInstance = new UnitOfMeasure(params)
        if(!unitOfMeasureInstance.hasErrors() && unitOfMeasureInstance.save(flush: true)) {
            flash.message = "UnitOfMeasure ${unitOfMeasureInstance.id} created"
            redirect(action:show,id:unitOfMeasureInstance.id)
        }
        else {
            render(view:'create',model:[unitOfMeasureInstance:unitOfMeasureInstance])
        }
    }
}
