import org.codehaus.groovy.grails.plugins.springsecurity.Secured
import org.springframework.web.servlet.support.RequestContextUtils as RCU

class ReportController extends BaseController {

    def authService
    def dateUtilService
    def taskReportService

    def index = { redirect(action:templatePortrait,params:params) }

    // the delete, save and update actions only accept POST requests
    //static allowedMethods = [list:'POST']

    def templatePortrait = {
        params.max = Math.min( params.max ? params.max.toInteger() : 10,  100)

        params.reportTitle = "Template Report (Portrait)"
        params.currentUser = authService.currentUser
        def dataModel = createTemplateData()

        chain(controller:'jasper', action:'index', model:[data: dataModel], params:params)
    }

    def templateLandscape = {
        params.max = Math.min( params.max ? params.max.toInteger() : 10,  100)

        params.reportTitle = "Template Report (Landscape)"
        params.currentUser = authService.currentUser
        def dataModel = createTemplateData()

        chain(controller:'jasper', action:'index', model:[data: dataModel], params:params)
    }

    private createTemplateData() {
        def dataModel = []
        for(i in 1..5) {
            def data = [:]
            data.description = "Data description " + i.toString()
            dataModel.add(data)
        }
        return dataModel
    }

    def reactiveRatio = {

        params.reportTitle = "Reactive Ratio Report"
        params.logoUrl = grailsApplication.mainContext.getResource('images/logo.png').getURL()
        params.currentUser = authService.currentUser

        if(params.startDate == 'struct')
            params.startDate = dateUtilService.makeDate(params.startDate_year, params.startDate_month, params.startDate_day)
        else
            params.startDate = dateUtilService.today-7
        params.startDateString = g.formatDate(format: "EEE, dd-MMM-yyyy", date: params.startDate)

        if(params.endDate == 'struct')
            params.endDate = dateUtilService.makeDate(params.endDate_year, params.endDate_month, params.endDate_day)
        else
            params.endDate = dateUtilService.today
        params.endDateString = g.formatDate(format: "EEE, dd-MMM-yyyy", date: params.endDate)

        def dataModel = [taskReportService.getReactiveRatio(params, RCU.getLocale(request))]

        chain(controller:'jasper', action:'index', model:[data: dataModel], params:params)
    }

    def test = {
        render taskReportService.getReactiveRatio(params, RCU.getLocale(request))
    }

} // end of class.
