import grails.test.*

/**
* Integration tests for TaskSearchService.
*/
class TaskSearchServiceTests extends GroovyTestCase {

    // Data will be saved, not rolled back.
    // Be sure to clean up in tearDown().
    boolean transactional = false

    def taskService
    def dateUtilService
    def taskSearchService

    def taskA
    def taskB
    def taskCount = 0

    // Setup is called before each test.
    protected void setUp() {
        super.setUp()

        // Check environment state.
        assert Task.count() == 0
        assert Entry.count() == 0
        assert TaskModification.count() == 0

        def p = [:]
        def result

        p = [taskGroup:TaskGroup.findByName("Engineering Activites"),
                taskPriority:TaskPriority.get(2),
                taskType:TaskType.get(1),
                leadPerson:Person.get(1),
                description:"TestA",
                comment:"Service test task.",
                targetStartDate: dateUtilService.today,
                targetCompletionDate: dateUtilService.today]

        result = taskService.save(p)
        assert result.error == null
        taskCount++
        taskA = result.taskInstance.refresh()

        p.description = "TestB"
        result = taskService.save(p)
        assert result.error == null
        taskCount++
        taskB = result.taskInstance.refresh()
    }

    // Tear down is called after each test.
    protected void tearDown() {
        super.tearDown()

        taskService.delete(taskA)
        taskService.delete(taskB)

        // Ensure that we leave environment clean.
        assert Task.count() == 0
        assert TaskModification.count() == 0
        assert Entry.count() == 0
    }

    void testGetTasks() {
        // Todays tasks should be returned
        def tasks = taskSearchService.getTasks([:])
        assert tasks.totalCount == taskCount

        // Tasks in the trash should not be returned.
        tasks[0].trash = true
        tasks[0].save(flush:true)
        assert taskSearchService.getTasks([:]).totalCount == taskCount - 1
        tasks[1].trash = true
        tasks[1].save(flush:true)
        assert taskSearchService.getTasks([:]).totalCount == taskCount - 2

        // Restored tasks should be returned.
        tasks[0].trash = false
        tasks[0].save(flush:true)
        assert taskSearchService.getTasks([:]).totalCount == taskCount - 1
        tasks[1].trash = false
        tasks[1].save(flush:true)
        assert taskSearchService.getTasks([:]).totalCount == taskCount

        // Tomorrows tasks should not be returned.
        tasks[0].targetStartDate = dateUtilService.tomorrow
        tasks[0].targetCompletionDate = dateUtilService.tomorrow
        tasks[0].save(flush:true)
        assert taskSearchService.getTasks([:]).totalCount == taskCount - 1

        // Yesterdays tasks should not be returned.
        tasks[0].targetStartDate = dateUtilService.yesterday
        tasks[0].targetCompletionDate = dateUtilService.yesterday
        tasks[0].save(flush:true)
        assert taskSearchService.getTasks([:]).totalCount == taskCount - 1

        // Tasks that span today should be returned.
        tasks[0].targetStartDate = dateUtilService.yesterday
        tasks[0].targetCompletionDate = dateUtilService.tomorrow
        tasks[0].save(flush:true)
        assert taskSearchService.getTasks([:]).totalCount == taskCount
    } // testGetTasks()

} // end class