import org.codehaus.groovy.grails.plugins.springsecurity.Secured

@Secured(['ROLE_AppAdmin', 'ROLE_Manager', 'ROLE_AssetManager'])
class ManufacturerTypeDetailedController extends BaseController {

    @Secured(['ROLE_AppAdmin', 'ROLE_Manager', 'ROLE_AssetManager', 'ROLE_AssetUser'])
    def index = { redirect(action:list,params:params) }

    // the delete, save and update actions only accept POST requests
    static allowedMethods = [delete:'POST', save:'POST', update:'POST']

    @Secured(['ROLE_AppAdmin', 'ROLE_Manager', 'ROLE_AssetManager', 'ROLE_AssetUser'])
    def list = {
        params.max = Math.min( params.max ? params.max.toInteger() : 10,  100)
        [ manufacturerTypeInstanceList: ManufacturerType.list( params ), manufacturerTypeInstanceTotal: ManufacturerType.count() ]
    }

    @Secured(['ROLE_AppAdmin', 'ROLE_Manager', 'ROLE_AssetManager', 'ROLE_AssetUser'])
    def show = {

        // In the case of an actionSubmit button, rewrite action name from 'index'.
        if(params._action_Show)
            params.action='show'

        def manufacturerTypeInstance = ManufacturerType.get( params.id )

        if(!manufacturerTypeInstance) {
            flash.message = "ManufacturerType not found with id ${params.id}"
            redirect(action:list)
        }
        else { return [ manufacturerTypeInstance : manufacturerTypeInstance ] }
    }

    def delete = {
        def manufacturerTypeInstance = ManufacturerType.get( params.id )
        if(manufacturerTypeInstance) {
            try {
                manufacturerTypeInstance.delete(flush:true)
                flash.message = "ManufacturerType ${params.id} deleted"
                redirect(action:list)
            }
            catch(org.springframework.dao.DataIntegrityViolationException e) {
                flash.message = "ManufacturerType ${params.id} could not be deleted"
                redirect(action:show,id:params.id)
            }
        }
        else {
            flash.message = "ManufacturerType not found with id ${params.id}"
            redirect(action:list)
        }
    }

    def edit = {

        // In the case of an actionSubmit button, rewrite action name from 'index'.
        if(params._action_Edit)
            params.action='edit'

        def manufacturerTypeInstance = ManufacturerType.get( params.id )

        if(!manufacturerTypeInstance) {
            flash.message = "ManufacturerType not found with id ${params.id}"
            redirect(action:list)
        }
        else {
            return [ manufacturerTypeInstance : manufacturerTypeInstance ]
        }
    }

    def update = {
        def manufacturerTypeInstance = ManufacturerType.get( params.id )
        if(manufacturerTypeInstance) {
            if(params.version) {
                def version = params.version.toLong()
                if(manufacturerTypeInstance.version > version) {
                    
                    manufacturerTypeInstance.errors.rejectValue("version", "manufacturerType.optimistic.locking.failure", "Another user has updated this ManufacturerType while you were editing.")
                    render(view:'edit',model:[manufacturerTypeInstance:manufacturerTypeInstance])
                    return
                }
            }
            manufacturerTypeInstance.properties = params
            if(!manufacturerTypeInstance.hasErrors() && manufacturerTypeInstance.save(flush: true)) {
                flash.message = "ManufacturerType ${params.id} updated"
                redirect(action:show,id:manufacturerTypeInstance.id)
            }
            else {
                render(view:'edit',model:[manufacturerTypeInstance:manufacturerTypeInstance])
            }
        }
        else {
            flash.message = "ManufacturerType not found with id ${params.id}"
            redirect(action:list)
        }
    }

    def create = {
        def manufacturerTypeInstance = new ManufacturerType()
        manufacturerTypeInstance.properties = params
        return ['manufacturerTypeInstance':manufacturerTypeInstance]
    }

    def save = {
        def manufacturerTypeInstance = new ManufacturerType(params)
        if(!manufacturerTypeInstance.hasErrors() && manufacturerTypeInstance.save(flush: true)) {
            flash.message = "ManufacturerType ${manufacturerTypeInstance.id} created"
            redirect(action:show,id:manufacturerTypeInstance.id)
        }
        else {
            render(view:'create',model:[manufacturerTypeInstance:manufacturerTypeInstance])
        }
    }
}
