class AssignedGroupService {

    boolean transactional = false

    def personService

    def list(params) {
        def result = [:]
        def fail = { Map m ->
            result.error = [ code: m.code, args: ["AssignedGroup"] ]
            return result
        }

        params.max = Math.min( params.max ? params.max.toInteger() : 10,  100)
        result.assignedGroupInstanceList = AssignedGroup.list(params)
        result.assignedGroupInstanceTotal = AssignedGroup.count()

        if(!result.assignedGroupInstanceList || !result.assignedGroupInstanceTotal)
            return fail(code:"default.list.failure")

        // Success.
        return result
    }

    def show(params) {
        def result = [:]
        def fail = { Map m ->
            result.error = [ code: m.code, args: ["AssignedGroup", params.id] ]
            return result
        }

        result.assignedGroupInstance = AssignedGroup.get(params.id)

        if(!result.assignedGroupInstance)
            return fail(code:"default.not.found")

        // Success.
        return result
    }

    def delete(params) {
        AssignedGroup.withTransaction { status ->
            def result = [:]

            def fail = { Map m ->
                status.setRollbackOnly()
                if(result.assignedGroupInstance && m.field)
                    result.assignedGroupInstance.errors.rejectValue(m.field, m.code)
                result.error = [ code: m.code, args: ["AssignedGroup", params.id] ]
                return result
            }

            result.assignedGroupInstance = AssignedGroup.get(params.id)

            if(!result.assignedGroupInstance)
                return fail(code:"default.not.found")

            def taskModification = new TaskModification(person: personService.currentUser,
                                                    taskModificationType: TaskModificationType.get(10),
                                                    task: result.assignedGroupInstance.task)

            if(!taskModification.save())
                return fail(field:"taskModifications", code:"task.modifications.failedToSave")

            try {
                result.assignedGroupInstance.delete(flush:true)
                return result //Success.
            }
            catch(org.springframework.dao.DataIntegrityViolationException e) {
                return fail(code:"default.delete.failure")
            }

        } //end withTransaction
    } // end delete()

    def edit(params) {
        def result = [:]
        def fail = { Map m ->
            result.error = [ code: m.code, args: ["AssignedGroup", params.id] ]
            return result
        }

        result.assignedGroupInstance = AssignedGroup.get(params.id)

        if(!result.assignedGroupInstance)
            return fail(code:"default.not.found")

        // Success.
        return result
    }

    def update(params) {
        AssignedGroup.withTransaction { status ->
            def result = [:]

            def fail = { Map m ->
                status.setRollbackOnly()
                if(result.assignedGroupInstance && m.field)
                    result.assignedGroupInstance.errors.rejectValue(m.field, m.code)
                result.error = [ code: m.code, args: ["AssignedGroup", params.id] ]
                return result
            }

            result.assignedGroupInstance = AssignedGroup.get(params.id)

            if(!result.assignedGroupInstance)
                return fail(code:"default.not.found")

            // Optimistic locking check.
            if(params.version) {
                if(result.assignedGroupInstance.version > params.version.toLong())
                    return fail(field:"version", code:"default.optimistic.locking.failure")
            }

            result.assignedGroupInstance.properties = params

            if(result.assignedGroupInstance.hasErrors() || !result.assignedGroupInstance.save())
                return fail(code:"default.update.failure")

            def taskModification = new TaskModification(person: personService.currentUser,
                                                    taskModificationType: TaskModificationType.get(10),
                                                    task: result.assignedGroupInstance.task)

            if(!taskModification.save())
                return fail(field:"taskModifications", code:"task.modifications.failedToSave")

            // Success.
            return result

        } //end withTransaction
    }  // end update()

    def create(params) {
        def result = [:]
        def fail = { Map m ->
            result.error = [ code: m.code, args: ["AssignedGroup", params.id] ]
            return result
        }

        if(!params.task?.id)
            fail(code:"assignedGroup.task.not.found")

        result.assignedGroupInstance = new AssignedGroup()
        result.assignedGroupInstance.properties = params

        // success
        return result
    }

    def save(params) {
        AssignedGroup.withTransaction { status ->
            def result = [:]

            def fail = { Map m ->
                if(result.assignedGroupInstance && m.field)
                    result.assignedGroupInstance.errors.rejectValue(m.field, m.code)
                result.error = [ code: m.code, args: ["AssignedGroup", params.id] ]
                return result
            }

            result.assignedGroupInstance = new AssignedGroup(params)

            if(result.assignedGroupInstance.hasErrors() || !result.assignedGroupInstance.save())
                return fail(code:"default.create.failure")

            // Record a taskModification for every one except "system".
            if(personService.currentUser.id != 1) {
                def taskModification = new TaskModification(person: personService.currentUser,
                                                        taskModificationType: TaskModificationType.get(10),
                                                        task: result.assignedGroupInstance.task)

                if(!taskModification.save())
                    return fail(field:"taskModifications", code:"task.modifications.failedToSave")
            }

            // success
            return result

        } //end withTransaction
    } // end save()

} // end class