/**
* Provides a service class for the InventoryItem domain class.
*/
class InventoryItemService {

    boolean transactional = false

    /**
    * Prepare the data for the show view.
    * The result can be used to easily construct the model for the show view.
    * @param params The incoming params as normally passed to the show view
    * primarily including the id of the inventoryItem.
    * @returns A map containing result.error=true (if any error) and result.inventoryItemInstance (if available)
    * and 
    */
    def prepareShowData(params) {
        def result = [:]

        def fail = { Object[] args ->
            if(args.size() == 2) result.errors = [args[0], args[1]]
            log.debug result.errors
            result.error = true
            return result
        }

        result.showTab = [:]
        switch (params.showTab) {
            case "showDetailTab":
                result.showTab.detail =  new String("true")
                break
            case "showMovementTab":
                result.showTab.movement =  new String("true")
                break
            default:
                result.showTab.inventory = new String("true")
        }

        result.inventoryItemInstance = InventoryItem.get( params.id )

        if(!result.inventoryItemInstance)
            return fail("inventoryItem", "inventoryItem.notFound")

        log.debug "WTF are we doing here"

        def p = [:]
        p.max = result.inventoryMovementListMax = 10
        p.order = "desc"
        p.sort = "id"
        result.inventoryMovementList = InventoryMovement.findAllByInventoryItem(result.inventoryItemInstance, p)
        result.inventoryMovementListTotal = InventoryMovement.countByInventoryItem(result.inventoryItemInstance)

        // Success
        return result

    } // end prepareShowData()

} // end class
