<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
        <meta name="layout" content="main" />
        <title>Show Task</title>
        <g:javascript src="overlayPane.js" />
        <nav:resources override="true"/>
        <resource:tabView skin="tabviewCustom" />
    </head>
    <body>
        <div class="nav">
            <nav:renderSubItems group="nav"/>
        </div>
        <div class="body">
            <g:if test="${flash.message}">
            <div class="message">${flash.message}</div>
            </g:if>
            <g:hasErrors bean="${taskInstance}">
            <div class="errors">
                <g:renderErrors bean="${taskInstance}" as="list" />
            </div>
            </g:hasErrors>

            <richui:tabView id="tabView">

                <richui:tabLabels>
                    <richui:tabLabel selected="${showTaskTab}" title="Task #${taskInstance.id}" />
                    <richui:tabLabel selected="${showProcedureTab}" title="Procedure" />
                    <richui:tabLabel selected="${showRecurrenceTab}" title="Recurrence" />
                    <richui:tabLabel selected="${showInventoryTab}" title="Inventory" />
                    <richui:tabLabel selected="${showSubTasksTab}" title="Sub Tasks" />
                </richui:tabLabels>

                <richui:tabContents>

<!-- Start Task tab -->
                    <richui:tabContent>

                        <div class="dialog">
                            <table>
                                <tbody>

                                    <tr class="prop">
                                        <td valign="top" class="name">Description:</td>

                                        <td valign="top" class="value">${fieldValue(bean:taskInstance, field:'description')}</td>

                                    </tr>

                                    <tr class="prop">
                                        <td valign="top" class="name">Comment:</td>

                                        <td valign="top" class="value">${fieldValue(bean:taskInstance, field:'comment')}</td>

                                    </tr>

                                    <tr class="prop">
                                        <td valign="top" class="name">Target Start:</td>

                                        <td valign="top" class="value"><g:formatDate date="${taskInstance.targetStartDate}" format="EEE, dd-MMM-yyyy"/></td>

                                    </tr>

                                    <tr class="prop">
                                        <td valign="top" class="name">Target Completion:</td>

                                        <td valign="top" class="value"><g:formatDate date="${taskInstance.targetCompletionDate}" format="EEE, dd-MMM-yyyy"/></td>

                                    </tr>

                                    <tr class="prop">
                                        <td valign="top" class="name">
                                            <div id="modControlClosed">
                                                <a href='' onclick="showElement('modifications');
                                                                                    showElement('modControlOpened');
                                                                                    hideElement('modControlClosed'); return false;">
                                                    Modifications <img  src="${resource(dir:'images/skin',file:'sorted_asc.gif')}" alt="Show" />
                                                </a>
                                            </div>
                                            <div id="modControlOpened" style="display:none;">
                                                <a href='' onclick="hideElement('modifications');
                                                                                    hideElement('modControlOpened');
                                                                                    showElement('modControlClosed');
                                                                                    return false;">
                                                    Modifications <img  src="${resource(dir:'images/skin',file:'sorted_desc.gif')}" alt="Show" />
                                                </a>
                                            </div>
                                        </td>

                                        <td  valign="top" style="text-align:left;" class="value">
                                            <div id="modifications" style="display:none;">
                                                <ul>
                                                <g:each var="a" in="${taskModificationList}">
                                                    <li>${a?.encodeAsHTML()}</li>
                                                </g:each>
                                                </ul>
                                            </div>
                                        </td>
                                    </tr>


                                    <tr class="prop">
                                        <td valign="top" class="name">Lead Person:</td>

                                        <td valign="top" class="value">${taskInstance?.leadPerson?.encodeAsHTML()}</td>

                                    </tr>

                                    <tr class="prop">
                                        <td valign="top" class="name">Primary Asset:</td>

                                        <td valign="top" class="value"><g:link controller="assetDetailed" action="show" id="${taskInstance?.primaryAsset?.id}">${taskInstance?.primaryAsset?.encodeAsHTML()}</g:link></td>

                                    </tr>

                                    <tr class="prop">
                                        <td valign="top" class="name">Associated Assets:</td>

                                        <td  valign="top" style="text-align:left;" class="value">
                                            <ul>
                                            <g:each var="a" in="${taskInstance.associatedAssets}">
                                                <li>${a?.encodeAsHTML()}</li>
                                            </g:each>
                                            </ul>
                                        </td>

                                    </tr>

                                    <tr class="prop">
                                        <td valign="top" class="name">Priority:</td>

                                        <td valign="top" class="value">${taskInstance?.taskPriority?.encodeAsHTML()}</td>

                                    </tr>

                                    <tr class="prop">
                                        <td valign="top" class="name">Status:</td>

                                        <td valign="top" class="value">${taskInstance?.taskStatus?.encodeAsHTML()}</td>

                                    </tr>

                                    <tr class="prop">
                                        <td valign="top" class="name">Active:</td>

                                        <td valign="top" class="value">${fieldValue(bean:taskInstance, field:'isActive')}</td>

                                    </tr>

                                    <tr class="prop">
                                        <td valign="top" class="name">Approved:</td>

                                        <td valign="top" class="value">${fieldValue(bean:taskInstance, field:'isApproved')}</td>

                                    </tr>

                                    <tr class="prop">
                                        <td valign="top" class="name">Scheduled:</td>

                                        <td valign="top" class="value">${fieldValue(bean:taskInstance, field:'isScheduled')}</td>

                                    </tr>

                                    <tr class="prop">
                                        <td valign="top" class="name">Parent Task:</td>

                                        <td valign="top" class="value"><g:link controller="taskDetailed" action="show" id="${taskInstance?.parentTask?.id}">${taskInstance?.parentTask?.encodeAsHTML()}</g:link></td>

                                    </tr>

                                    <tr class="prop">
                                        <td valign="top" class="name">Group:</td>

                                        <td valign="top" class="value">${taskInstance?.taskGroup?.encodeAsHTML()}</td>

                                    </tr>

                                    <tr class="prop">
                                        <td valign="top" class="name">Type:</td>

                                        <td valign="top" class="value">${taskInstance?.taskType?.encodeAsHTML()}</td>

                                    </tr>

                                    <tr class="prop">
                                        <td valign="top" class="name">Assigned Persons:</td>

                                        <td  valign="top" style="text-align:left;" class="value">
                                            <ul>
                                            <g:each var="a" in="${taskInstance.assignedPersons}">
                                                <li><g:link controller="assignedPersonDetailed" action="edit" id="${a.id}">${a?.encodeAsHTML()}</g:link></li>
                                            </g:each>
                                            </ul>
                                            <g:link controller="assignedPersonDetailed" params="['task.id':taskInstance?.id]" action="create">Add AssignedPerson</g:link>
                                        </td>

                                    </tr>

                                </tbody>
                            </table>
                        </div>

                        <div class="buttons">
                            <g:form>
                                <input type="hidden" name="id" value="${taskInstance?.id}" />
                                <span class="button"><g:actionSubmit class="edit" value="Edit" /></span>
                                <span class="button"><g:actionSubmit class="delete" onclick="return confirm('Are you sure?');" value="Delete" /></span>
                            </g:form>
                        </div>

                        <div class="list">
                            <h1>Faults</h1>
                            <table>
                                <thead>
                                    <tr>
                                        <th>Comment</th>
                                        <th>Date Done</th>
                                        <th>Duration</th>
                                        <th>Entered By</th>
                                        <th></th>
                                    </tr>
                                </thead>
                                <tbody>
                                <g:each in="${entryFaultList}" status="i" var="entry">
                                        <tr class="${(i % 2) == 0 ? 'clickableOdd' : 'clickableEven'}" onclick='window.location = "${request.getContextPath()}/entryDetailed/edit/${entry.id}"'/>

                                            <td style="width:65%">${entry.comment}</td>
                                            <td><g:formatDate date="${entry.dateDone}" format="EEE, dd-MMM-yyyy"/></td>
                                            <td>${entry.durationHour}:${entry.durationMinute}</td>
                                            <td>${entry.enteredBy}</td>

                                            <td>
                                                <g:link controller="entryDetailed" action="edit" id="${entry.id}">
                                                    <img  src="${resource(dir:'images/skin',file:'database_edit.png')}" alt="Edit" />
                                                </g:link>
                                            </td>

                                        </tr>
                                </g:each>
                                </tbody>
                            </table>
                        </div>

                        <div class="list">
                            <h1>Work Done</h1>
                            <table>
                                <thead>
                                    <tr>
                                        <th>Comment</th>
                                        <th>Date Done</th>
                                        <th>Duration</th>
                                        <th>Entered By</th>
                                        <th></th>

            <!--                            <g:sortableColumn property="commentW" title="Comment" />

                                        <g:sortableColumn property="dateDoneW" title="Date Done" />

                                        <g:sortableColumn property="enteredByW" title="Entered By" />-->
                                    </tr>
                                </thead>
                                <tbody>
                                <g:each in="${entryWorkDoneList}" status="i" var="entry">
                                        <tr class="${(i % 2) == 0 ? 'clickableOdd' : 'clickableEven'}" onclick='window.location = "${request.getContextPath()}/entryDetailed/edit/${entry.id}"'/>

                                            <td width="65%">${entry.comment}</td>
                                            <td><g:formatDate date="${entry.dateDone}" format="EEE, dd-MMM-yyyy"/></td>
                                            <td>${entry.durationHour}:${entry.durationMinute}</td>
                                            <td>${entry.enteredBy}</td>

                                            <td>
                                                <g:link controller="entryDetailed" action="edit" id="${entry.id}">
                                                    <img  src="${resource(dir:'images/skin',file:'database_edit.png')}" alt="Edit" />
                                                </g:link>
                                            </td>

                                        </tr>
                                </g:each>
                                </tbody>
                            </table>
                        </div>

                        <br />

                        <div class="buttons">
                            <g:form controller="entryDetailed">
                                <input type="hidden" name="taskInstance.id" value="${taskInstance?.id}" />
                                <span class="button">
                                    <g:actionSubmit value="Add Entry" action="create"  class="add"/>
                                </span>
                            </g:form>
                        </div>
                    </richui:tabContent>
<!-- End Task tab -->


<!-- Start Task Procedure tab-->
                    <richui:tabContent>
                        <g:if test="${!taskProcedureExits}">
                            <br />
                            No Procedure linked.
                            <br />
                            <br />
                            <g:form controller="taskProcedureDetailed" >
                                <input type="hidden" name="taskInstance.id" value="${taskInstance?.id}" />

                                <div class="buttons">
                                    <span class="button">
                                        <g:actionSubmit value="New" action="create" class="add"/>
                                    </span>
                                    <span class="button">
                                        <g:actionSubmit value="Search" action="search" class="search"/>
                                    </span>
                                </div>

                            </g:form>

                        </g:if>
                        <g:else>
                            <div class="dialog">
                                <table>
                                    <tbody>

                                        <tr class="prop">
                                            <td valign="top" class="name">Procedure Id:</td>

                                            <td valign="top" class="value">${fieldValue(bean:taskProcedureInstance, field:'id')}</td>

                                        </tr>

                                        <tr class="prop">
                                            <td valign="top" class="name">Name:</td>

                                            <td valign="top" class="value">${fieldValue(bean:taskProcedureInstance, field:'name')}</td>

                                        </tr>

                                        <tr class="prop">
                                            <td valign="top" class="name">Description:</td>

                                            <td valign="top" class="value">${fieldValue(bean:taskProcedureInstance, field:'description')}</td>

                                        </tr>

                                        <tr class="prop">
                                            <td valign="top" class="name">Is Active:</td>

                                            <td valign="top" class="value">${fieldValue(bean:taskProcedureInstance, field:'isActive')}</td>

                                        </tr>

                                    </tbody>
                                </table>
                            </div>
                            <div class="buttons">
                                <g:form controller="taskProcedureDetailed">
                                    <input type="hidden" name="id" value="${taskProcedureInstance?.id}" />
                                    <span class="button"><g:actionSubmit class="edit" value="Edit" /></span>
                                </g:form>
                            </div>

                            <div class="list">
                                <table>
                                    <thead>
                                        <tr>
                                            <th>Step</th>
                                            <th>Description</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <g:each in="${maintenanceActionList}" status="i" var="maintenanceAction">
                                            <tr class="${(i % 2) == 0 ? 'odd' : 'even'}">

                                                <td valign="top" class="name">
                                                    ${maintenanceAction?.procedureStepNumber}
                                                </td>

                                                <td  valign="top" style="text-align:left;" class="value">
                                                    ${maintenanceAction?.description}
                                                </td>

                                            </tr>
                                        </g:each>

                                    </tbody>
                                </table>
                            </div>

                        </g:else>

                    </richui:tabContent>
<!-- End Task Procedure tab-->

<!-- Start Task Recurrence tab -->
                    <richui:tabContent>

                        <g:if test="${!taskRecurringScheduleExits}">
                            <br />
                            No Recurring Schedule.
                            <br />
                            <br />
                            <g:form controller="taskRecurringScheduleDetailed" >
                                <input type="hidden" name="taskInstance.id" value="${taskInstance?.id}" />

                                <div class="buttons">
                                    <span class="button">
                                        <g:actionSubmit value="Create" action="create"  class="add"/>
                                    </span>
                                </div>

                            </g:form>

                        </g:if>
                        <g:else>

                        <div class="dialog">
                                <table>
                                    <tbody>
                                        <tr class="prop">
                                            <td valign="top" class="name">Recurring Schedule:</td>

                                            <td valign="top" class="value">${taskRecurringScheduleInstance.encodeAsHTML()}</td>

                                        </tr>

                                        <tr class="prop">
                                            <td valign="top" class="name">Start Date:</td>

                                            <td valign="top" class="value">
                                                <g:formatDate date="${taskRecurringScheduleInstance.startDate}" format="EEE, dd-MMM-yyyy"/>
                                            </td>

                                        </tr>

                                        <tr class="prop">
                                            <td valign="top" class="name">Task Duration:</td>

                                            <td valign="top" class="value">
                                                ${taskRecurringScheduleInstance?.taskDuration} ${taskRecurringScheduleInstance?.taskDurationPeriod}
                                            </td>
                                        </tr>

                                        <tr class="prop">
                                            <td valign="top" class="name">Generate Ahead:</td>

                                            <td valign="top" class="value">
                                                ${taskRecurringScheduleInstance?.generateAhead} ${taskRecurringScheduleInstance?.generateAheadPeriod}
                                            </td>

                                        </tr>

                                        </tr>

                                        <tr class="prop">
                                            <td valign="top" class="name">Is Enabled:</td>

                                            <td valign="top" class="value">${fieldValue(bean:taskRecurringScheduleInstance, field:'isEnabled')}</td>

                                        </tr>

                                    </tbody>
                                </table>

                                <table>
                                    <tbody>

                                        <tr class="prop">
                                            <td valign="top" class="name">Next Target Start Date:</td>   

                                            <td valign="top" class="value">
                                                <g:formatDate date="${taskRecurringScheduleInstance.nextTargetStartDate}" format="EEE, dd-MMM-yyyy"/>
                                            </td>

                                        </tr>

                                        <tr class="prop">
                                            <td valign="top" class="name">Next Target Completion Date:</td>   

                                            <td valign="top" class="value">
                                                <g:formatDate date="${taskRecurringScheduleInstance.nextTargetCompletionDate}" format="EEE, dd-MMM-yyyy"/>
                                            </td>

                                        </tr>

                                        <tr class="prop">
                                            <td valign="top" class="name">Next Generation Date:</td>

                                            <td valign="top" class="value">
                                                <g:formatDate date="${taskRecurringScheduleInstance.nextGenerationDate}" format="EEE, dd-MMM-yyyy"/>
                                            </td>
                                        </tr>

                                        <tr class="prop">
                                            <td valign="top" class="name">Last Generated Date:</td>

                                            <td valign="top" class="value">
                                                <g:formatDate date="${taskRecurringScheduleInstance.lastGeneratedDate}" format="EEE, dd-MMM-yyyy"/>
                                            </td>

                                        </tr>

                                        <tr class="prop">
                                            <td valign="top" class="name">Last Generated Sub Task:</td>

                                            <td valign="top" class="value">
                                                <g:link controller="taskDetailed" action="show" id="${taskRecurringScheduleInstance?.lastGeneratedSubTask?.id}">
                                                    ${taskRecurringScheduleInstance?.lastGeneratedSubTask?.encodeAsHTML()}
                                                </g:link>
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                            <div class="buttons">
                                <g:form controller="taskRecurringScheduleDetailed">
                                    <input type="hidden" name="id" value="${taskRecurringScheduleInstance?.id}" />
                                    <span class="button"><g:actionSubmit class="edit" value="Edit" /></span>
                                </g:form>
                            </div>

                        </g:else>
                    </richui:tabContent>
<!-- End Task Recurrence tab -->

<!-- Start Inventory tab -->
                    <richui:tabContent>

                        <g:if test="${inventoryMovementList.isEmpty()}">
                            <br />
                            No Inventory Used.
                            <br />
                            <br />
                        </g:if>
                        <g:else>
                            <div class="list">
                                <table>
                                    <thead>
                                        <tr>
                                            <th>Inventory Item</th>
                                            <th>Quantity</th>
                                            <th>Movement Type</th>
                                            <th>Date</th>
                                            <th></th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <g:each in="${inventoryMovementList}" status="i" var="inventoryMovementInstance">
                                            <tr class="${(i % 2) == 0 ? 'clickableOdd' : 'clickableEven'}" onclick='window.location = "${request.getContextPath()}/inventoryMovementDetailed/show/${inventoryMovementInstance.id}"'/>

                                                <td>${fieldValue(bean:inventoryMovementInstance, field:'inventoryItem')}</td>
                                                <td>${fieldValue(bean:inventoryMovementInstance, field:'quantity')}</td>
                                                <td>${fieldValue(bean:inventoryMovementInstance, field:'inventoryMovementType')}</td>
                                                <td><g:formatDate date="${inventoryMovementInstance.date}" format="EEE, dd-MMM-yyyy"/></td>
                                                <td>
                                                    <g:link controller="inventoryMovementDetailed" action="show" id="${inventoryMovementInstance.id}">
                                                        <img  src="${resource(dir:'images/skin',file:'database_go.png')}" alt="Show" />
                                                    </g:link>
                                                </td>

                                            </tr>
                                        </g:each>
                                    </tbody>
                                </table>
                            </div>
                        </g:else>

                        <g:form controller="inventoryMovementDetailed" >
                            <input type="hidden" name="task.id" value="${taskInstance?.id}" />
                            <div class="buttons">
                                <g:if test="${!inventoryMovementList.isEmpty()}">
                                    Results: ${inventoryMovementList.size()}
                                    <br />
                                </g:if>
                                <span class="button">
                                    <g:actionSubmit value="Add" action="create"  class="add"/>
                                </span>
                            </div>
                        </g:form>

                    </richui:tabContent>
<!-- End Inventory tab -->

<!-- Start Sub Task tab -->
                    <richui:tabContent>
                        <g:if test="${subTaskInstanceTotal >= 1}">
                            <div class="list">
                                <table>
                                    <thead>
                                        <tr>

                                            <th>Id</th>

                                            <th>Target Start Date</th>

                                            <th>Description</th>

                                            <th>Lead Person</th>

                                            <th>Task Priority</th>

                                            <th>Task Status</th>

                                            <th></th>

                                        </tr>
                                    </thead>
                                    <tbody>
                                    <g:each in="${subTaskInstanceList}" status="i" var="subTaskInstance">
                                    <tr class="${(i % 2) == 0 ? 'clickableOdd' : 'clickableEven'}" onclick='window.location = "${request.getContextPath()}/taskDetailed/show/${subTaskInstance.id}"'/>

                                            <td>${fieldValue(bean:subTaskInstance, field:'id')}</td>

                                            <td><g:formatDate date="${subTaskInstance.targetStartDate}" format="EEE, dd-MMM-yyyy"/></td>

                                            <td>${subTaskInstance.description}</td>


                                            <td>${subTaskInstance.leadPerson}</td>

                                            <td>${subTaskInstance.taskPriority}</td>

                                            <td>${subTaskInstance.taskStatus}</td>

                                            <td>
                                                <g:link action="show" id="${subTaskInstance.id}">
                                                    <img  src="${resource(dir:'images/skin',file:'database_go.png')}" alt="Show" />
                                                </g:link>
                                            </td>

                                        </tr>
                                    </g:each>
                                    </tbody>
                                </table>
                            </div>

                            <div class="buttons">
                                <g:form>
                                    <input type="hidden" name="id" value="${taskInstance?.id}" />
                                    <g:if test="${subTaskInstanceTotal > subTaskInstanceMax}">
                                        Showing ${subTaskInstanceMax} of ${subTaskInstanceTotal}
                                        <br />
                                    </g:if>
                                    <g:else>
                                        Total ${subTaskInstanceTotal}
                                        <br />
                                    </g:else>
                                    <span class="button"><g:actionSubmit action="listSubTasks" class="table" value="Sortable List" /></span>
                                </g:form>
                            </div>

                        </g:if>
                        <g:else>
                            <br />
                            No Sub Tasks.
                        </g:else>

                    </richui:tabContent>
<!-- End Sub Task tab -->

                </richui:tabContents>
            </richui:tabView>

        </div>
    </body>
</html>
