class  InventoryItem {
    InventoryGroup inventoryGroup
    InventoryType inventoryType
    UnitOfMeasure unitOfMeasure
    InventoryLocation inventoryLocation
    Period averageDeliveryPeriod
    String name
    String description = ""
    String manufacturersPartNumber
    String suppliersPartNumber
    Integer unitsInStock = 0
    Integer reorderPoint
    Integer recommendedReorderPoint
    Integer averageDeliveryTime
    boolean isActive = true
    boolean isObsolete = false
    boolean enableReorder = true

    static hasMany = [alternateItems: InventoryItem,
                                    spareFor: Asset,
                                    inventoryMovements: InventoryMovement,
                                    manufacturers: Manufacturer,
                                    suppliers: Supplier]

//     static belongsTo = []

    static constraints = {
        name(unique:true, blank:false, maxSize:50)
        description()
        unitsInStock(min:0)
        unitOfMeasure()
        reorderPoint()
        enableReorder()
        recommendedReorderPoint(nullable:true)
        isActive()
        isObsolete()
        inventoryGroup()
        inventoryType()
        manufacturersPartNumber(blank:true, nullable:true)
        suppliersPartNumber(blank:true, nullable:true)
        averageDeliveryTime(nullable:true)
        averageDeliveryPeriod(nullable:true)
    }

    String toString() {"${this.name}"}
}
        
