<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
        <meta name="layout" content="main" />
        <title>Task Search</title>
        <nav:resources override="true"/>
        <resource:tabView skin="tabviewCustom" />
    </head>
    <body>
        <div class="nav">
            <nav:renderSubItems group="nav"/>
        </div>
        
        <div class="body">
            <g:if test="${flash.message}">
                <div class="message">${flash.message}</div>
            </g:if>
            <g:hasErrors bean="${appCore}">
                <div class="errors">
                    <g:renderErrors bean="${appCore}" as="list" />
                </div>
            </g:hasErrors>

            <richui:tabView id="tabView">

                <richui:tabLabels>
                    <richui:tabLabel selected="true" title="Quick" />
                    <richui:tabLabel selected="${0}" title="Basic" />
                    <richui:tabLabel selected="${0}" title="Advanced" />
                </richui:tabLabels>

                <richui:tabContents>

<!-- Quick tab -->
                    <richui:tabContent>
                        <br />
                        <br />
                        <g:form controller="taskDetailed">
                            Task ID:
                            <input type="text" name="id" value="${taskInstance?.id}" />
                            <span class="button"><g:actionSubmit class="show" value="Show" /></span>
                        </g:form>
                        <br />
                        <br />
                        Show:
                        <g:link action="searchShowAll">Active</g:link>
                        /
                        <g:link action="searchShowDeleted">Inactive</g:link>
                    </richui:tabContent>
<!-- End Quick tab -->

<!-- Basic tab -->
                    <richui:tabContent>
                        <br />
                        <br />

                    </richui:tabContent>
<!-- End Basic tab  -->

<!-- Advanced tab -->
                    <richui:tabContent>
                        <br />
                        <br />
                    </richui:tabContent>
<!-- End Advanced tab -->

                </richui:tabContents>
            </richui:tabView>
            
            <div class="list">
                <table>
                    <thead>
                        <tr>
                        
                   	        <g:sortableColumn property="id" title="Id" />
                        
                   	        <g:sortableColumn property="targetStartDate" title="Target Start Date" />
                        
                   	        <g:sortableColumn property="description" title="Description" />
                        
                   	        <g:sortableColumn  property="leadPerson" title="Lead Person" />
                        
                            <g:sortableColumn  property="taskPriority" title="Task Priority" />
                        
                            <g:sortableColumn  property="taskStatus" title="Task Status" />

                            <th></th>
                   	    
                        </tr>
                    </thead>
                    <tbody>
                    <g:each in="${taskInstanceList}" status="i" var="taskInstance">
                    <tr class="${(i % 2) == 0 ? 'clickableOdd' : 'clickableEven'}" onclick='window.location = "${request.getContextPath()}/taskDetailed/show/${taskInstance.id}"'/>

                            <td>${fieldValue(bean:taskInstance, field:'id')}</td>
                        
                            <td><g:formatDate date="${taskInstance.targetStartDate}" format="EEE, dd-MMM-yyyy"/></td>
                        
                            <td>${fieldValue(bean:taskInstance, field:'description')}</td>
                        
                            <td>${fieldValue(bean:taskInstance, field:'leadPerson')}</td>
                        
                            <td>${fieldValue(bean:taskInstance, field:'taskPriority')}</td>
                        
                            <td>${fieldValue(bean:taskInstance, field:'taskStatus')}</td>

                            <td>
                                <g:link action="show" id="${taskInstance.id}">
                                    <img  src="${createLinkTo(dir:'images/skin',file:'database_go.png')}" alt="Show" />
                                </g:link>
                            </td>
                        
                        </tr>
                    </g:each>
                    </tbody>
                </table>
            </div>
            <div class="paginateButtons">
                <g:paginate total="${taskInstanceTotal}" />
            </div>
            
        </div> <!-- end body div -->
    </body>
</html>
