

<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
        <meta name="layout" content="main" />
        <title>Edit TaskAction</title>
    </head>
    <body>
        <div class="nav">
            <span class="menuButton"><a class="home" href="${createLinkTo(dir:'')}">Home</a></span>
            <span class="menuButton"><g:link class="list" action="list">TaskAction List</g:link></span>
            <span class="menuButton"><g:link class="create" action="create">New TaskAction</g:link></span>
        </div>
        <div class="body">
            <h1>Edit TaskAction</h1>
            <g:if test="${flash.message}">
            <div class="message">${flash.message}</div>
            </g:if>
            <g:hasErrors bean="${taskActionInstance}">
            <div class="errors">
                <g:renderErrors bean="${taskActionInstance}" as="list" />
            </div>
            </g:hasErrors>
            <g:form method="post" >
                <input type="hidden" name="id" value="${taskActionInstance?.id}" />
                <input type="hidden" name="version" value="${taskActionInstance?.version}" />
                <div class="dialog">
                    <table>
                        <tbody>
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="systemSection">System Section:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:taskActionInstance,field:'systemSection','errors')}">
                                    <g:select optionKey="id" from="${SystemSection.list()}" name="systemSection.id" value="${taskActionInstance?.systemSection?.id}" noSelection="['null':'']"></g:select>
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="asset">Asset:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:taskActionInstance,field:'asset','errors')}">
                                    <g:select optionKey="id" from="${Asset.list()}" name="asset.id" value="${taskActionInstance?.asset?.id}" noSelection="['null':'']"></g:select>
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="assetType">Asset Type:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:taskActionInstance,field:'assetType','errors')}">
                                    <g:select optionKey="id" from="${AssetType.list()}" name="assetType.id" value="${taskActionInstance?.assetType?.id}" noSelection="['null':'']"></g:select>
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="assembly">Assembly:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:taskActionInstance,field:'assembly','errors')}">
                                    <g:select optionKey="id" from="${Assembly.list()}" name="assembly.id" value="${taskActionInstance?.assembly?.id}" noSelection="['null':'']"></g:select>
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="subAssembly">Sub Assembly:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:taskActionInstance,field:'subAssembly','errors')}">
                                    <g:select optionKey="id" from="${SubAssembly.list()}" name="subAssembly.id" value="${taskActionInstance?.subAssembly?.id}" noSelection="['null':'']"></g:select>
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="componentItem">Component Item:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:taskActionInstance,field:'componentItem','errors')}">
                                    <g:select optionKey="id" from="${ComponentItem.list()}" name="componentItem.id" value="${taskActionInstance?.componentItem?.id}" noSelection="['null':'']"></g:select>
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="stepNumber">Step Number:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:taskActionInstance,field:'stepNumber','errors')}">
                                    <input type="text" id="stepNumber" name="stepNumber" value="${fieldValue(bean:taskActionInstance,field:'stepNumber')}" />
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="action">Action:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:taskActionInstance,field:'action','errors')}">
                                    <input type="text" id="action" name="action" value="${fieldValue(bean:taskActionInstance,field:'action')}"/>
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="isActive">Is Active:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:taskActionInstance,field:'isActive','errors')}">
                                    <g:checkBox name="isActive" value="${taskActionInstance?.isActive}" ></g:checkBox>
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="maintenancePolicy">Maintenance Policy:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:taskActionInstance,field:'maintenancePolicy','errors')}">
                                    <g:select optionKey="id" from="${MaintenancePolicy.list()}" name="maintenancePolicy.id" value="${taskActionInstance?.maintenancePolicy?.id}" ></g:select>
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="reasoning">Reasoning:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:taskActionInstance,field:'reasoning','errors')}">
                                    <input type="text" id="reasoning" name="reasoning" value="${fieldValue(bean:taskActionInstance,field:'reasoning')}"/>
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="task">Task:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:taskActionInstance,field:'task','errors')}">
                                    <g:select optionKey="id" from="${Task.list()}" name="task.id" value="${taskActionInstance?.task?.id}" ></g:select>
                                </td>
                            </tr> 
                        
                        </tbody>
                    </table>
                </div>
                <div class="buttons">
                    <span class="button"><g:actionSubmit class="save" value="Update" /></span>
                    <span class="button"><g:actionSubmit class="delete" onclick="return confirm('Are you sure?');" value="Delete" /></span>
                </div>
            </g:form>
        </div>
    </body>
</html>
