import org.codehaus.groovy.grails.plugins.springsecurity.Secured

class RecurringScheduleController extends BaseAppAdminController {
    
    def index = { redirect(action:list,params:params) }

    // the delete, save and update actions only accept POST requests
    static allowedMethods = [delete:'POST', save:'POST', update:'POST']

    def list = {
        params.max = Math.min( params.max ? params.max.toInteger() : 10,  100)
        [ recurringScheduleInstanceList: RecurringSchedule.list( params ), recurringScheduleInstanceTotal: RecurringSchedule.count() ]
    }

    def show = {
        def recurringScheduleInstance = RecurringSchedule.get( params.id )

        if(!recurringScheduleInstance) {
            flash.message = "RecurringSchedule not found with id ${params.id}"
            redirect(action:list)
        }
        else { return [ recurringScheduleInstance : recurringScheduleInstance ] }
    }

    def delete = {
        def recurringScheduleInstance = RecurringSchedule.get( params.id )
        if(recurringScheduleInstance) {
            try {
                recurringScheduleInstance.delete()
                flash.message = "RecurringSchedule ${params.id} deleted"
                redirect(action:list)
            }
            catch(org.springframework.dao.DataIntegrityViolationException e) {
                flash.message = "RecurringSchedule ${params.id} could not be deleted"
                redirect(action:show,id:params.id)
            }
        }
        else {
            flash.message = "RecurringSchedule not found with id ${params.id}"
            redirect(action:list)
        }
    }

    def edit = {
        def recurringScheduleInstance = RecurringSchedule.get( params.id )

        if(!recurringScheduleInstance) {
            flash.message = "RecurringSchedule not found with id ${params.id}"
            redirect(action:list)
        }
        else {
            return [ recurringScheduleInstance : recurringScheduleInstance ]
        }
    }

    def update = {
        def recurringScheduleInstance = RecurringSchedule.get( params.id )
        if(recurringScheduleInstance) {
            if(params.version) {
                def version = params.version.toLong()
                if(recurringScheduleInstance.version > version) {
                    
                    recurringScheduleInstance.errors.rejectValue("version", "recurringSchedule.optimistic.locking.failure", "Another user has updated this RecurringSchedule while you were editing.")
                    render(view:'edit',model:[recurringScheduleInstance:recurringScheduleInstance])
                    return
                }
            }
            recurringScheduleInstance.properties = params
            if(!recurringScheduleInstance.hasErrors() && recurringScheduleInstance.save()) {
                flash.message = "RecurringSchedule ${params.id} updated"
                redirect(action:show,id:recurringScheduleInstance.id)
            }
            else {
                render(view:'edit',model:[recurringScheduleInstance:recurringScheduleInstance])
            }
        }
        else {
            flash.message = "RecurringSchedule not found with id ${params.id}"
            redirect(action:edit,id:params.id)
        }
    }

    def create = {
        def recurringScheduleInstance = new RecurringSchedule()
        recurringScheduleInstance.properties = params
        return ['recurringScheduleInstance':recurringScheduleInstance]
    }

    def save = {
        def recurringScheduleInstance = new RecurringSchedule(params)
        if(!recurringScheduleInstance.hasErrors() && recurringScheduleInstance.save()) {
            flash.message = "RecurringSchedule ${recurringScheduleInstance.id} created"
            redirect(action:show,id:recurringScheduleInstance.id)
        }
        else {
            render(view:'create',model:[recurringScheduleInstance:recurringScheduleInstance])
        }
    }
}
