

<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
        <meta name="layout" content="main" />
        <title>Edit Asset</title>
    </head>
    <body>
        <div class="nav">
            <span class="menuButton"><a class="home" href="${createLinkTo(dir:'')}">Home</a></span>
            <span class="menuButton"><g:link class="list" action="list">Asset List</g:link></span>
            <span class="menuButton"><g:link class="create" action="create">New Asset</g:link></span>
        </div>
        <div class="body">
            <h1>Edit Asset</h1>
            <g:if test="${flash.message}">
            <div class="message">${flash.message}</div>
            </g:if>
            <g:hasErrors bean="${assetInstance}">
            <div class="errors">
                <g:renderErrors bean="${assetInstance}" as="list" />
            </div>
            </g:hasErrors>
            <g:form method="post" >
                <input type="hidden" name="id" value="${assetInstance?.id}" />
                <input type="hidden" name="version" value="${assetInstance?.version}" />
                <div class="dialog">
                    <table>
                        <tbody>
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="assetType">Asset Type:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:assetInstance,field:'assetType','errors')}">
                                    <g:select optionKey="id" from="${AssetType.list()}" name="assetType.id" value="${assetInstance?.assetType?.id}" ></g:select>
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="description">Description:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:assetInstance,field:'description','errors')}">
                                    <input type="text" id="description" name="description" value="${fieldValue(bean:assetInstance,field:'description')}"/>
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="isActive">Is Active:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:assetInstance,field:'isActive','errors')}">
                                    <g:checkBox name="isActive" value="${assetInstance?.isActive}" ></g:checkBox>
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="maintenanceActions">Maintenance Actions:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:assetInstance,field:'maintenanceActions','errors')}">
                                    
<ul>
<g:each var="m" in="${assetInstance?.maintenanceActions?}">
    <li><g:link controller="maintenanceAction" action="show" id="${m.id}">${m?.encodeAsHTML()}</g:link></li>
</g:each>
</ul>
<g:link controller="maintenanceAction" params="['asset.id':assetInstance?.id]" action="create">Add MaintenanceAction</g:link>

                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="name">Name:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:assetInstance,field:'name','errors')}">
                                    <input type="text" id="name" name="name" value="${fieldValue(bean:assetInstance,field:'name')}"/>
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="systemSection">System Section:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:assetInstance,field:'systemSection','errors')}">
                                    <g:select optionKey="id" from="${SystemSection.list()}" name="systemSection.id" value="${assetInstance?.systemSection?.id}" ></g:select>
                                </td>
                            </tr> 
                        
                        </tbody>
                    </table>
                </div>
                <div class="buttons">
                    <span class="button"><g:actionSubmit class="save" value="Update" /></span>
                    <span class="button"><g:actionSubmit class="delete" onclick="return confirm('Are you sure?');" value="Delete" /></span>
                </div>
            </g:form>
        </div>
    </body>
</html>
