import org.codehaus.groovy.grails.plugins.springsecurity.Secured

class TaskGroupController extends BaseAppAdminController {
    
    def index = { redirect(action:list,params:params) }

    // the delete, save and update actions only accept POST requests
    static allowedMethods = [delete:'POST', save:'POST', update:'POST']

    def list = {
        if(!params.max) params.max = 10
        [ taskGroupInstanceList: TaskGroup.list( params ) ]
    }

    def show = {
        def taskGroupInstance = TaskGroup.get( params.id )

        if(!taskGroupInstance) {
            flash.message = "TaskGroup not found with id ${params.id}"
            redirect(action:list)
        }
        else { return [ taskGroupInstance : taskGroupInstance ] }
    }

    def delete = {
        def taskGroupInstance = TaskGroup.get( params.id )
        if(taskGroupInstance) {
            taskGroupInstance.delete()
            flash.message = "TaskGroup ${params.id} deleted"
            redirect(action:list)
        }
        else {
            flash.message = "TaskGroup not found with id ${params.id}"
            redirect(action:list)
        }
    }

    def edit = {
        def taskGroupInstance = TaskGroup.get( params.id )

        if(!taskGroupInstance) {
            flash.message = "TaskGroup not found with id ${params.id}"
            redirect(action:list)
        }
        else {
            return [ taskGroupInstance : taskGroupInstance ]
        }
    }

    def update = {
        def taskGroupInstance = TaskGroup.get( params.id )
        if(taskGroupInstance) {
            taskGroupInstance.properties = params
            if(!taskGroupInstance.hasErrors() && taskGroupInstance.save()) {
                flash.message = "TaskGroup ${params.id} updated"
                redirect(action:show,id:taskGroupInstance.id)
            }
            else {
                render(view:'edit',model:[taskGroupInstance:taskGroupInstance])
            }
        }
        else {
            flash.message = "TaskGroup not found with id ${params.id}"
            redirect(action:edit,id:params.id)
        }
    }

    def create = {
        def taskGroupInstance = new TaskGroup()
        taskGroupInstance.properties = params
        return ['taskGroupInstance':taskGroupInstance]
    }

    def save = {
        def taskGroupInstance = new TaskGroup(params)
        if(!taskGroupInstance.hasErrors() && taskGroupInstance.save()) {
            flash.message = "TaskGroup ${taskGroupInstance.id} created"
            redirect(action:show,id:taskGroupInstance.id)
        }
        else {
            render(view:'create',model:[taskGroupInstance:taskGroupInstance])
        }
    }
}
