<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
        <meta name="layout" content="main" />
        <title>InventoryStore List</title>
        <filterpane:includes />
        <nav:resources override="true"/>
    </head>
    <body>
        <div class="nav">
            <nav:renderSubItems group="navAlt"/>
        </div>
        <div class="body">
            <g:render template="/shared/messages" />

            <filterpane:currentCriteria domainBean="InventoryStore"
                                        action="list"
                                        dateFormat="EEE, dd-MMM-yyyy"
                                        removeImgDir="images"
                                        removeImgFile="bullet_delete.png"
                                        title="Search"/>

            <div class="paginateButtons">
                Results: ${inventoryStoreInstanceList.size()} / ${inventoryStoreInstanceTotal}
                <span class="searchButtons">
                    <filterpane:filterButton text="Search" appliedText="Change Search" />
                </span>
            </div>

            <br />

            <g:if test="${inventoryStoreInstanceList.size() > 0}">
                <div class="list">
                    <table>
                        <thead>
                        <tr>

                            <g:sortableColumn property="id" title="Id" params="${filterParams}" />

                            <g:sortableColumn property="name" title="Name" params="${filterParams}" />

                            <g:sortableColumn property="description" title="Description" params="${filterParams}" />

                            <g:sortableColumn property="isActive" title="Is Active" params="${filterParams}" />

                            <g:sortableColumn property="site" title="Site" params="${filterParams}" />

                            <th></th>

                        </tr>
                        </thead>
                        <tbody>
                        <g:each in="${inventoryStoreInstanceList}" status="i" var="inventoryStoreInstance">
                            <tr class="${(i % 2) == 0 ? 'clickableOdd' : 'clickableEven'}">

                                <td onclick='window.location = "${request.getContextPath()}/inventoryStoreDetailed/show/${inventoryStoreInstance.id}"'>
                                    ${fieldValue(bean:inventoryStoreInstance, field:'id')}
                                </td>

                                <td onclick='window.location = "${request.getContextPath()}/inventoryStoreDetailed/show/${inventoryStoreInstance.id}"'>
                                    ${fieldValue(bean:inventoryStoreInstance, field:'name')}
                                </td>

                                <td onclick='window.location = "${request.getContextPath()}/inventoryStoreDetailed/show/${inventoryStoreInstance.id}"'>
                                    ${fieldValue(bean:inventoryStoreInstance, field:'description')}
                                </td>

                                <td onclick='window.location = "${request.getContextPath()}/inventoryStoreDetailed/show/${inventoryStoreInstance.id}"'>
                                    ${fieldValue(bean:inventoryStoreInstance, field:'isActive')}
                                </td>

                                <td onclick='window.location = "${request.getContextPath()}/inventoryStoreDetailed/show/${inventoryStoreInstance.id}"'>
                                    ${fieldValue(bean:inventoryStoreInstance, field:'site')}
                                </td>

                                <td class="notClickable">
                                    <g:link action="show" id="${inventoryStoreInstance.id}">
                                        <img  src="${resource(dir:'images/skin',file:'database_go.png')}" alt="Show" />
                                    </g:link>
                                </td>

                            </tr>
                        </g:each>
                        </tbody>
                    </table>
                </div>
            </g:if>

            <div class="paginateButtons">
                <g:paginate total="${inventoryStoreInstanceTotal}" params="${filterParams}" />
            </div>

            <filterpane:filterPane domainBean="InventoryStore"
                                   title="Search"
                                   action="list"
                                   class="overlayPane"
                                   associatedProperties="site.name"
                                   filterPropertyValues="${['site.name':[values: associatedPropertyValues.siteList]]}" />
        </div>
    </body>
</html>
