<html>
    <head>
        <meta name="layout" content="main" />
        <title>Show Picture</title>
        <g:render template="/shared/pictureHead" />
    </head>
    <body>
        <div class="nav">
            <h1>Show Picture</h1>
        </div>
        <div class="body">
            <g:render template="/shared/messages" />
            <div class="dialog">
                <table>
                    <tbody>
                        <tr class="prop">
                            <td valign="top" class="name">Picture:</td>
                            <td valign="top" class="value">
                                <span class='gallery'><wa:pictureLightboxAnchor picture="${picture}" size="${Image.Medium}" lightboxSize="${Image.Large}" target="_blank" title="Show Original" /></span>
                            </td>
                        </tr>
                        <tr class="prop">
                            <td valign="top" class="name">Inventory Item:</td>
                            <td valign="top" class="value"><g:link controller="inventoryItemDetailed" action="show" id="${picture.inventoryItem?.id}" title="Show Inventory Item">${picture.inventoryItem?.toString()?.encodeAsHTML()}</g:link></td>
                        </tr>
                        <tr class="prop">
                            <td valign="top" class="name">Height:</td>
                            <td valign="top" class="value">${picture.height}</td>
                        </tr>
                        <tr class="prop">
                            <td valign="top" class="name">Width:</td>
                            <td valign="top" class="value">${picture.width}</td>
                        </tr>
                        <tr class="prop">
                            <td valign="top" class="name">Date Created:</td>
                            <td valign="top" class="value"><g:formatDate format="EEE, dd-MMM-yyyy" date="${picture.dateCreated}"/></td>
                        </tr>
                        <tr class="prop">
                            <td valign="top" class="name">Last Updated:</td>
                            <td valign="top" class="value"><g:formatDate format="EEE, dd-MMM-yyyy" date="${picture.lastUpdated}"/></td>
                        </tr>
                    </tbody>
                </table>
            </div>
            <div class="buttons">
                <g:form>
                    <input type="hidden" name="id" value="${picture?.id}" />
                    <span class="button"><g:actionSubmit class="edit" value="Edit" /></span>
                    <span class="button"><g:actionSubmit class="delete" onclick="return confirm('Are you sure?');" value="Delete" /></span>
                </g:form>
            </div>
        </div>
    </body>
</html>
