/**
* Asset Tree tags.
* Specific to gnuMims hence the namespace.
*/
class AssetTreeTagLib {
    static namespace = 'gnuMims'

    def js = new JsUtilService()
    def assetTreeService

    /**
    * Include required javascript and do setup here.
    */
    def resources = { attrs ->
        out << g.javascript(src: "assetTree.js")
    }

    /**
    * Button that opens the asset tree pane and calls the javascript to populate it.
    */
    def assetTreeButton = { attrs ->
        out << assetTreeService.buildAssetTreeButton(attrs)
    } // assetTreeButton

    /**
    * The asset tree pane, ready for populating by an ajax call to AssetTreeSevice.
    */
    def assetTreePane = { attrs ->
        out << assetTreeService.buildAssetTreePane(attrs)
    }

} // end class