class Entry {
    Person enteredBy
    Task task
    EntryType entryType
    ConditionSeverity highestSeverity
    ProductionReference productionReference

    String comment
    Date dateDone = new Date()
    Date dateEntered = new Date()
    Integer durationHour = 0
    Integer durationMinute = 0

    static belongsTo = [EntryType, Task, Person]

    static constraints = {
        task()
        comment(blank:false,maxSize:500)
        dateDone()
        durationHour(min:0,max:16)
        durationMinute(min:0,max:59)
        productionReference(nullable: true)
        // Nullable unless PM Entry Type.
        highestSeverity(nullable:true, validator: {val, obj ->
            if(val == null && (obj.entryType.id == 6))
                return 'not.nullable.for.pm.entry'
        })
    }

    String toString() {
        "${this.comment} - ${this.enteredBy}, ${this.dateDone}"
    }

    String toShortString() {
        "${enteredBy.firstName} ${enteredBy.lastName} - ${durationHour}h : ${durationMinute}min"
    }
}

