
// Load data into createContainer and register events.
function loadCreateContainer(data, createContainer, listContainer, button) {
        // Load the response data and show container.
        createContainer.html(data).slideDown(800);
        // Scroll the window.
        jQuery('html,body').animate({scrollTop: createContainer.offset().top - 70}, 900, function() {
            createContainer.find(':input[name="comment"]').focus();
        });
        // Register 'submit_*' input button click handlers.
        createContainer.find('input[name^="submit_"]').click(function(){
            createContainer.find(':input[name="submitAction"]').val(jQuery(this).attr('name'));
            createContainer.find('form:first').submit();
        });
        // Hijack form submit to use our function.
        var eventData = {listContainer:listContainer, createContainer:createContainer, button:button};
        createContainer.find('form:first').submit(eventData, submitCreateEntryForm);
        // Register the close img click handler.
        createContainer.find('.pane_close img').click(function(){
            createContainer.slideUp(600);
            button.show(600, function() {
                if(jQuery.browser.msie) {
                    jQuery(this).get(0).style.removeAttribute('filter'); // Remove blur/fuzzy text in IE.
                }
            });
        });
}

// Submit a create Entry form via AJAX.
function submitCreateEntryForm(event) {

    var actionUrl = getContextPath()+"/entryDetailed/ajaxSave/";

    event.preventDefault();
    var listContainer = event.data.listContainer;
    var createContainer = event.data.createContainer;
    var button = event.data.button;
    var form = createContainer.find('form:first');

    // On success reload listContainer.
    function success(data, textStatus, jqXHR){
        createContainer.hide();
        listContainer.html(data);
        button.show(600, function() {
            if(jQuery.browser.msie) {
                jQuery(this).get(0).style.removeAttribute('filter'); // Remove blur/fuzzy text in IE.
            }
        });
    }

    // On create failure controller sets 403 and returns the form template.
    function error(jqXHR, textStatus, errorThrown){
        if(jqXHR.status == 403 && jqXHR.responseText){
            loadCreateContainer(jqXHR.responseText, createContainer, listContainer, button);
        }
        else {
            createContainer.html(savedHtml);
            createContainer.prepend(errorIndication().show()).slideDown(600);
            // Scroll the window.
            jQuery('html,body').animate({scrollTop: createContainer.offset().top - 70}, 900, function() {
                createContainer.find(':input[name="comment"]').focus();
            });
        }
    }

    // Start.
    var savedHtml = createContainer.children().detach();
    createContainer.html(loadingIndication().show()).slideDown(600);

    jQuery.ajax({
        url: actionUrl,
        data: form.serializeArray(),
        success: success,
        error: error
    });
}

// Get a create Entry form via AJAX.
// @listContainer Container object to reload list into.
// @createContainer Container object to load response into.
// @button Button object used to trigger this function.
// @params Params map to pass to actionUrl.
function getCreateEntryForm(listContainer, createContainer, button, params) {

    var actionUrl = getContextPath()+"/entryDetailed/ajaxCreate/";

    // On success load createContainer.
    function success(data, textStatus, jqXHR){
        loadCreateContainer(data, createContainer, listContainer, button);
    }

    // On error show controller responseText or show default error.
    function error(jqXHR, textStatus, errorThrown){
        if(jqXHR.status == 403 && jqXHR.responseText){
            loadCreateContainer(jqXHR.responseText, createContainer, listContainer, button);
        }
        else {
            createContainer.html(errorIndication().show()).slideDown(600);
        }
        button.show(600, function() {
            if(jQuery.browser.msie) {
                jQuery(this).get(0).style.removeAttribute('filter'); // Remove blur/fuzzy text in IE.
            }
        });
    }

    // Start.
    button.hide(600);
    createContainer.html(loadingIndication().show()).slideDown(600);

    jQuery.ajax({
        url: actionUrl,
        data: params,
        success: success,
        error: error
    });
}

