<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
        <meta name="layout" content="main" />
        <title>Task Search</title>
        <filterpane:includes />
        <nav:resources override="true"/>
        <export:resource />
        <resource:dateChooser />
        <g:javascript src="taskQuickSearchPane.js" />
    </head>
    <body>
        <div class="nav">
            <nav:renderSubItems group="nav"/>
        </div>

        <div class="body">
            <g:render template="/shared/messages" />
            <g:hasErrors bean="${appCore}">
                <div class="errors">
                    <g:renderErrors bean="${appCore}" as="list" />
                </div>
            </g:hasErrors>
            <filterpane:currentCriteria domainBean="Task"
                                    action="search"
                                    dateFormat="EEE, dd-MMM-yyyy"
                                    removeImgDir="images"
                                    removeImgFile="bullet_delete.png"
                                    title="Advanced Search"/>

            <div class="paginateButtons">
                <span class="searchButtons">
                    <a href='' onclick="showElement('searchPane'); return false;">Quick</a>
                </span>
                Results: ${taskInstanceList.size()} / ${taskInstanceTotal}
                <span class="searchButtons">
                    <filterpane:filterButton text="Advanced" appliedText="Advanced" />
                </span>
            </div>

            <jsUtil:toggleControl toggleId="options"
                                                    imageId="optionsImg"
                                                    closedImgUrl="${resource(dir:'images/skin',file:'bullet_arrow_right.png')}"
                                                    openImgUrl="${resource(dir:'images/skin',file:'bullet_arrow_down.png')}"
                                                    text="${g.message(code: 'default.options.text')}"
                                                    />

            <div id="options" style="display:none;">
                <g:form method="post" action="setSearchParamsMax" >
                    <g:hiddenField name="params" value="${filterParams}" />
                    <div class="dialog">
                        <table>
                            <tbody>

                                <tr class="prop">
                                    <td valign="top" class="name">
                                        <label for="max">Results per page:</label>
                                    </td>
                                    <td valign="top" class="value">
                                        <input type="text" maxlength="4" id="description" name="newMax" value="${params.max}"/>

                                        <span class="buttons">
                                            <g:actionSubmit action="setSearchParamsMax" class="go" value="Update" />
                                        </span>
                                    </td>
                                </tr>

                            </tbody>
                        </table>
                    </div>
                <export:formats  params="${filterParams}" formats="['csv', 'excel', 'pdf', 'rtf']"/>
                </g:form>
            </div>

            <br />

            <g:if test="${taskInstanceTotal > taskInstanceList.size()}">
                <div class="paginateButtons">
                    <g:paginate action="search" total="${taskInstanceTotal}" params="${filterParams}" />
                </div>
            </g:if>

            <g:if test="${taskInstanceList.size() > 0}">
                <div class="list">
                    <table>
                        <thead>
                            <tr>

                                <custom:sortableColumnWithImg property="attentionFlag"
                                                                                                imgSrc="${resource(dir:'images/skin',file:'flag_red.png')}"
                                                                                                imgAlt="Flag"
                                                                                                imgTitle="Attention Flag"
                                                                                                params="${filterParams}" />

                                <g:sortableColumn property="targetStartDate" title="Target Start Date" params="${filterParams}" />

                                <g:sortableColumn property="description" title="Description" params="${filterParams}" />

                                <g:sortableColumn property="taskGroup" title="Group" params="${filterParams}" />

                                <g:sortableColumn  property="taskType" title="Type" params="${filterParams}" />

                                <custom:sortableColumnWithImg property="taskStatus"
                                                                                                imgSrc="${resource(dir:'images/skin',file:'status.png')}"
                                                                                                imgAlt="Status"
                                                                                                imgTitle="Status"
                                                                                                params="${filterParams}" />

                                <g:sortableColumn  property="taskPriority" title="Priority" params="${filterParams}" />

                                <custom:sortableColumnWithImg property="defaultSort"
                                                                                                imgSrc="${resource(dir:'images/skin',file:'table_sort.png')}"
                                                                                                imgAlt="Sort"
                                                                                                imgTitle="Default Sort"
                                                                                                params="${filterParams}" />

                            </tr>
                        </thead>
                        </tbody>
                        <tbody>
                        <g:each in="${taskInstanceList}" status="i" var="taskInstance">
                        <tr class="${(i % 2) == 0 ? 'clickableOdd' : 'clickableEven'}"/>

                                <td class="idColumn" onclick='window.location = "${request.getContextPath()}/taskDetailed/show/${taskInstance.id}"'>
                                    <g:if test="${taskInstance.attentionFlag}">
                                        <img  src="${resource(dir:'images/skin',file:'flag_red.png')}" alt="Flag" title="Attention Flag"/>
                                    </g:if>
                                </td>

                                <td onclick='window.location = "${request.getContextPath()}/taskDetailed/show/${taskInstance.id}"'>
                                    <g:formatDate date="${taskInstance.targetStartDate}" format="EEE, dd-MMM-yyyy"/>
                                </td>

                                <td onclick='window.location = "${request.getContextPath()}/taskDetailed/show/${taskInstance.id}"'>
                                    <b>
                                        Task #${fieldValue(bean:taskInstance, field:'id')}
                                    </b>
                                    <g:if test="${taskInstance.approved}" >
                                        <img  src="${resource(dir:'images/skin',file:'cog.png')}" alt="Approved" title="Approved" />
                                    </g:if>
                                    <g:if test="${taskInstance.taskRecurringSchedule?.enabled}" >
                                        <img  src="${resource(dir:'images/skin',file:'arrow_refresh.png')}" alt="Recurrence Enabled" title="Recurrence Enabled" />
                                    </g:if>
                                    <br />

                                    <b>
                                    <g:if test="${taskInstance.primaryAsset}">
                                        ${fieldValue(bean:taskInstance, field:'primaryAsset')}:
                                    </g:if>
                                    ${fieldValue(bean:taskInstance, field:'description')}
                                    </b>
                                    <g:if test="${taskInstance.taskProcedureRevision?.maintenanceActions}" >
                                        <br />
                                        <custom:taskProcedureMachines taskProcedureRevision="${taskInstance.taskProcedureRevision}" />
                                    </g:if>
                                    <g:if test="${taskInstance.safetyRequirement}" >
                                        <br />
                                        <img  src="${resource(dir:'images/skin',file:'lightning.png')}" alt="Safety Requirement" title="Safety Requirement" />
                                        Safety
                                    </g:if>
                                    <g:if test="${taskInstance.regulatoryRequirement}" >
                                        <br />
                                        <img  src="${resource(dir:'images/skin',file:'script_lightning.png')}" alt="Regulatory Requirement" title="Regulatory Requirement" />
                                        Regulatory
                                    </g:if>
                                    <g:if test="${taskInstance.mandatoryRequirement}" >
                                        <br />
                                        <img  src="${resource(dir:'images/skin',file:'script.png')}" alt="Mandatory Requirement" title="Mandatory Requirement" />
                                        Mandatory
                                    </g:if>
                                    <br />
                                    <br />
                                    <g:each in="${taskInstance.assignedGroups}" status="j" var="assignedGroup">
                                        ${assignedGroup.encodeAsHTML()}<br />
                                    </g:each>
                                    <g:each in="${taskInstance.assignedPersons}" status="k" var="assignedPerson">
                                        ${assignedPerson.encodeAsHTML()}<br />
                                    </g:each>
                                    <g:each in="${taskInstance.entries}" status="m" var="entry">
                                        <g:if test="${entry.entryType.id == 3}">
                                            <em>${'WD: ' +entry.toShortString().encodeAsHTML()}</em><br />
                                        </g:if>
                                    </g:each>
                                    <g:if test="${taskInstance.subTasks}">
                                        Sub Tasks: ${taskInstance.subTasks.size()}<br />
                                    </g:if>
                                </td>

                                <td onclick='window.location = "${request.getContextPath()}/taskDetailed/show/${taskInstance.id}"'>
                                    ${fieldValue(bean:taskInstance, field:'taskGroup')}
                                </td>

                                <td onclick='window.location = "${request.getContextPath()}/taskDetailed/show/${taskInstance.id}"'>
                                    ${fieldValue(bean:taskInstance, field:'taskType')}
                                </td>

                                <td class="idColumn" onclick='window.location = "${request.getContextPath()}/taskDetailed/show/${taskInstance.id}"'>
                                    <g:if test="${taskInstance.taskStatus.id == 1}" >
                                        <img  src="${resource(dir:'images/skin',file:'not_started.png')}" alt="Not Started" title="Not Started" />
                                    </g:if>
                                    <g:if test="${taskInstance.taskStatus.id == 2}" >
                                        <img  src="${resource(dir:'images/skin',file:'arrow_right.png')}" alt="In Progress" title="In Progress" />
                                    </g:if>
                                    <g:if test="${taskInstance.taskStatus.id == 3}" >
                                        <img  src="${resource(dir:'images/skin',file:'tick.png')}" alt="Complete" title="Complete" />
                                    </g:if>
                                </td>

                                <td onclick='window.location = "${request.getContextPath()}/taskDetailed/show/${taskInstance.id}"'>
                                    ${fieldValue(bean:taskInstance, field:'taskPriority')}
                                </td>

                                <td class="notClickable">
                                    <g:link action="show" id="${taskInstance.id}">
                                        <img  src="${resource(dir:'images/skin',file:'database_go.png')}" alt="Show" title="Show" />
                                    </g:link>
                                </td>

                            </tr>
                        </g:each>
                        </tbody>
                    </table>
                </div>
            </g:if>
            <div class="paginateButtons">
                <g:paginate action="search" total="${taskInstanceTotal}" params="${filterParams}" />
            </div>

            <filterpane:filterPane domainBean="Task"
                                    title="Advanced Search"
                                    action="search"
                                    class="overlayPane"
                                    additionalProperties="id"
                                    excludeProperties="targetCompletionDate"
                                    associatedProperties="taskPriority.name,
                                                                                leadPerson.lastName,
                                                                                leadPerson.firstName,
                                                                                taskGroup.name,
                                                                                associatedAssets.name,
                                                                                primaryAsset.name,
                                                                                taskStatus.name,
                                                                                taskType.name"
                                    filterPropertyValues="${['taskPriority.name':[values: associatedPropertyValues.taskPriorityList],
                                                                                'leadPerson.lastName':[values: associatedPropertyValues.lastNameList],
                                                                                'leadPerson.firstName':[values: associatedPropertyValues.firstNameList],
                                                                                'taskGroup.name':[values: associatedPropertyValues.taskGroupList],
                                                                                'associatedAssets.name':[values: associatedPropertyValues.assetList],
                                                                                'primaryAsset.name':[values: associatedPropertyValues.assetList],
                                                                                'taskStatus.name':[values: associatedPropertyValues.taskStatusList],
                                                                                'taskType.name':[values: associatedPropertyValues.taskTypeList],
                                                                                targetCompletionDate:[years: associatedPropertyValues.yearRange,precision:'day'],
                                                                                targetStartDate:[years: associatedPropertyValues.yearRange,precision:'day']
                                                                                ]}"/>

            <g:render template="quickSearchPane" />

        </div> <!-- end body  -->
    </body>
</html>
