<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
        <meta name="layout" content="main" />
        <title>Work Done</title>
        <resource:dateChooser />
    </head>
    <body>
        <div class="nav">
            <h1>Work Done</h1>
        </div>
        <div class="body">
            <g:render template="/shared/messages" />

            <div class="paginateButtons">
                Results: ${totalEntries}
                <span class="searchButtons">
                    <a href='' onclick="showElement('searchPane'); return false;">Search</a>
                </span>
            </div>

            <br />

                <g:if test="${entries.size() > 0}">
                            <div class="list">
                                <table>
                                    <thead>
                                        <tr>
                                            <th>Task</th>
                                            <th>Work Done</th>
                                            <th>Duration</th>
                                            <th></th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <g:each in="${entries}" status="i" var="entry">
                                                <tr class="${(i % 2) == 0 ? 'clickableOdd' : 'clickableEven'}"/>

                                                    <td width="35%" onclick='window.location = "${request.getContextPath()}/entryDetailed/edit/${entry.id}"'>
                                                        ${entry.task.encodeAsHTML()}
                                                    </td>
                                                    <td width="60%" onclick='window.location = "${request.getContextPath()}/entryDetailed/edit/${entry.id}"'>
                                                        ${entry.comment.encodeAsHTML()}
                                                    </td>
                                                    <td onclick='window.location = "${request.getContextPath()}/entryDetailed/edit/${entry.id}"'>
                                                        ${entry.durationHour}:<g:formatNumber number="${entry.durationMinute}" type="number" minIntegerDigits="2" />
                                                    </td>

                                                    <td class="notClickable">
                                                        <g:link controller="entryDetailed" action="edit" id="${entry.id}">
                                                            <img  src="${resource(dir:'images/skin',file:'database_edit.png')}" alt="Edit" />
                                                        </g:link>
                                                    </td>

                                                </tr>
                                        </g:each>
                                        <tr class="total">
                                            <td>
                                                Total
                                            </td>
                                            <td>
                                            </td>
                                            <td>
                                                ${totalHours}:<g:formatNumber number="${totalMinutes}" type="number" minIntegerDigits="2" />
                                            </td>
                                            <td>
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </g:if>

            <!-- Start Search Pane -->
            <div class="overlayPane" id="searchPane" style="display:none;">
                <h2>Search</h2>
                <g:form method="post" controller="taskDetailed">
                    <table>
                        <tbody>

                            <tr class="prop">
                                <td valign="top" class="name">Person:</td>
                                <td valign="top" class="value">
                                    <g:select optionKey="id"
                                                        from="${Person.findAllByIsActive(true).sort { p1, p2 -> p1.firstName.compareToIgnoreCase(p2.firstName) }}"
                                                        name="person.id"
                                                        value="${person.id}" >
                                    </g:select>
                                </td>
                            </tr>

                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="date">Date:</label>
                                </td>
                                <td valign="top" class="value">
                                    <richui:dateChooser name="date" format="dd-MM-yyyy" value="${startOfDay}" />
                                </td>
                            </tr>

                        </tbody>
                    </table>
                    <div class="buttons">
                        <span class="button">
                            <g:actionSubmit class="save" value="Update" action="workDone" />
                            <g:actionSubmit class="cancel" value="${g.message(code:'fp.tag.filterPane.button.cancel.text', default:'Cancel')}" onclick="return hideElement('searchPane');" />
                        </span>
                    </div>
                </g:form>
            </div> <!-- end search pane -->

        </div> <!--body-->
    </body>
</html>