<!-- Start Search Pane -->
<div class="overlayPane" id="searchPane" style="display:none;">
    <h2>Quick Search</h2>

    <g:form method="post" controller="taskDetailed">
        <table>
            <tbody>

                <tr class="prop">
                    <td valign="top" class="name">Select:</td>
                    <td valign="top" class="value">
                        <g:select optionKey="key"
                                            optionValue="value"
                                            from="${quickSearchSelection}"
                                            name="quickSearch"
                                            id="quickSearchSelect"
                                            value="${params.quickSearch}">
                        </g:select>

                            <span id="allTasksHelp">
                                <g:helpBalloon class="helpballoon" code="task.search.text.all.tasks" />
                            </span>
                            <span id="budgetPlannedHelp">
                                <g:helpBalloon class="helpballoon" code="task.search.text.budget.planned" />
                            </span>
                            <span id="budgetUnplannedHelp">
                                <g:helpBalloon class="helpballoon" code="task.search.text.budget.unplanned" />
                            </span>
                            <span id="personsTasksHelp">
                                <g:helpBalloon class="helpballoon" code="task.search.text.persons.tasks" />
                            </span>
                            <span id="personsImmediateCalloutsHelp">
                                <g:helpBalloon class="helpballoon" code="task.search.text.persons.immediate.callouts" />
                            </span>
                    </td>
                </tr>

                <tr class="prop">
                    <td valign="top" class="name">
                        <label for="date">Between:</label>
                    </td>
                    <td valign="top" class="value">
                        <richui:dateChooser name="startDate" format="dd-MM-yyyy" value="${params.startDate}" />
                        and
                        <richui:dateChooser name="endDate" format="dd-MM-yyyy" value="${params.endDate}" />
                    </td>
                </tr>

                <tr class="prop" style="height:2.7em;">
                    <td valign="top" class="name">
                        <label for="person.id" id="personLabel">Person:</label>
                    </td>
                    <td valign="top" class="value">
                        <div id="personSelection">
                            <g:select optionKey="id"
                                                from="${Person.findAllByIsActive(true).sort { p1, p2 -> p1.firstName.compareToIgnoreCase(p2.firstName) }}"
                                                name="person.id"
                                                value="${params.person?.id}"
                                                id="personSelector">
                            </g:select>
                        </div>
                    </td>
                </tr>

                <tr class="prop" style="height:2.7em;">
                    <td valign="top" class="name">
                        <label for="includeCompleted" id="completedLabel">Incl. Completed:</label>
                    </td>
                    <td valign="top" class="value">
                        <div id="completedSelection">
                            <g:checkBox name="includeCompleted"
                                                    value="${params.includeCompleted}"
                                                    id="completedSelector">
                            </g:checkBox>
                            <g:helpBalloon class="helpballoon" code="task.search.include.completed" />
                        </div>
                    </td>
                </tr>

            </tbody>
        </table>

        <div class="buttons">
            <span class="button">
                <g:actionSubmit class="save" value="Update" action="${actionName}" />
                <g:actionSubmit class="cancel" value="${g.message(code:'fp.tag.filterPane.button.cancel.text', default:'Cancel')}" onclick="return hideElement('searchPane');" />
            </span>
        </div>
    </g:form>

    <table>
        <tbody>
            <tr class="prop">
                <td valign="top" class="name">
                    <label>My Tasks:</label>
                </td>
                <td valign="top" class="value">
                    <g:link controller="taskDetailed"
                                    action="${actionName}"
                                    params="[quickSearch: 'myTodays']">
                                    <g:message code="task.search.text.my.todays" />
                    </g:link> - <g:message code="task.search.text.my.todays.description" />
                    <br />
                </td>
            </tr>

            <tr class="prop">
                <td valign="top" class="name">
                    <label>Links:</label>
                </td>
                <td valign="top" class="value">
                    <g:link controller="taskDetailed"
                                    action="workDone">
                                    <g:message code="task.search.text.work.done" />
                    </g:link> - <g:message code="task.search.text.work.done.description" />
                    <br />
                    <g:link controller="taskDetailed"
                                    action="workLoad">
                                    <g:message code="task.search.text.work.load" />
                    </g:link> - <g:message code="task.search.text.work.load.description" />
                </td>
            </tr>

        </tbody>
    </table>

</div> <!-- end search pane -->
