

<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
        <meta name="layout" content="main" />
        <title>InventoryItem Search</title>
        <nav:resources override="true"/>
        <g:render template="/shared/pictureHead" />
        <filterpane:includes />
        <export:resource />
    </head>
    <body onload="if(document.textSearchForm) {document.textSearchForm.searchText.focus();}">
        <div class="nav">
            <nav:renderSubItems group="nav"/>
        </div>
        <div class="body">
            <g:render template="/shared/messages" />

            <div class="textSearchWrapper">
                <div class="textSearchInput">

                    <filterpane:isFiltered >
                        <filterpane:currentCriteria domainBean="InventoryItem"
                                                action="search"
                                                dateFormat="EEE, dd-MMM-yyyy"
                                                removeImgDir="images"
                                                removeImgFile="bullet_delete.png"
                                                title="Advanced Search"/>
                        <div class="paginateButtons">
                            Results: ${inventoryItemInstanceList.size()} / ${inventoryItemInstanceTotal}
                        </div>
                    </filterpane:isFiltered >

                    <filterpane:isNotFiltered >
                        <g:form method="post" id="textSearchForm" name="textSearchForm" >
                            <g:hiddenField name="newTextSearch" value="true" />

                                <span> <!--Prevent IE inheriting margin-->
                                    <g:textField style="width:450px;" maxlength="75" id="searchText" name="searchText" value="${filterParams.searchText}" />
                                    <g:helpBalloon code="inventoryItem.search.searchText" />

                                    <g:if test="${params.searchName || params.searchDescription || params.searchComment || params.searchLocation || params.searchGroup || params.searchSpareFor}" >
                                        <div id="limitSearch" class="textSearchSelect">
                                    </g:if>
                                    <g:else>
                                        <div id="limitSearch" class="textSearchSelect" style="display:none;">
                                    </g:else>
                                            Limit Search:
                                            <br />
                                            <g:checkBox name="searchName" value="${params.searchName}" ></g:checkBox>
                                            <label for="searchName">Name</label>
                                            <g:checkBox name="searchDescription" value="${params.searchDescription}" ></g:checkBox>
                                            <label for="searchDescription">Description</label>
                                            <g:checkBox name="searchComment" value="${params.searchComment}" ></g:checkBox>
                                            <label for="searchComment">Comment</label>
                                            <g:checkBox name="searchLocation" value="${params.searchLocation}" ></g:checkBox>
                                            <label for="searchLocation">Location</label>
                                            <g:checkBox name="searchGroup" value="${params.searchGroup}" ></g:checkBox>
                                            <label for="searchGroup">Group</label>
                                            <br />
                                            <g:checkBox name="searchSpareFor" value="${params.searchSpareFor}" ></g:checkBox>
                                            <label for="searchSpareFor">Spare For (Asset: Name, Description and Comment).</label>
                                        </div>

                                    <div class="paginateButtons">
                                        <span class="buttons">
                                            <g:actionSubmit class="search" value="Search" action="search" />
                                        </span>
                                        <span class="buttons" style="margin-left: 5px;">
                                            <g:actionSubmit class="complete" value="Select" action="search" onclick="toggleWithEffectUtil('limitSearch'); return false;"/>
                                        </span>
                                        <div class="paginateButtons">
                                            Results: ${inventoryItemInstanceList.size()} / ${inventoryItemInstanceTotal}
                                        </div>
                                    </div><!--paginateButtons-->
                                </span> <!--Prevent IE inheriting margin-->

                        </g:form>
                    </filterpane:isNotFiltered >

                </div><!--textSearchInput-->

                <div class="textSearchRightFloat">
                    <div class="paginateButtons">
                        <span class="searchButtons">
                            <a href='' onclick="showElement('searchPane'); return false;">Quick</a>
                        </span>
                        <br />
                        <br />
                        <span class="searchButtons">
                            <filterpane:filterButton text="Advanced" appliedText="Advanced" />
                        </span>
                    </div>

                    <jsUtil:toggleControl toggleId="options"
                                                            imageId="optionsImg"
                                                            closedImgUrl="${resource(dir:'images/skin',file:'bullet_arrow_right.png')}"
                                                            openImgUrl="${resource(dir:'images/skin',file:'bullet_arrow_down.png')}"
                                                            text="${g.message(code: 'default.options.text')}"
                                                            />
                </div><!--textSearchRightFloat-->
            </div><!--textSearchWrapper-->

            <div id="options" style="display:none; clear:both;">
                <g:form method="post" action="setSearchParamsMax" >
                    <g:hiddenField name="params" value="${filterParams}" />
                    <div class="dialog">
                        <table>
                            <tbody>

                                <tr class="prop">
                                    <td valign="top" class="name">
                                        <label for="max">Results per page:</label>
                                    </td>
                                    <td valign="top" class="value">
                                        <input type="text" maxlength="4" id="description" name="newMax" value="${params.max}"/>

                                        <span class="buttons">
                                            <g:actionSubmit action="setSearchParamsMax" class="go" value="Update" />
                                        </span>
                                    </td>
                                </tr>

                                <tr class="prop">
                                    <td valign="top" class="name">
                                        <label for="max">Inventory:</label>
                                    </td>
                                    <td valign="top" class="value">
                                        <g:link action="exportInventory">
                                            Export
                                        </g:link>
                                        /
                                        <g:link action="exportInventoryTemplate">
                                            Template
                                        </g:link>
                                        /
                                        <g:link action="exportInventoryExample">
                                            Example
                                        </g:link>
                                        /
                                        <g:link action="importInventory">
                                            Import Inventory
                                        </g:link>
                                        /
                                        <g:link action="importInventoryItemPurchases">
                                            Import Purchases
                                        </g:link>
                                        /
                                        <g:link action="importInventoryItemPictures">
                                            Import Pictures
                                        </g:link>
                                    </td>
                                </tr>

                            </tbody>
                        </table>
                    </div>
                </g:form>
                <export:formats  params="${filterParams}" formats="['csv', 'excel', 'pdf', 'rtf']"/>
            </div>

            <br />

            <g:if test="${inventoryItemInstanceList.size() > 2}">
                <g:if test="${inventoryItemInstanceTotal > inventoryItemInstanceList.size()}">
                    <div class="paginateButtons">
                        <g:paginate action="search" total="${inventoryItemInstanceTotal}" params="${filterParams}" />
                    </div>
                </g:if>
            </g:if>

            <g:if test="${inventoryItemInstanceList.size() > 0}">
                <div class="list">
                    <table>
                        <thead>
                            <tr>

                                <th>Picture</th>
                                <th>Description</th>
                            
                                <g:sortableColumn property="inventoryGroup" title="Group" params="${filterParams}" />
                            
                                <g:sortableColumn property="unitsInStock" title="In Stock" params="${filterParams}" />

                                <th></th>
                            
                            </tr>
                        </thead>
                        <tbody>
                        <g:each in="${inventoryItemInstanceList}" status="i" var="inventoryItemInstance">
                            <tr class="${(i % 2) == 0 ? 'clickableOdd' : 'clickableEven'}" />

                                <td class='notClickable'>
                                    <g:if test="${inventoryItemInstance.picture}" >
                                        <wa:pictureLightboxAnchor picture="${inventoryItemInstance.picture}"
                                                                                            size="${Image.Small}"
                                                                                            lightboxSize="${Image.Large}"
                                                                                            target="_blank"
                                                                                            title="Show Original" />
                                    </g:if>
                                </td>
                            
                                <td onclick='window.location = "${request.getContextPath()}/inventoryItemDetailed/show/${inventoryItemInstance.id}"' >
                                    <b>${fieldValue(bean:inventoryItemInstance, field:'name')}</b><br />
                                    ${fieldValue(bean:inventoryItemInstance, field:'description')}
                                    <br />
                                    <br />
                                    Location: ${inventoryItemInstance.inventoryLocation?.encodeAsHTML()}
                                    in ${inventoryItemInstance.inventoryLocation?.inventoryStore.encodeAsHTML()}<br />
                                </td>
                            
                                <td onclick='window.location = "${request.getContextPath()}/inventoryItemDetailed/show/${inventoryItemInstance.id}"' >
                                    ${fieldValue(bean:inventoryItemInstance, field:'inventoryGroup')}
                                </td>
                            
                                <td onclick='window.location = "${request.getContextPath()}/inventoryItemDetailed/show/${inventoryItemInstance.id}"' >
                                    ${fieldValue(bean:inventoryItemInstance, field:'unitsInStock')}
                                    ${fieldValue(bean:inventoryItemInstance, field:'unitOfMeasure')}
                                </td>

                                <td class="notClickable">
                                    <g:link action="show" id="${inventoryItemInstance.id}">
                                        <img  src="${resource(dir:'images/skin',file:'database_go.png')}" alt="Show" />
                                    </g:link>
                                </td>
                            
                            </tr>
                        </g:each>
                        </tbody>
                    </table>
                </div>
            </g:if>
            <div class="paginateButtons">
                <g:paginate action="search" total="${inventoryItemInstanceTotal}" params="${filterParams}" />
            </div>

            <filterpane:filterPane domainBean="InventoryItem"
                                    title="Advanced Search"
                                    action="search"
                                    class="overlayPane"
                                    excludeProperties="estimatedUnitPriceCurrency"
                                    associatedProperties="inventoryLocation.name,
                                                                            spareFor.name,
                                                                            preferredManufacturer.name,
                                                                            preferredSupplier.name"
                                    filterPropertyValues="${['inventoryLocation.name':[values: associatedPropertyValues.inventoryLocationList],
                                                                                'spareFor.name':[values: associatedPropertyValues.assetList],
                                                                                'preferredManufacturer.name':[values: associatedPropertyValues.manufacturerList],
                                                                                'preferredSupplier.name':[values: associatedPropertyValues.supplierList]
                                                                                ]}"/>
        </div> <!-- end body div -->

        <!-- Start Search Pane -->
        <div class="overlayPane" id="searchPane" style="display:none;">
            <h2>Quick Search</h2>

            <g:form method="post" id="searchForm" name="searchForm" >
                <g:hiddenField name="newTextSearch" value="true" />

                <table>
                    <tbody>

                        <tr class="prop">
                            <td valign="top" class="name">
                                <label>Inventory:</label>
                            </td>
                            <td valign="top" class="value">
                                <g:link controller="inventoryItemDetailed"
                                                action="search"
                                                params="[quickSearch: 'all']">
                                                <g:message code="default.all.text" />
                                </g:link>
                                <br />
                                <g:link controller="inventoryItemDetailed"
                                                action="search"
                                                params="[quickSearch: 'inventoryBelowReorder']">
                                                <g:message code="inventoryItem.search.text.below.reorder" />
                                </g:link> - <g:message code="inventoryItem.search.text.below.reorder.description" />
                                <br />
                                <g:link controller="inventoryItemDetailed"
                                                action="search"
                                                params="[quickSearch: 'inventoryBelowReorderAll']">
                                                <g:message code="inventoryItem.search.text.below.reorder.all" />
                                </g:link> - <g:message code="inventoryItem.search.text.below.reorder.all.description" />
                                <br />
                                <g:link controller="inventoryItemDetailed"
                                                action="search"
                                                params="[quickSearch: 'recentlyUsed', daysBack: '14']">
                                                <g:message code="inventoryItem.search.text.recently.used" />
                                </g:link> - <g:message code="inventoryItem.search.text.recently.used.description" args="[14]"/>
                                <br />
                                <g:link controller="inventoryItemDetailed"
                                                action="search"
                                                params="[quickSearch: 'recentlyUsed', daysBack: '30']">
                                                <g:message code="inventoryItem.search.text.recently.used" />
                                </g:link> - <g:message code="inventoryItem.search.text.recently.used.description" args="[30]"/>
                            </td>
                        </tr>

                        <tr class="prop">
                            <td valign="top" class="name">
                                <label>Links:</label>
                            </td>
                            <td valign="top" class="value">
                                <g:link controller="inventoryItemPurchaseDetailed"
                                                action="search">
                                                Purchases
                                </g:link>
                                <br />
                                <g:link controller="inventoryItemDetailed"
                                                action="reorder">
                                                Reorder
                                </g:link>
                            </td>
                        </tr>

                    </tbody>
                </table>

                <div class="buttons">
                    <span class="button">
                        <g:actionSubmit class="cancel" value="${g.message(code:'fp.tag.filterPane.button.cancel.text', default:'Cancel')}" onclick="return hideElement('searchPane');" />
                    </span>
                </div>
            </g:form>
        </div> <!-- end search pane -->

    </body>
</html>
