

<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
        <meta name="layout" content="main" />
        <title>Approve Payment InventoryItemPurchase</title>
    </head>
    <body>
        <div class="nav">
            <h1>Approve Payment</h1>
        </div>
        <div class="body">
            <g:render template="/shared/messages" />
            <g:hasErrors bean="${inventoryItemPurchaseInstance}">
            <div class="errors">
                <g:renderErrors bean="${inventoryItemPurchaseInstance}" as="list" />
            </div>
            </g:hasErrors>
            <g:form action="approveInvoicePaymentSave" method="post" >
                <g:hiddenField name="inventoryItem.id" value="${inventoryItemPurchaseInstance.inventoryItem?.id}" />
                <g:hiddenField name="receivedId" value="${receivedId}" />
                <g:hiddenField name="supplier.id" value="${inventoryItemPurchaseInstance.supplier?.id}" />
                <g:hiddenField name="returnTo" value="${params.returnTo}" />
                <div class="dialog">
                    <table>
                        <tbody>
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="inventoryItem">Inventory Item:</label>
                                </td>
                                <td valign="top" class="value">
                                    <g:link controller="inventoryItemDetailed"
                                                    action="show"
                                                    id="${inventoryItemPurchaseInstance.inventoryItem.id}">
                                        ${inventoryItemPurchaseInstance.inventoryItem.encodeAsHTML()}
                                    </g:link>
                                </td>
                            </tr>
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="purchaseOrderNumber">Purchase Order #:</label>
                                </td>
                                <td valign="top" class="value">
                                    ${inventoryItemPurchaseInstance.purchaseOrderNumber.encodeAsHTML()}
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="costCode">Cost Code:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:inventoryItemPurchaseInstance,field:'costCode','errors')}">
                                    ${inventoryItemPurchaseInstance.costCode.encodeAsHTML()}
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="quantity">Invoice #:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:inventoryItemPurchaseInstance,field:'invoiceNumber','errors')}">
                                    <input type="text" id="invoiceNumber" name="invoiceNumber" value="${fieldValue(bean:inventoryItemPurchaseInstance,field:'invoiceNumber')}" />
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="quantity">Quantity:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:inventoryItemPurchaseInstance,field:'quantity','errors')}">
                                    <input type="text" id="quantity" name="quantity" value="${fieldValue(bean:inventoryItemPurchaseInstance,field:'quantity')}" />
                                    ${inventoryItemPurchaseInstance.inventoryItem.unitOfMeasure.encodeAsHTML()}
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="orderValue">Purchase Order $:</label>
                                </td>
                                <td valign="top">
                                    <input  class="medium ${hasErrors(bean:inventoryItemPurchaseInstance,field:'orderValueAmount','errors')}"
                                                    type="text" id="orderValueAmount" name="orderValueAmount"
                                                    value="${fieldValue(bean:inventoryItemPurchaseInstance,field:'orderValueAmount')}" />
                                    ${inventoryItemPurchaseInstance.orderValueCurrency?.encodeAsHTML()}
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="comment">Comment:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:inventoryItemPurchaseInstance,field:'comment','errors')}">
                                    <textarea rows="5" cols="40" name="comment">${fieldValue(bean:inventoryItemPurchaseInstance, field:'comment')}</textarea>
                                </td>
                            </tr>
                        
                        </tbody>
                    </table>
                </div>
                <div class="buttons">
                    <span class="button"><input class="save" type="submit" value="Create" /></span>
                </div>
            </g:form>
        </div>
    </body>
</html>
