<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
        <meta name="layout" content="main" />
        <title>Create Task</title>
        <nav:resources override="true"/>
        <resource:dateChooser />
    </head>
    <body onload="document.createTaskForm.description.focus();">
        <div class="nav">
            <nav:renderSubItems group="nav"/>
        </div>
        <div class="body">
            <g:if test="${flash.message}">
            <div class="message">${flash.message}</div>
            </g:if>
            <g:hasErrors bean="${taskInstance}">
            <div class="errors">
                <g:renderErrors bean="${taskInstance}" as="list" />
            </div>
            </g:hasErrors>

            <g:form action="saveUnscheduled" method="post" name="createTaskForm">
                <div class="dialog">
                    <table>
                        <tbody>
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="description">Description:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:taskInstance,field:'description','errors')}">
                                    <input type="text"  class="description" maxlength="75" id="description" name="description" value="${fieldValue(bean:taskInstance,field:'description')}"/>
                                    <g:helpBalloon class="helpballoon" code="task.description" />
                                </td>
                            </tr>
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="comment">Comment:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:taskInstance,field:'comment','errors')}">
                                    <textarea  rows="5" cols="40" name="comment">${fieldValue(bean:taskInstance, field:'comment')}</textarea>
                                    <g:helpBalloon class="helpballoon" code="task.comment" />
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="targetStartDate">Target Start Date:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:taskInstance,field:'targetStartDate','errors')}">
                                    <richui:dateChooser name="targetStartDate" format="dd-MM-yyyy" value="${taskInstance.targetStartDate}" />
                                    <g:helpBalloon class="helpballoon" code="task.targetStartDate" />
                                </td>
                            </tr> 

                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="targetCompletionDate">Target Completion Date:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:taskInstance,field:'targetCompletionDate','errors')}">
                                    <richui:dateChooser name="targetCompletionDate" format="dd-MM-yyyy" value="${taskInstance.targetCompletionDate}" />
                                    <g:helpBalloon class="helpballoon" code="task.targetCompletionDate" />
                                </td>
                            </tr>
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="leadPerson">Lead Person:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:taskInstance,field:'leadPerson','errors')}">
                                    <g:select optionKey="id"
                                                        from="${Person.findAllByIsActive(true).sort { p1, p2 -> p1.firstName.compareToIgnoreCase(p2.firstName) }}"
                                                        name="leadPerson.id"
                                                        value="${taskInstance?.leadPerson?.id}" >
                                    </g:select>
                                    <g:helpBalloon code="task.leadPerson" />
                                </td>
                            </tr>
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="primaryAsset">Asset:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:taskInstance,field:'primaryAsset','errors')}">
                                    <g:select optionKey="id"
                                                        from="${Asset.findAllByIsActive(true).sort { p1, p2 -> p1.name.compareToIgnoreCase(p2.name) }}"
                                                        name="primaryAsset.id"
                                                        value="${taskInstance?.primaryAsset?.id}"
                                                        noSelection="['null':'--None--']"></g:select>
                                    <g:helpBalloon code="task.primaryAsset" />
                                </td>
                            </tr>
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="taskPriority">Task Priority:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:taskInstance,field:'taskPriority','errors')}">
                                    <g:select optionKey="id"
                                                        from="${unscheduledTaskPriorities}"
                                                        name="taskPriority.id"
                                                        value="${taskInstance?.taskPriority?.id}" >
                                    </g:select>
                                </td>
                            </tr>
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="taskGroup">Task Group:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:taskInstance,field:'taskGroup','errors')}">
                                    <g:select optionKey="id"
                                                        from="${TaskGroup.findAllByIsActive(true).sort { p1, p2 -> p1.name.compareToIgnoreCase(p2.name) }}"
                                                        name="taskGroup.id"
                                                        value="${taskInstance?.taskGroup?.id}" >
                                    </g:select>
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="taskType">Task Type:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:taskInstance,field:'taskType','errors')}">
                                    ${taskInstance.taskType.encodeAsHTML()}
                                </td>
                            </tr> 
                        
                        </tbody>
                    </table>
                </div>
                <div class="buttons">
                    <span class="button"><input class="save" type="submit" value="Create" /></span>
                </div>
            </g:form>
        </div>
    </body>
</html>
