class  InventoryItem {
    InventoryGroup inventoryGroup
    InventoryType inventoryType
    UnitOfMeasure unitOfMeasure
    InventoryLocation inventoryLocation
    Period averageDeliveryPeriod
    Picture picture
    Supplier preferredSupplier
    Manufacturer preferredManufacturer
    String name
    String description = ""
    String comment = ""
    String manufacturersPartNumber
    BigDecimal estimatedUnitPriceAmount
    Currency estimatedUnitPriceCurrency
    String suppliersPartNumber
    Integer unitsInStock = 0
    Integer reorderPoint
    Integer recommendedReorderPoint
    Integer averageDeliveryTime
    boolean isActive = true
    boolean isObsolete = false
    boolean enableReorder = true

    static mapping = {
        picture cascade: 'all-delete-orphan', lazy: true, inverse: true
    }

    static hasMany = [alternateItems: InventoryItem,
                                    spareFor: Asset,
                                    inventoryMovements: InventoryMovement,
                                    alternateManufacturers: Manufacturer,
                                    alternateSuppliers: Supplier]

//     static belongsTo = []

    static constraints = {
        picture(nullable:true)
        name(unique:true, blank:false, maxSize:50)
        description(maxSize:255)
        comment(maxSize:500)
        unitsInStock(min:0)
        unitOfMeasure()
        estimatedUnitPriceAmount(nullable:true, max: new BigDecimal(1000000000000))
        estimatedUnitPriceCurrency(nullable:true)
        reorderPoint()
        enableReorder()
        recommendedReorderPoint(nullable:true)
        isActive()
        isObsolete()
        inventoryGroup()
        inventoryType()
        manufacturersPartNumber(blank:true, nullable:true)
        suppliersPartNumber(blank:true, nullable:true)
        preferredSupplier(nullable:true)
        preferredManufacturer(nullable:true)
        averageDeliveryTime(nullable:true)
        averageDeliveryPeriod(nullable:true)
    }

    String toString() {"${this.name}"}

    def afterInsert = {
        addReverseAlternateItems()
    }

    /**
    * Add reverse alternateItem references.
    */
    def addReverseAlternateItems() {
        this.alternateItems.each() {
            if( !it.alternateItems?.contains(this) )
                it.addToAlternateItems(this)
        }
    }

    /**
   * Remove all reverse alternateItem references.
    * On update: reverse alternateItem handling must be done in the
    * service class since the before assignment alternateItems are required.
    */
    def removeReverseAlternateItems(alternateItems = this.alternateItems) {
        alternateItems.each() {
            it.removeFromAlternateItems(this)
        }
    }

}
