class Person {
    String firstName
    String lastName
    String userId
    String password
    Integer employeeID
    boolean isActive = true

    static hasMany = [modifications : Modification,
                        entries : Entry,
                        tasks : Task,
                        personGroups : PersonGroup]

    static belongsTo = [PersonGroup]

    static optionals = ["employeeID"]

    static constraints = {
        firstName(maxSize:50,blank:false)
        lastName(maxSize:50,blank:false)
        userId(maxSize:8,unique:true)
        password(maxSize:8)
        employeeID(blank:true, nullable:true)
    }

    //Overriding the default toString method
    String toString() {"${this.firstName} ${this.lastName}"}
}
