

<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
        <meta name="layout" content="main" />
        <title>Edit InventoryItem</title>
        <nav:resources override="true"/>
        <g:render template="/shared/pictureHead" />
    </head>
    <body>
        <div class="nav">
            <nav:renderSubItems group="nav"/>
        </div>
        <div class="body">
            <g:render template="/shared/messages" />
            <g:hasErrors bean="${inventoryItemInstance}">
            <div class="errors">
                <g:renderErrors bean="${inventoryItemInstance}" as="list" />
            </div>
            </g:hasErrors>
            <g:form method="post" >
                <input type="hidden" name="id" value="${inventoryItemInstance?.id}" />
                <input type="hidden" name="version" value="${inventoryItemInstance?.version}" />
                <div class="dialog">
                    <table>
                        <tbody>

                            <tr class="prop">
                                <td valign="top" class="name">Picture:</td>
                                <td valign="top" class="value">
                                    <g:if test="${inventoryItemInstance.picture}" >
                                        <span class='gallery'>
                                            <wa:pictureLightboxAnchor picture="${inventoryItemInstance.picture}" size="${Image.Medium}" lightboxSize="${Image.Large}" target="_blank" title="Show Original" />
                                        </span>
                                        <br />
                                        <g:link controller="pictureDetailed" action="edit" id="${inventoryItemInstance.picture.id}" >
                                            Edit Picture
                                        </g:link>
                                    </g:if>
                                </td>
                            </tr>

                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="name">Name:</label>
                                </td>
                                <td valign="top">
                                    <input class="description ${hasErrors(bean:inventoryItemInstance,field:'name','errors')}"
                                                type="text" maxlength="50" id="name" name="name"
                                                value="${fieldValue(bean:inventoryItemInstance,field:'name')}"/>
                                </td>
                            </tr>

                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="description">Description:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:inventoryItemInstance,field:'description','errors')}">
                                    <textarea rows="5" cols="40" name="description">${fieldValue(bean:inventoryItemInstance, field:'description')}</textarea>
                                </td>
                            </tr>

                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="comment">Comment:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:inventoryItemInstance,field:'comment','errors')}">
                                    <textarea rows="5" cols="40" name="comment">${fieldValue(bean:inventoryItemInstance, field:'comment')}</textarea>
                                </td>
                            </tr>

                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="unitsInStock">In Stock:</label>
                                </td>
                                <td valign="top" class="value">
                                    ${inventoryItemInstance.unitsInStock} ${inventoryItemInstance.unitOfMeasure.encodeAsHTML()}
                                </td>
                            </tr>

                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="inventoryLocation">Location:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:inventoryItemInstance,field:'inventoryLocation','errors')}">
                                    <g:select optionKey="id"
                                                        from="${ InventoryLocation.list().sort { p1, p2 -> p1.toString().compareToIgnoreCase(p2.toString()) } }"
                                                        name="inventoryLocation.id"
                                                        value="${inventoryItemInstance?.inventoryLocation?.id}"
                                                        optionValue="${{it.name+ ' in ' + it.inventoryStore}}">
                                    </g:select>
                                </td>
                            </tr>

                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="isActive">Active:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:inventoryItemInstance,field:'isActive','errors')}">
                                    <g:checkBox name="isActive" value="${inventoryItemInstance?.isActive}" ></g:checkBox>
                                </td>
                            </tr>

                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="reorderPoint">Reorder Point:</label>
                                </td>
                                <td valign="top">
                                    <input  class="medium ${hasErrors(bean:inventoryItemInstance,field:'reorderPoint','errors')}"
                                                    type="text" id="reorderPoint" name="reorderPoint"
                                                    value="${fieldValue(bean:inventoryItemInstance,field:'reorderPoint')}" />
                                     ${inventoryItemInstance.unitOfMeasure.encodeAsHTML()}
                                </td>
                            </tr>

                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="recommendedReorderPoint">Recommended Reorder Point:</label>
                                </td>
                                <td valign="top">
                                    <input class="medium ${hasErrors(bean:inventoryItemInstance,field:'recommendedReorderPoint','errors')}"
                                                type="text" id="recommendedReorderPoint" name="recommendedReorderPoint"
                                                value="${fieldValue(bean:inventoryItemInstance,field:'recommendedReorderPoint')}" />
                                     ${inventoryItemInstance.unitOfMeasure.encodeAsHTML()}
                                </td>
                            </tr>

                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="enableReorder">Enable Reorder:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:inventoryItemInstance,field:'enableReorder','errors')}">
                                    <g:checkBox name="enableReorder" value="${inventoryItemInstance?.enableReorder}" ></g:checkBox>
                                </td>
                            </tr>

                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="isObsolete">Obsolete:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:inventoryItemInstance,field:'isObsolete','errors')}">
                                    <g:checkBox name="isObsolete" value="${inventoryItemInstance?.isObsolete}" ></g:checkBox>
                                </td>
                            </tr>

                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="averageDeliveryTime">Average Delivery Time:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:inventoryItemInstance,field:'averageDeliveryTime','errors')}">
                                    <input type="text" id="averageDeliveryTime" name="averageDeliveryTime" value="${fieldValue(bean:inventoryItemInstance,field:'averageDeliveryTime')}" />
                                    <g:select optionKey="id"
                                                        from="${Period.list()}"
                                                        name="averageDeliveryPeriod.id"
                                                        value="${inventoryItemInstance?.averageDeliveryPeriod?.id}"
                                                        noSelection="['null':'--None--']">
                                    </g:select>
                                </td>
                            </tr>
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="averageDeliveryTime">Estimated Unit Price:</label>
                                </td>
                                <td valign="top" class="value">
                                    <input  class="medium ${hasErrors(bean:inventoryItemInstance,field:'estimatedUnitPriceAmount','errors')}"
                                                    type="text" id="estimatedUnitPriceAmount" name="estimatedUnitPriceAmount"
                                                    value="${inventoryItemInstance.estimatedUnitPriceAmount}" />
                                    <g:currencySelect name="estimatedUnitPriceCurrency"
                                                                        value="${inventoryItemInstance.estimatedUnitPriceCurrency}" />
                                </td>
                            </tr>

                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="suppliersPartNumber">Suppliers Part Number:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:inventoryItemInstance,field:'suppliersPartNumber','errors')}">
                                    <input type="text" id="suppliersPartNumber" name="suppliersPartNumber" value="${fieldValue(bean:inventoryItemInstance,field:'suppliersPartNumber')}"/>
                                </td>
                            </tr>

                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="preferredSupplier">Preferred Supplier:</label>
                                </td>
                                <td valign="top">
                                    <g:select optionKey="id" from="${suppliers}" name="preferredSupplier.id" value="${inventoryItemInstance.preferredSupplier?.id}" noSelection="['null':'--None--']"></g:select>

                                    <p><g:link controller="supplierDetailed" action="create">+Add Supplier</g:link></p>
                                </td>
                            </tr>

                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="alternateSuppliers">Alternate Suppliers:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:inventoryItemInstance,field:'alternateSuppliers','errors')}">
                                    <g:select id="alternateSuppliers" name="alternateSuppliers"
                                                        from="${suppliers}"
                                                        size="5" multiple="yes" optionKey="id"
                                                        value="${inventoryItemInstance.alternateSuppliers?.id}" noSelection="['':'--None--']"/>
                                </td>
                            </tr>

                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="manufacturersPartNumber">Manufacturers Part Number:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:inventoryItemInstance,field:'manufacturersPartNumber','errors')}">
                                    <input type="text" id="manufacturersPartNumber" name="manufacturersPartNumber" value="${fieldValue(bean:inventoryItemInstance,field:'manufacturersPartNumber')}"/>
                                </td>
                            </tr>

                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="preferredManufacturer">Preferred Manufacturer:</label>
                                </td>
                                <td valign="top">
                                    <g:select optionKey="id" from="${manufacturers}" name="preferredManufacturer.id" value="${inventoryItemInstance.preferredManufacturer?.id}" noSelection="['null':'--None--']"></g:select>

                                    <p><g:link controller="manufacturerDetailed" action="create">+Add Manufacturer</g:link></p>
                                </td>
                            </tr>

                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="manufacturers">Alternate Manufacturers:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:inventoryItemInstance,field:'alternateManufacturers','errors')}">
                                    <g:select id="alternateManufacturers" name="alternateManufacturers"
                                                        from="${manufacturers}"
                                                        size="5" multiple="yes" optionKey="id"
                                                        value="${inventoryItemInstance.alternateManufacturers?.id}" noSelection="['':'--None--']" />
                                </td>
                            </tr>

                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="spareFor">Spare For:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:inventoryItemInstance,field:'spareFor','errors')}">
                                    <g:select name="spareFor"
                                                        from="${ Asset.list().sort { p1, p2 -> p1.name.compareToIgnoreCase(p2.name) } }"
                                                        size="5" multiple="yes" optionKey="id"
                                                        value="${inventoryItemInstance?.spareFor.id}" noSelection="['':'--None--']"/>

                                </td>
                            </tr>

                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="alternateItems">Alternate Items:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:inventoryItemInstance,field:'alternateItems','errors')}">
                                    <g:select name="alternateItems"
                                                        from="${possibleAlternateItems}"
                                                        size="5" multiple="yes" optionKey="id"
                                                        value="${inventoryItemInstance?.alternateItems.id}" noSelection="['':'--None--']"/>

                                </td>
                            </tr>

                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="inventoryGroup">Inventory Group:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:inventoryItemInstance,field:'inventoryGroup','errors')}">
                                    <g:select optionKey="id" from="${InventoryGroup.list()}" name="inventoryGroup.id" value="${inventoryItemInstance?.inventoryGroup?.id}" ></g:select>
                                </td>
                            </tr>

                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="inventoryType">Inventory Type:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:inventoryItemInstance,field:'inventoryType','errors')}">
                                    <g:select optionKey="id" from="${InventoryType.list()}" name="inventoryType.id" value="${inventoryItemInstance?.inventoryType?.id}" ></g:select>
                                </td>
                            </tr>

                        </tbody>
                    </table>
                </div>
                <div class="buttons">
                    <span class="button"><g:actionSubmit class="save" value="Update" /></span>
                    <span class="button"><g:actionSubmit class="cancel" value="Cancel" action="Show"/></span>
                    <span class="button"><g:actionSubmit class="delete" onclick="return confirm('Are you sure?');" value="Delete" /></span>
                </div>
            </g:form>
        </div>
    </body>
</html>
