import grails.test.*

/**
* Integration tests for TaskSearchService.
*/
class TaskSearchServiceTests extends GroovyTestCase {

    // Data will be saved, not rolled back.
    // Be sure to clean up in tearDown().
    boolean transactional = false

    def taskService
    def dateUtilService
    def taskSearchService

    def taskA
    def taskB
    def taskCount = 0

    // Setup is called before each test.
    protected void setUp() {
        super.setUp()

        // Check environment state.
        assert Task.count() == 0
        assert Entry.count() == 0
        assert TaskModification.count() == 0

        def p = [:]
        def result

        p = [taskGroup:TaskGroup.findByName("Engineering Activites"),
                taskPriority:TaskPriority.get(2),
                taskType:TaskType.get(1),
                leadPerson:Person.get(1),
                description:"TestA",
                comment:"Service test task.",
                targetStartDate: dateUtilService.today,
                targetCompletionDate: dateUtilService.today]

        result = taskService.save(p)
        assert result.error == null
        taskCount++
        taskA = result.taskInstance.refresh()

        p.description = "TestB"
        result = taskService.save(p)
        assert result.error == null
        taskCount++
        taskB = result.taskInstance.refresh()
    }

    // Tear down is called after each test.
    protected void tearDown() {
        super.tearDown()

        taskService.delete(taskA)
        taskService.delete(taskB)

        // Ensure that we leave environment clean.
        assert Task.count() == 0
        assert TaskModification.count() == 0
        assert Entry.count() == 0
    }

    void testGetTasks() {
        // Todays tasks should be returned
        def tasks = taskSearchService.getTasks([:])
        assert tasks.totalCount == taskCount

        // Tasks in the trash should not be returned.
        taskA.trash = true
        taskA.save(flush:true)
        assert taskSearchService.getTasks([:]).totalCount == taskCount - 1
        taskB.trash = true
        taskB.save(flush:true)
        assert taskSearchService.getTasks([:]).totalCount == taskCount - 2

        // Restored tasks should be returned.
        taskA.trash = false
        taskA.save(flush:true)
        assert taskSearchService.getTasks([:]).totalCount == taskCount - 1
        taskB.trash = false
        taskB.save(flush:true)
        assert taskSearchService.getTasks([:]).totalCount == taskCount

        // Tomorrows tasks should not be returned.
        taskA.targetStartDate = dateUtilService.tomorrow
        taskA.targetCompletionDate = dateUtilService.tomorrow
        taskA.save(flush:true)
        assert taskSearchService.getTasks([:]).totalCount == taskCount - 1

        // Tomorrows tasks should be returned, if we ask for them.
        assert taskSearchService.getTasks([:], dateUtilService.today, dateUtilService.tomorrow+1).totalCount == taskCount

        // Yesterdays tasks should not be returned.
        taskA.targetStartDate = dateUtilService.yesterday
        taskA.targetCompletionDate = dateUtilService.yesterday
        taskA.save(flush:true)
        assert taskSearchService.getTasks([:]).totalCount == taskCount - 1

        // Yesterdays tasks should be returned, if we ask for them.
        assert taskSearchService.getTasks([:], dateUtilService.yesterday, dateUtilService.tomorrow).totalCount == taskCount

        // Tasks that span today should be returned.
        taskA.targetStartDate = dateUtilService.yesterday
        taskA.targetCompletionDate = dateUtilService.tomorrow
        taskA.save(flush:true)
        assert taskSearchService.getTasks([:]).totalCount == taskCount
    } // testGetTasks()

} // end class