class TaskSearchService {

    boolean transactional = false

    def dateUtilService
    def authenticateService

    def paramsMax = 99999

    def getTodays(params) {
        params.max = Math.min(params?.max?.toInteger() ?: 10, paramsMax)
        params.offset = params?.offset?.toInteger() ?: 0
        params.sort = params?.sort ?: "attentionFlag"
        params.order = params?.order ?: "desc"

        def taskInstanceList = Task.createCriteria().list(
            max: params.max,
            offset: params.offset,
            sort: params.sort, 
            order: params.order) {
                ge("targetStartDate", dateUtilService.today)
                lt("targetStartDate", dateUtilService.getTomorrow())
                eq("trash", false)
            }
    }

    def getMyTodays(params) {
        params.max = Math.min(params?.max?.toInteger() ?: 10, paramsMax)
        params.offset = params?.offset?.toInteger() ?: 0
        params.sort = params?.sort ?: "attentionFlag"
        params.order = params?.order ?: "desc"

        def taskInstanceList = Task.createCriteria().list(
            max: params.max,
            offset: params.offset,
            sort: params.sort, 
            order: params.order) {
                eq("leadPerson", Person.get(authenticateService.userDomain().id))
                ge("targetStartDate", dateUtilService.today)
                lt("targetStartDate", dateUtilService.getTomorrow())
                eq("trash", false)
            }
    }

    def getInTheLastWeek(params) {
        params.max = Math.min(params?.max?.toInteger() ?: 10, paramsMax)
        params.offset = params?.offset?.toInteger() ?: 0
        params.sort = params?.sort ?: "attentionFlag"
        params.order = params?.order ?: "desc"

        def taskInstanceList = Task.createCriteria().list(
            max: params.max,
            offset: params.offset,
            sort: params.sort, 
            order: params.order) {
                ge("targetStartDate", dateUtilService.oneWeekAgo)
                lt("targetStartDate", dateUtilService.getTomorrow())
                eq("trash", false)
            }
    }

    def getMyInTheLastWeek(params) {
        params.max = Math.min(params?.max?.toInteger() ?: 10, paramsMax)
        params.offset = params?.offset?.toInteger() ?: 0
        params.sort = params?.sort ?: "attentionFlag"
        params.order = params?.order ?: "desc"

        def taskInstanceList = Task.createCriteria().list(
            max: params.max,
            offset: params.offset,
            sort: params.sort, 
            order: params.order) {
                eq("leadPerson", Person.get(authenticateService.userDomain().id))
                ge("targetStartDate", dateUtilService.oneWeekAgo)
                lt("targetStartDate", dateUtilService.getTomorrow())
                eq("trash", false)
            }
    }

    def getBudgetPlanned(params) {
        params.max = Math.min(params?.max?.toInteger() ?: 10, paramsMax)
        params.offset = params?.offset?.toInteger() ?: 0
        params.sort = params?.sort ?: "attentionFlag"
        params.order = params?.order ?: "desc"

        def taskInstanceList = Task.createCriteria().list(
            max: params.max,
            offset: params.offset,
            sort: params.sort,
            order: params.order) {
                eq("taskBudgetStatus", TaskBudgetStatus.get(2))
                ge("targetStartDate", dateUtilService.oneWeekAgo)
                lt("targetStartDate", dateUtilService.tomorrow)
                eq("trash", false)
            }
    }

    def getBudgetUnplanned(params) {
        params.max = Math.min(params?.max?.toInteger() ?: 10, paramsMax)
        params.offset = params?.offset?.toInteger() ?: 0
        params.sort = params?.sort ?: "attentionFlag"
        params.order = params?.order ?: "desc"

        def taskInstanceList = Task.createCriteria().list(
            max: params.max,
            offset: params.offset,
            sort: params.sort,
            order: params.order) {
                eq("taskBudgetStatus", TaskBudgetStatus.get(1))
                ge("targetStartDate", dateUtilService.oneWeekAgo)
                lt("targetStartDate", dateUtilService.getTomorrow())
                eq("trash", false)
            }
    }
}
