

<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
        <meta name="layout" content="main" />
        <title>Edit Entry</title>
        <resource:dateChooser />
    </head>
    <body>
        <div class="nav">
            <h1>Edit Entry</h1>
        </div>
        <div class="body">
            <g:if test="${flash.message}">
            <div class="message">${flash.message}</div>
            </g:if>
            <g:hasErrors bean="${entryInstance}">
            <div class="errors">
                <g:renderErrors bean="${entryInstance}" as="list" />
            </div>
            </g:hasErrors>
            <g:form method="post" >
                <input type="hidden" name="id" value="${entryInstance?.id}" />
                <div class="dialog">
                    <table>
                        <tbody>
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="task">Task:</label>
                                </td>
                                <td valign="top" class="name">
                                    <g:link controller="taskDetailed" action="show" id="${entryInstance.task.id}" >
                                        ${entryInstance?.task.encodeAsHTML()}
                                    </g:link>
                                </td>
                            </tr>
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="comment">Comment:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:entryInstance,field:'comment','errors')}">
                                    <textarea rows="5" cols="40" name="comment">${fieldValue(bean:entryInstance, field:'comment')}</textarea>
                                </td>
                            </tr>
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="dateDone">Date Done:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:entryInstance,field:'dateDone','errors')}">
                                    <richui:dateChooser name="dateDone" format="dd-MM-yyyy" value="${entryInstance?.dateDone}" />
                                </td>
                            </tr>

                            <g:if test="${entryInstance?.entryType?.id == 1}">
                                <tr class="prop">
                                    <td valign="top" class="name">
                                        <label for="productionReference">Production:</label>
                                    </td>
                                    <td valign="top" class="value ${hasErrors(bean:entryInstance,field:'productionReference','errors')}">
                                        <g:select optionKey="id"
                                                            from="${ProductionReference.findAllByIsActive(true)}"
                                                            name="productionReference.id"
                                                            value="${entryInstance.productionReference?.id}"
                                                            noSelection="['null':'--None--']">
                                        </g:select>
                                        <g:helpBalloon code="entry.productionReference.fault" />
                                    </td>
                                </tr>
                            </g:if>
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="durationHour">Duration:</label>
                                </td>

                                <td valign="top" class="value">
                                    <input class="time ${hasErrors(bean:entryInstance,field:'durationHour','errors')}" 
                                        type="text" id="durationHour" name="durationHour" 
                                        value="${fieldValue(bean:entryInstance,field:'durationHour')}" />
                                    :
                                    <input class="time ${hasErrors(bean:entryInstance,field:'durationMinute','errors')}" 
                                        type="text" id="durationMinute" name="durationMinute" 
                                        value="${fieldValue(bean:entryInstance,field:'durationMinute')}" />
                                    <g:helpBalloon code="entry.duration" />
                                </td>
                            </tr>
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="dateEntered">Date Entered:</label>
                                </td>
                                <td valign="top" class="value">
                                    <g:formatDate date="${entryInstance?.dateEntered}" format="EEE, dd-MMM-yyyy @ HH:mm"/>
                                </td>
                            </tr>
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="enteredBy">Entered By:</label>
                                </td>
                                <td valign="top" class="value">
                                    ${entryInstance?.enteredBy?.toString()}
                                </td>
                            </tr>
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="entryType">Entry Type:</label>
                                </td>
                                <td valign="top" class="name">
                                        ${entryInstance?.entryType.encodeAsHTML()}
                                </td>
                            </tr>
                        
                        </tbody>
                    </table>
                </div>
                <div class="buttons">
                    <span class="button"><g:actionSubmit class="save" value="Update" /></span>
                    <span class="button"><g:actionSubmit class="cancel" value="Cancel" action="Show"/></span>
                    <span class="button"><g:actionSubmit class="delete" onclick="return confirm('Are you sure?');" value="Delete" /></span>
                </div>
            </g:form>
        </div>
    </body>
</html>
