<head>
    <meta name="layout" content="main" />
    <title>Person List</title>
    <filterpane:includes />
    <nav:resources override="true"/>
</head>

<body>

    <div class="nav">
        <nav:renderSubItems group="navAlt"/>
    </div>

    <div class="body">
        <g:if test="${flash.message}">
        <div class="message">${flash.message}</div>
        </g:if>
        <filterpane:currentCriteria domainBean="Person"
                                action="list"
                                dateFormat="${'EEE, dd-MMM-yyyy'}"
                                removeImgDir="images" 
                                removeImgFile="bullet_delete.png"
                                title="Search"/>

        <div class="paginateButtons">
            <span class="searchButtons">
                <filterpane:filterButton text="Search" appliedText="Change Search" />
            </span>
            Results:${personTotal}
        </div>

        <div class="list">
            <table>
            <thead>
                <tr>
                    <g:sortableColumn property="id" title="Id" params="${filterParams}" />
                    <g:sortableColumn property="loginName" title="Login Name" params="${filterParams}" />
                    <g:sortableColumn property="firstName" title="First Name" params="${filterParams}" />
                    <g:sortableColumn property="lastName" title="Last Name" params="${filterParams}" />
                    <g:sortableColumn property="isActive" title="Active" params="${filterParams}" />
                    <th></th>
                </tr>
            </thead>
            <tbody>
            <g:each in="${personList}" status="i" var="person">
                <tr class="${(i % 2) == 0 ? 'clickableOdd' : 'clickableEven'}" onclick='window.location = "${request.getContextPath()}/person/show/${person.id}"'/>

                    <td>${person.id}</td>
                    <td>${person.loginName?.encodeAsHTML()}</td>
                    <td>${person.firstName?.encodeAsHTML()}</td>
                    <td>${person.lastName?.encodeAsHTML()}</td>
                    <td>${person.isActive?.encodeAsHTML()}</td>
                    <td>
                        <g:link action="show" id="${person.id}">
                            <img  src="${resource(dir:'images/skin',file:'database_go.png')}" alt="Show" />
                        </g:link>
                    </td>
                </tr>
            </g:each>
            </tbody>
            </table>
        </div>

        <div class="paginateButtons">
            <g:paginate total="${personTotal}" params="${filterParams}" />
        </div>

        <filterpane:filterPane domainBean="Person"
                                title="Search"
                                action="list"
                                class="overlayPane"
                                excludeProperties="password, sessionTimeout"
                                associatedProperties="authorities.authority, personGroups.name"
                                    filterPropertyValues="${['personGroups.name':[values:PersonGroup.list()],
                                                                                'authorities.authority':[values:Authority.list()]]}" />


    </div> <!-- end body div -->
</body>
