

<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
        <meta name="layout" content="main" />
        <title>Create Address</title>
    </head>
    <body>
        <div class="nav">
            <h1>Create Address</h1>
        </div>
        <div class="body">
            <g:if test="${flash.message}">
            <div class="message">${flash.message}</div>
            </g:if>
            <g:hasErrors bean="${addressInstance}">
            <div class="errors">
                <g:renderErrors bean="${addressInstance}" as="list" />
            </div>
            </g:hasErrors>
            <g:form action="save" method="post" >
                <div class="dialog">
                    <table>
                        <tbody>

                            <g:if test="${addressInstance.manufacturer}">
                                <g:hiddenField name="manufacturer.id" value="${addressInstance.manufacturer.id}"/>
                                <tr class="prop">
                                    <td valign="top" class="name">
                                        <label for="manufacturer">Manufacturer:</label>
                                    </td>
                                    <td valign="top" class="value">
                                        <g:link controller="manufacturerDetailed" action="show" id="${addressInstance.manufacturer.id}">
                                            ${addressInstance.manufacturer.encodeAsHTML()}
                                        </g:link>
                                    </td>
                                </tr>
                            </g:if>
                            
                            <g:if test="${addressInstance.supplier}">
                                <g:hiddenField name="supplier.id" value="${addressInstance.supplier.id}"/>
                                <tr class="prop">
                                    <td valign="top" class="name">
                                        <label for="supplier">Supplier:</label>
                                    </td>
                                    <td valign="top" class="value ${hasErrors(bean:addressInstance,field:'supplier','errors')}">
                                        <g:link controller="supplierDetailed" action="show" id="${addressInstance.supplier.id}">
                                            ${addressInstance.supplier.encodeAsHTML()}
                                        </g:link>
                                    </td>
                                </tr>
                            </g:if>
                            
                            <g:if test="${addressInstance.person}">
                                <g:hiddenField name="person.id" value="${addressInstance.person.id}"/>
                                <tr class="prop">
                                    <td valign="top" class="name">
                                        <label for="person">Person:</label>
                                    </td>
                                    <td valign="top" class="value">
                                        <g:link controller="person" action="show" id="${addressInstance.person.id}">
                                            ${addressInstance.person.encodeAsHTML()}
                                        </g:link>
                                    </td>
                                </tr> 
                            </g:if>
                            
                            <g:if test="${addressInstance.site}">
                                <g:hiddenField name="site.id" value="${addressInstance.site.id}"/>
                                <tr class="prop">
                                    <td valign="top" class="name">
                                        <label for="site">Site:</label>
                                    </td>
                                    <td valign="top" class="value">
                                        <g:link controller="siteDetailed" action="show" id="${addressInstance.site.id}">
                                            ${addressInstance.site.encodeAsHTML()}
                                        </g:link>
                                    </td>
                                </tr> 
                            </g:if>
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="addressType">Address Type:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:addressInstance,field:'addressType','errors')}">
                                    <g:select optionKey="id" from="${AddressType.list()}" name="addressType.id" value="${addressInstance?.addressType?.id}" ></g:select>
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="street1">Street 1:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:addressInstance,field:'street1','errors')}">
                                    <input type="text" maxlength="50" id="street1" name="street1" value="${fieldValue(bean:addressInstance,field:'street1')}"/>
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="street2">Street 2:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:addressInstance,field:'street2','errors')}">
                                    <input type="text" maxlength="50" id="street2" name="street2" value="${fieldValue(bean:addressInstance,field:'street2')}"/>
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="city">City:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:addressInstance,field:'city','errors')}">
                                    <input type="text" maxlength="50" id="city" name="city" value="${fieldValue(bean:addressInstance,field:'city')}"/>
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="state">State:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:addressInstance,field:'state','errors')}">
                                    <input type="text" maxlength="50" id="state" name="state" value="${fieldValue(bean:addressInstance,field:'state')}"/>
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="postCode">Post Code:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:addressInstance,field:'postCode','errors')}">
                                    <input type="text" maxlength="50" id="postCode" name="postCode" value="${fieldValue(bean:addressInstance,field:'postCode')}"/>
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="country">Country:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:addressInstance,field:'country','errors')}">
                                    <input type="text" maxlength="50" id="country" name="country" value="${fieldValue(bean:addressInstance,field:'country')}"/>
                                </td>
                            </tr> 
                        
                        </tbody>
                    </table>
                </div>
                <div class="buttons">
                    <span class="button"><input class="save" type="submit" value="Create" /></span>
                </div>
            </g:form>
        </div>
    </body>
</html>
