// locations to search for config files that get merged into the main config
// config files can either be Java properties files or ConfigSlurper scripts

// grails.config.locations = [ "classpath:${appName}-config.properties",
//                             "classpath:${appName}-config.groovy",
//                             "file:${userHome}/.grails/${appName}-config.properties",
//                             "file:${userHome}/.grails/${appName}-config.groovy"]

// if(System.properties["${appName}.config.location"]) {
//    grails.config.locations << "file:" + System.properties["${appName}.config.location"]
// }
grails.mime.file.extensions = true // enables the parsing of file extensions from URLs into the request format
grails.mime.types = [ html: ['text/html','application/xhtml+xml'],
                      xml: ['text/xml', 'application/xml'],
                      text: 'text-plain',
                      js: 'text/javascript',
                      rss: 'application/rss+xml',
                      atom: 'application/atom+xml',
                      css: 'text/css',
                      csv: 'text/csv',
                      pdf: 'application/pdf',
                      rtf: 'application/rtf',
                      excel: 'application/vnd.ms-excel',
                      ods: 'application/vnd.oasis.opendocument.spreadsheet',
                      all: '*/*',
                      json: ['application/json','text/json'],
                      form: 'application/x-www-form-urlencoded',
                      multipartForm: 'multipart/form-data'
                    ]
// The default codec used to encode data with ${}
grails.views.default.codec="none" // none, html, base64
grails.views.gsp.encoding="UTF-8"
grails.converters.encoding="UTF-8"

// enabled native2ascii conversion of i18n properties files
grails.enable.native2ascii = true

/**
 * Log4j configuration.
 * Causing this file to reload (e.g. edit+save) may break the appLog destination
 * and further logs will be written to files or directories like "[:]".
 * For more info see http://logging.apache.org/log4j/1.2/manual.html
 * For log levels see http://logging.apache.org/log4j/1.2/apidocs/org/apache/log4j/Level.html
 * Basic log levels are ALL < TRACE < DEBUG < INFO < WARN < ERROR < FATAL < OFF
 */
// Pickup the Tomcat/Catalina logDirectory else use the current dir.
def catalinaBase = System.properties.getProperty('catalina.base')
def logDirectory = catalinaBase ? "${catalinaBase}/logs" : '.'

log4j = {
    appenders {
        // Use if we want to prevent creation of a stacktrace.log file.
        'null' name:'stacktrace'

        // Use this if we want to modify the default appender called 'stdout'.
        console name:'stdout', layout:pattern(conversionPattern: '[%t] %-5p %c{2} %x - %m%n')

        // Custom log file.
        rollingFile name:"appLog",
                        file:"${logDirectory}/${appName}.log".toString(),
                        maxFileSize:'300kB',
                        maxBackupIndex:0,
                        layout:pattern(conversionPattern: '%d{[EEE, dd-MMM-yyyy @ HH:mm:ss.SSS]} [%t] %-5p %c %x - %m%n')
    }

    // Configure the root logger to output to stdout and appLog appenders.
    root {
        error 'stdout','appLog'
        additivity = true
    }

    // This is for the builtin stuff and from the default Grails-1.1.1 config.
    error 'org.codehaus.groovy.grails.web.servlet',  //  controllers
            'org.codehaus.groovy.grails.web.pages', //  GSP
            'org.codehaus.groovy.grails.web.sitemesh', //  layouts
            'org.codehaus.groovy.grails.web.mapping.filter', // URL mapping
            'org.codehaus.groovy.grails.web.mapping', // URL mapping
            'org.codehaus.groovy.grails.commons', // core / classloading
            'org.codehaus.groovy.grails.plugins', // plugins
            'org.codehaus.groovy.grails.orm.hibernate', // hibernate integration
            'org.springframework',
            'org.hibernate'

    warn   'org.mortbay.log' // Jetty

    error "grails.app" // Set the default log level for our app code.
    info "grails.app.bootstrap" // Set the log level per type and per type.class
    error "grails.app.service.AuthService"
    error "grails.app.service.NavigationService"
    error "grails.app.service.com.zeddware.grails.plugins.filterpane.FilterService"

    // Move anything that should behave differently into this section.
    switch(environment) {
        case 'development':
            debug "grails.app.service"
            debug "grails.app.controller"
            break
        case 'test':
            debug "grails.app.service"
            debug "grails.app.controller"
            break
        case 'production':
            warn "grails.app.service"
            warn "grails.app.controller"
            info "grails.app.service.CsvService"
            break
    }
}

/**
 * Environment specific configuration.
 */
environments {

    production {
        grails.serverURL = "http://www.changeme.com" // Set serverURL stem for creating absolute links.
    }

    development {
        grails.serverURL = "http://localhost:8080/${appName}" // Set serverURL stem for creating absolute links.
    }

    test {
        grails.serverURL = "http://localhost:8080/${appName}" // Set serverURL stem for creating absolute links.
    }

} // end environments

/**
 * Navigation plugin menu.
 * The top level titles are taken from i18n message bundles.
 * Subitems i18n message bundles are not currently resolving with this plugin.
 */
navigation.nav = [
    [order:10, controller:'appCore', title:'home', action:'start',
        subItems: [
            [order:10, controller:'appCore', title:'Start', action:'start', isVisible: { true }],
            [order:20, controller:'appCore', title:'Manager', action:'manager', isVisible: { authenticateService.ifAnyGranted('ROLE_Manager,ROLE_AppAdmin') }],
            [order:30, controller:'appCore', title:'Admin', action:'appAdmin', isVisible: { authenticateService.ifAllGranted('ROLE_AppAdmin') }],
            [order:90, controller:'appCore', title:'Timeout', action:'changeSessionTimeout', isVisible: { params.action == 'changeSessionTimeout' }],
            [order:91, controller:'appCore', title:'Password', action:'changePassword', isVisible: { params.action == 'changePassword' }],
        ]
    ],
    [order:20, controller:'taskDetailed', title:'tasks', action:'search',
        subItems: [
            [order:10, controller:'taskDetailed', title:'Search', action:'search', isVisible: { true }],
            [order:11, controller:'taskDetailed', title:'Calendar', action:'searchCalendar', isVisible: { true }],
            [order:20, controller:'taskDetailed', title:'Create', action:'create', isVisible: { true }],
            [order:90, controller:'taskDetailed', title:'Show', action:'show', isVisible: { params.action == 'show' }],
            [order:91, controller:'taskDetailed', title:'Edit', action:'edit', isVisible: { params.action == 'edit' }]
        ]
    ],
    [order:30, controller:'inventoryItemDetailed', title:'inventory', action:'search',
        subItems: [
            [order:10, controller:'inventoryItemDetailed', title:'Search', action:'search', isVisible: { true }],
            [order:20, controller:'inventoryItemDetailed', title:'Create', action:'create', isVisible: { true }],
            [order:90, controller:'inventoryItemDetailed', title:'Show', action:'show', isVisible: { params.action == 'show' }],
            [order:91, controller:'inventoryItemDetailed', title:'Edit', action:'edit', isVisible: { params.action == 'edit' }]
        ]
    ],
    [order:40, controller:'assetDetailed', title:'assets', action:'search',
        subItems: [
            [order:10, controller:'assetDetailed', title:'Search', action:'search', isVisible: { true }],
            [order:20, controller:'assetDetailed', title:'Create', action:'create', isVisible: { true }],
            [order:90, controller:'assetDetailed', title:'Show', action:'show', isVisible: { params.action == 'show' }],
            [order:91, controller:'assetDetailed', title:'Edit', action:'edit', isVisible: { params.action == 'edit' }],
            [order:99, controller:'assetSubItemDetailed', title:'Sub Items', action:'search', isVisible: { true }]
        ]
    ]
]

/**
 * Navigation plugin alternate menu.
 * The alternate menu top level titles are not displayed anywhere.
 * Subitems i18n message bundles are not currently resolving with this plugin.
 */
navigation.navAlt = [
    [order:10, controller:'person', title:'person', action:'list',
        subItems: [
            [order:10, controller:'person', title:'Person List', action:'list', isVisible: { true }],
            [order:20, controller:'person', title:'Create', action:'create', isVisible: { true }],
            [order:90, controller:'person', title:'Show', action:'show', isVisible: { params.action == 'show' }],
            [order:91, controller:'person', title:'Edit', action:'edit', isVisible: { params.action == 'edit' }]
        ]
    ],
    [order:20, controller:'taskProcedureDetailed', title:'taskProcedure', action:'list',
        subItems: [
            [order:10, controller:'taskProcedureDetailed', title:'Task Procedure List', action:'list', isVisible: { true }],
            [order:20, controller:'taskProcedureDetailed', title:'Create', action:'create', isVisible: { true }],
            [order:90, controller:'taskProcedureDetailed', title:'Show', action:'show', isVisible: { params.action == 'show' }],
            [order:91, controller:'taskProcedureDetailed', title:'Edit', action:'edit', isVisible: { params.action == 'edit' }]
        ]
    ],
    [order:30, controller:'assetSubItemDetailed', title:'assetSubItem', action:'search',
        subItems: [
            [order:10, controller:'assetSubItemDetailed', title:'Sub Item Search', action:'search', isVisible: { true }],
            [order:20, controller:'assetSubItemDetailed', title:'Create', action:'create', isVisible: { true }],
            [order:90, controller:'assetSubItemDetailed', title:'Show', action:'show', isVisible: { params.action == 'show' }],
            [order:91, controller:'assetSubItemDetailed', title:'Edit', action:'edit', isVisible: { params.action == 'edit' }]
        ]
    ],
    [order:40, controller:'maintenancePolicyDetailed', title:'maintenancePolicy', action:'list',
        subItems: [
            [order:10, controller:'maintenancePolicyDetailed', title:'Maintenance Policy List', action:'list', isVisible: { true }],
            [order:20, controller:'maintenancePolicyDetailed', title:'Create', action:'create', isVisible: { true }],
            [order:90, controller:'maintenancePolicyDetailed', title:'Show', action:'show', isVisible: { params.action == 'show' }],
            [order:91, controller:'maintenancePolicyDetailed', title:'Edit', action:'edit', isVisible: { params.action == 'edit' }]
        ]
    ],
    [order:50, controller:'supplierDetailed', title:'supplier', action:'list',
        subItems: [
            [order:10, controller:'supplierDetailed', title:'Supplier List', action:'list', isVisible: { true }],
            [order:20, controller:'supplierDetailed', title:'Create', action:'create', isVisible: { true }],
            [order:90, controller:'supplierDetailed', title:'Show', action:'show', isVisible: { params.action == 'show' }],
            [order:91, controller:'supplierDetailed', title:'Edit', action:'edit', isVisible: { params.action == 'edit' }]
        ]
    ],
    [order:60, controller:'manufacturerDetailed', title:'manufacturer', action:'list',
        subItems: [
            [order:10, controller:'manufacturerDetailed', title:'Manufacturer List', action:'list', isVisible: { true }],
            [order:20, controller:'manufacturerDetailed', title:'Create', action:'create', isVisible: { true }],
            [order:90, controller:'manufacturerDetailed', title:'Show', action:'show', isVisible: { params.action == 'show' }],
            [order:91, controller:'manufacturerDetailed', title:'Edit', action:'edit', isVisible: { params.action == 'edit' }]
        ]
    ],
    [order:70, controller:'inventoryStoreDetailed', title:'inventoryStore', action:'list',
        subItems: [
            [order:10, controller:'inventoryStoreDetailed', title:'Inventory Store List', action:'list', isVisible: { true }],
            [order:20, controller:'inventoryStoreDetailed', title:'Create', action:'create', isVisible: { true }],
            [order:90, controller:'inventoryStoreDetailed', title:'Show', action:'show', isVisible: { params.action == 'show' }],
            [order:91, controller:'inventoryStoreDetailed', title:'Edit', action:'edit', isVisible: { params.action == 'edit' }]
        ]
    ],
    [order:80, controller:'inventoryLocationDetailed', title:'inventoryLocation', action:'list',
        subItems: [
            [order:10, controller:'inventoryLocationDetailed', title:'Inventory Location List', action:'list', isVisible: { true }],
            [order:20, controller:'inventoryLocationDetailed', title:'Create', action:'create', isVisible: { true }],
            [order:90, controller:'inventoryLocationDetailed', title:'Show', action:'show', isVisible: { params.action == 'show' }],
            [order:91, controller:'inventoryLocationDetailed', title:'Edit', action:'edit', isVisible: { params.action == 'edit' }]
        ]
    ],
    [order:90, controller:'inventoryGroupDetailed', title:'inventoryGroup', action:'list',
        subItems: [
            [order:10, controller:'inventoryGroupDetailed', title:'Inventory Group List', action:'list', isVisible: { true }],
            [order:20, controller:'inventoryGroupDetailed', title:'Create', action:'create', isVisible: { true }],
            [order:90, controller:'inventoryGroupDetailed', title:'Show', action:'show', isVisible: { params.action == 'show' }],
            [order:91, controller:'inventoryGroupDetailed', title:'Edit', action:'edit', isVisible: { params.action == 'edit' }]
        ]
    ],
    [order:100, controller:'manufacturerTypeDetailed', title:'manufacturerType', action:'list',
        subItems: [
            [order:10, controller:'manufacturerTypeDetailed', title:'Manufacturer Type List', action:'list', isVisible: { true }],
            [order:20, controller:'manufacturerTypeDetailed', title:'Create', action:'create', isVisible: { true }],
            [order:90, controller:'manufacturerTypeDetailed', title:'Show', action:'show', isVisible: { params.action == 'show' }],
            [order:91, controller:'manufacturerTypeDetailed', title:'Edit', action:'edit', isVisible: { params.action == 'edit' }]
        ]
    ],
    [order:110, controller:'supplierTypeDetailed', title:'supplierType', action:'list',
        subItems: [
            [order:10, controller:'supplierTypeDetailed', title:'Supplier Type List', action:'list', isVisible: { true }],
            [order:20, controller:'supplierTypeDetailed', title:'Create', action:'create', isVisible: { true }],
            [order:90, controller:'supplierTypeDetailed', title:'Show', action:'show', isVisible: { params.action == 'show' }],
            [order:91, controller:'supplierTypeDetailed', title:'Edit', action:'edit', isVisible: { params.action == 'edit' }]
        ]
    ],
    [order:120, controller:'siteDetailed', title:'site', action:'list',
        subItems: [
            [order:10, controller:'siteDetailed', title:'Site List', action:'list', isVisible: { true }],
            [order:20, controller:'siteDetailed', title:'Create', action:'create', isVisible: { true }],
            [order:90, controller:'siteDetailed', title:'Show', action:'show', isVisible: { params.action == 'show' }],
            [order:91, controller:'siteDetailed', title:'Edit', action:'edit', isVisible: { params.action == 'edit' }]
        ]
    ],
    [order:130, controller:'sectionDetailed', title:'section', action:'list',
        subItems: [
            [order:10, controller:'sectionDetailed', title:'Section List', action:'list', isVisible: { true }],
            [order:20, controller:'sectionDetailed', title:'Create', action:'create', isVisible: { true }],
            [order:90, controller:'sectionDetailed', title:'Show', action:'show', isVisible: { params.action == 'show' }],
            [order:91, controller:'sectionDetailed', title:'Edit', action:'edit', isVisible: { params.action == 'edit' }]
        ]
    ],
    [order:140, controller:'extendedAttributeTypeDetailed', title:'extendedAttributeType', action:'list',
        subItems: [
            [order:10, controller:'extendedAttributeTypeDetailed', title:'Attribute Type List', action:'list', isVisible: { true }],
            [order:20, controller:'extendedAttributeTypeDetailed', title:'Create', action:'create', isVisible: { true }],
            [order:90, controller:'extendedAttributeTypeDetailed', title:'Show', action:'show', isVisible: { params.action == 'show' }],
            [order:91, controller:'extendedAttributeTypeDetailed', title:'Edit', action:'edit', isVisible: { params.action == 'edit' }]
        ]
    ]
]

/**
 * Some custom globals.
 */
taskRecurringScheduleJob.repeatInterval=10
