
function showAssetTreePane(paneDivId, loadingImg, url) {

    Effect.Appear(paneDivId,{duration:0.4});

    // Pulsing loadingImg blocks the default grails animated gif till complete.
    // After which the default will show as normal.
    new Effect.Pulsate($(loadingImg), { pulses: 200, duration: 133 });

    // The updater is only called once per page refresh.
    new Ajax.Updater({ success: paneDivId }, url, {asynchronous:true,evalScripts:true});
}

function hideAssetTreePane(paneDivId, tableDivId, saveUrl) {

    // Collect the visible branch div's first.
    var visibleDivs = $(tableDivId).select('div').findAll(function(el) { return el.visible(); })
    var params = "assetTreeVisibleBranches=";

    // Hide the pane.
    $(paneDivId).toggle();

    // Add the id of each visible div to params.
    visibleDivs.each(function(it) {
        params += it.identify();
        params += ","
    });

    // Remove the trailing comma.
    params = params.slice(0,params.length-1);

    // Post the id's of all visible branch div's.
    // asynchronous: false is against the prototype recommendations but appears to be needed in this case.
    new Ajax.Request(saveUrl, {parameters: params, asynchronous: false});
}

function toggleBranch(divId, imageId, openImgUrl, closedImgUrl) {

    $(divId).toggle();

    if( $(divId).visible() ) {
        $(imageId).src= openImgUrl;
    }
    else {
        $(imageId).src= closedImgUrl;
    }

}