

<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
        <meta name="layout" content="main" />
        <title>Edit InventoryMovement</title>
    </head>
    <body>
        <div class="nav">
            <span class="menuButton"><g:link class="list" action="list">InventoryMovement List</g:link></span>
            <span class="menuButton"><g:link class="create" action="create">New InventoryMovement</g:link></span>
        </div>
        <div class="body">
            <h1>Edit InventoryMovement</h1>
            <g:if test="${flash.message}">
            <div class="message">${flash.message}</div>
            </g:if>
            <g:hasErrors bean="${inventoryMovementInstance}">
            <div class="errors">
                <g:renderErrors bean="${inventoryMovementInstance}" as="list" />
            </div>
            </g:hasErrors>
            <g:form method="post" >
                <input type="hidden" name="id" value="${inventoryMovementInstance?.id}" />
                <input type="hidden" name="version" value="${inventoryMovementInstance?.version}" />
                <div class="dialog">
                    <table>
                        <tbody>
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="inventoryItem">Inventory Item:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:inventoryMovementInstance,field:'inventoryItem','errors')}">
                                    <g:select optionKey="id" from="${InventoryItem.list()}" name="inventoryItem.id" value="${inventoryMovementInstance?.inventoryItem?.id}" ></g:select>
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="quantity">Quantity:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:inventoryMovementInstance,field:'quantity','errors')}">
                                    <input type="text" id="quantity" name="quantity" value="${fieldValue(bean:inventoryMovementInstance,field:'quantity')}" />
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="inventoryMovementType">Inventory Movement Type:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:inventoryMovementInstance,field:'inventoryMovementType','errors')}">
                                    <g:select optionKey="id" from="${InventoryMovementType.list()}" name="inventoryMovementType.id" value="${inventoryMovementInstance?.inventoryMovementType?.id}" ></g:select>
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="task">Task:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:inventoryMovementInstance,field:'task','errors')}">
                                    <g:select optionKey="id" from="${Task.list()}" name="task.id" value="${inventoryMovementInstance?.task?.id}" noSelection="['null':'']"></g:select>
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="person">Person:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:inventoryMovementInstance,field:'person','errors')}">
                                    <g:select optionKey="id" from="${Person.list()}" name="person.id" value="${inventoryMovementInstance?.person?.id}" ></g:select>
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="date">Date:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:inventoryMovementInstance,field:'date','errors')}">
                                    <g:datePicker name="date" value="${inventoryMovementInstance?.date}" precision="minute" ></g:datePicker>
                                </td>
                            </tr> 
                        
                        </tbody>
                    </table>
                </div>
                <div class="buttons">
                    <span class="button"><g:actionSubmit class="save" value="Update" /></span>
                    <span class="button"><g:actionSubmit class="delete" onclick="return confirm('Are you sure?');" value="Delete" /></span>
                </div>
            </g:form>
        </div>
    </body>
</html>
