import org.codehaus.groovy.grails.plugins.springsecurity.Secured

class AssetExtendedAttributeDetailedController extends BaseController {

    def index = { redirect(controller: "assetDetailed", action: "search", params:params) }

    // the delete, save and update actions only accept POST requests
    static allowedMethods = [delete:'POST', save:'POST', update:'POST']

    def show = {
        def assetExtendedAttributeInstance = AssetExtendedAttribute.get( params.id )

        if(!assetExtendedAttributeInstance) {
            flash.message = "AssetExtendedAttribute not found with id ${params.id}"
            redirect(controller: "assetDetailed", action: "search")
        }
        else { return [ assetExtendedAttributeInstance : assetExtendedAttributeInstance ] }
    }

    def delete = {
        def assetExtendedAttributeInstance = AssetExtendedAttribute.get( params.id )
        if(assetExtendedAttributeInstance) {
            try {
                assetExtendedAttributeInstance.delete(flush:true)
                flash.message = "AssetExtendedAttribute ${params.id} deleted"
                redirect(controller: "assetDetailed", action: "search")
            }
            catch(org.springframework.dao.DataIntegrityViolationException e) {
                flash.message = "AssetExtendedAttribute ${params.id} could not be deleted"
                redirect(action:show,id:params.id)
            }
        }
        else {
            flash.message = "AssetExtendedAttribute not found with id ${params.id}"
            redirect(controller: "assetDetailed", action: "search")
        }
    }

    def edit = {
        def assetExtendedAttributeInstance = AssetExtendedAttribute.get( params.id )

        if(!assetExtendedAttributeInstance) {
            flash.message = "AssetExtendedAttribute not found with id ${params.id}"
            redirect(controller: "assetDetailed", action: "search")
        }
        else {
            return [ assetExtendedAttributeInstance : assetExtendedAttributeInstance ]
        }
    }

    def update = {
        def assetExtendedAttributeInstance = AssetExtendedAttribute.get( params.id )
        if(assetExtendedAttributeInstance) {
            if(params.version) {
                def version = params.version.toLong()
                if(assetExtendedAttributeInstance.version > version) {
                    
                    assetExtendedAttributeInstance.errors.rejectValue("version", "assetExtendedAttribute.optimistic.locking.failure", "Another user has updated this AssetExtendedAttribute while you were editing.")
                    render(view:'edit',model:[assetExtendedAttributeInstance:assetExtendedAttributeInstance])
                    return
                }
            }
            assetExtendedAttributeInstance.properties = params
            if(!assetExtendedAttributeInstance.hasErrors() && assetExtendedAttributeInstance.save(flush: true)) {
                flash.message = "AssetExtendedAttribute ${params.id} updated"
                redirect(action:show,id:assetExtendedAttributeInstance.id)
            }
            else {
                render(view:'edit',model:[assetExtendedAttributeInstance:assetExtendedAttributeInstance])
            }
        }
        else {
            flash.message = "AssetExtendedAttribute not found with id ${params.id}"
            redirect(controller: "assetDetailed", action: "search")
        }
    }

    def create = {
        def assetExtendedAttributeInstance = new AssetExtendedAttribute()
        assetExtendedAttributeInstance.properties = params
        return ['assetExtendedAttributeInstance':assetExtendedAttributeInstance]
    }

    def save = {
        def assetExtendedAttributeInstance = new AssetExtendedAttribute(params)
        if(!assetExtendedAttributeInstance.hasErrors() && assetExtendedAttributeInstance.save(flush: true)) {
            flash.message = "AssetExtendedAttribute ${assetExtendedAttributeInstance.id} created"
            redirect(action:show,id:assetExtendedAttributeInstance.id)
        }
        else {
            render(view:'create',model:[assetExtendedAttributeInstance:assetExtendedAttributeInstance])
        }
    }
}
