class InventoryMovement {
    Person person
    InventoryItem inventoryItem
    InventoryMovementType inventoryMovementType
    Task task
    Integer quantity
    Date date = new Date()

//     static belongsTo = []

    static constraints = {
        inventoryItem()
        quantity(min:1)
        inventoryMovementType()
        task(nullable:true)
        person()
        date()
    }

    String toString() {
        "${this.quantity} ${inventoryMovementType.name} on ${date.format('EEE, dd-MMM-yyyy')} by ${person}."
    }
}