

<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
        <meta name="layout" content="main" />
        <title>Show InventoryItem</title>
        <nav:resources override="true"/>
        <g:render template="/shared/pictureHead" />
    </head>
    <body>
        <div class="nav">
            <nav:renderSubItems group="nav"/>
        </div>
        <div class="body">
            <g:if test="${flash.message}">
            <div class="message">${flash.message}</div>
            </g:if>
            <div class="dialog">
                <table>
                    <tbody>
                    
                        <tr class="prop">
                            <td valign="top" class="name">Picture:</td>
                            <td valign="top" class="value">
                                <g:if test="${inventoryItemInstance.picture}" >
                                    <span class='gallery'><wa:pictureLightboxAnchor picture="${inventoryItemInstance.picture}" size="${Image.Medium}" lightboxSize="${Image.Large}" target="_blank" title="Show Original" /></span>
                                </g:if>
                                <g:else>
                                    <g:link controller="pictureDetailed"
                                                    params="['inventoryItem.id':inventoryItemInstance?.id]"
                                                    action="create">
                                        Add Picture
                                    </g:link>
                                </g:else>
                            </td>
                        </tr>
                    
                        <tr class="prop">
                            <td valign="top" class="name">Id:</td>
                            
                            <td valign="top" class="value">${fieldValue(bean:inventoryItemInstance, field:'id')}</td>
                            
                        </tr>
                    
                        <tr class="prop">
                            <td valign="top" class="name">Name:</td>
                            
                            <td valign="top" class="value">${fieldValue(bean:inventoryItemInstance, field:'name')}</td>
                            
                        </tr>
                    
                        <tr class="prop">
                            <td valign="top" class="name">Description:</td>
                            
                            <td valign="top" class="value">${fieldValue(bean:inventoryItemInstance, field:'description')}</td>
                            
                        </tr>
                        
                        <tr class="prop">
                            <td valign="top" class="name">Location:</td>
                            
                            <td valign="top" class="value">
                                <g:link controller="inventoryLocationDetailed" action="show" id="${inventoryItemInstance?.inventoryLocation?.id}">
                                    ${inventoryItemInstance?.inventoryLocation?.encodeAsHTML()}
                                </g:link>
                                    in ${inventoryItemInstance?.inventoryLocation?.inventoryStore.encodeAsHTML()}
                            </td>
                            
                        </tr>
                        
                        <tr class="prop">
                            <td valign="top" class="name">In Stock:</td>
                            
                            <td valign="top" class="value">
                                ${fieldValue(bean:inventoryItemInstance, field:'unitsInStock')} ${inventoryItemInstance?.unitOfMeasure?.encodeAsHTML()}
                            </td>
                            
                        </tr>
                    
                        <tr class="prop">
                            <td valign="top" class="name">Reorder Point:</td>
                            
                            <td valign="top" class="value">${fieldValue(bean:inventoryItemInstance, field:'reorderPoint')}</td>
                            
                        </tr>
                    
                        <tr class="prop">
                            <td valign="top" class="name">Enable Reorder:</td>
                            
                            <td valign="top" class="value">${fieldValue(bean:inventoryItemInstance, field:'enableReorder')}</td>
                            
                        </tr>
                        
                        <tr class="prop">
                            <td valign="top" class="name">Recommended Reorder Point:</td>
                            
                            <td valign="top" class="value">${fieldValue(bean:inventoryItemInstance, field:'recommendedReorderPoint')}</td>
                            
                        </tr>
                    
                        <tr class="prop">
                            <td valign="top" class="name">Active:</td>
                            
                            <td valign="top" class="value">${fieldValue(bean:inventoryItemInstance, field:'isActive')}</td>
                            
                        </tr>
                    
                        <tr class="prop">
                            <td valign="top" class="name">Obsolete:</td>
                            
                            <td valign="top" class="value">${fieldValue(bean:inventoryItemInstance, field:'isObsolete')}</td>
                            
                        </tr>
                    
                        <tr class="prop">
                            <td valign="top" class="name">Inventory Group:</td>
                            
                            <td valign="top" class="value">${inventoryItemInstance?.inventoryGroup?.encodeAsHTML()}</td>
                            
                        </tr>

                    
                        <tr class="prop">
                            <td valign="top" class="name">Inventory Type:</td>
                            
                            <td valign="top" class="value">${inventoryItemInstance?.inventoryType?.encodeAsHTML()}</td>
                            
                        </tr>
                    
                        <tr class="prop">
                            <td valign="top" class="name">Manufacturers Part Number:</td>
                            
                            <td valign="top" class="value">${fieldValue(bean:inventoryItemInstance, field:'manufacturersPartNumber')}</td>
                            
                        </tr>
                    
                        <tr class="prop">
                            <td valign="top" class="name">Suppliers Part Number:</td>
                            
                            <td valign="top" class="value">${fieldValue(bean:inventoryItemInstance, field:'suppliersPartNumber')}</td>
                            
                        </tr>
                    
                        <tr class="prop">
                            <td valign="top" class="name">Recommended Reorder Point:</td>
                            
                            <td valign="top" class="value">${fieldValue(bean:inventoryItemInstance, field:'recommendedReorderPoint')}</td>
                            
                        </tr>
                    
                        <tr class="prop">
                            <td valign="top" class="name">Average Delivery Time:</td>
                            
                            <td valign="top" class="value">${fieldValue(bean:inventoryItemInstance, field:'averageDeliveryTime')}</td>
                            
                        </tr>
                    
                        <tr class="prop">
                            <td valign="top" class="name">Alternate Items:</td>
                            
                            <td  valign="top" style="text-align:left;" class="value">
                                <ul>
                                <g:each var="a" in="${inventoryItemInstance.alternateItems}">
                                    <li><g:link controller="inventoryItemDetailed" action="show" id="${a.id}">${a?.encodeAsHTML()}</g:link></li>
                                </g:each>
                                </ul>
                            </td>
                            
                        </tr>
                    
                        <tr class="prop">
                            <td valign="top" class="name">Inventory Movements:</td>
                            
                            <td  valign="top" style="text-align:left;" class="value">
                                <ul>
                                <g:each var="i" in="${inventoryItemInstance.inventoryMovements}">
                                    <li><g:link controller="inventoryMovementDetailed" action="show" id="${i.id}">${i?.encodeAsHTML()}</g:link></li>
                                </g:each>
                                </ul>
                            </td>
                            
                        </tr>
                    
                        <tr class="prop">
                            <td valign="top" class="name">Manufacturers:</td>
                            
                            <td  valign="top" style="text-align:left;" class="value">
                                <ul>
                                <g:each var="m" in="${inventoryItemInstance.manufacturers}">
                                    <li><g:link controller="manufacturerDetailed" action="show" id="${m.id}">${m?.encodeAsHTML()}</g:link></li>
                                </g:each>
                                </ul>
                            </td>
                            
                        </tr>
                    
                        <tr class="prop">
                            <td valign="top" class="name">Spare For:</td>
                            
                            <td  valign="top" style="text-align:left;" class="value">
                                <ul>
                                <g:each var="s" in="${inventoryItemInstance.spareFor}">
                                    <li><g:link controller="assetDetailed" action="show" id="${s.id}">${s?.encodeAsHTML()}</g:link></li>
                                </g:each>
                                </ul>
                            </td>
                            
                        </tr>
                    
                        <tr class="prop">
                            <td valign="top" class="name">Suppliers:</td>
                            
                            <td  valign="top" style="text-align:left;" class="value">
                                <ul>
                                <g:each var="s" in="${inventoryItemInstance.suppliers}">
                                    <li><g:link controller="supplierDetailed" action="show" id="${s.id}">${s?.encodeAsHTML()}</g:link></li>
                                </g:each>
                                </ul>
                            </td>
                            
                        </tr>
                    
                    </tbody>
                </table>
            </div>
            <div class="buttons">
                <g:form>
                    <input type="hidden" name="id" value="${inventoryItemInstance?.id}" />
                    <span class="button"><g:actionSubmit class="edit" value="Edit" /></span>
                    <span class="button"><g:actionSubmit class="delete" onclick="return confirm('Are you sure?');" value="Delete" /></span>
                </g:form>
            </div>
        </div>
    </body>
</html>
