/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.jdbc;

import com.mysql.jdbc.AssertionFailedException;
import com.mysql.jdbc.ByteArrayRow;
import com.mysql.jdbc.CachedResultSetMetaData;
import com.mysql.jdbc.CharsetMapping;
import com.mysql.jdbc.Connection;
import com.mysql.jdbc.ConnectionImpl;
import com.mysql.jdbc.Constants;
import com.mysql.jdbc.DatabaseMetaData;
import com.mysql.jdbc.EscapeProcessor;
import com.mysql.jdbc.EscapeProcessorResult;
import com.mysql.jdbc.Field;
import com.mysql.jdbc.Messages;
import com.mysql.jdbc.MysqlIO;
import com.mysql.jdbc.PingTarget;
import com.mysql.jdbc.PreparedStatement;
import com.mysql.jdbc.ResultSetImpl;
import com.mysql.jdbc.ResultSetInternalMethods;
import com.mysql.jdbc.RowDataStatic;
import com.mysql.jdbc.SQLError;
import com.mysql.jdbc.SingleByteCharsetConverter;
import com.mysql.jdbc.Statement;
import com.mysql.jdbc.StringUtils;
import com.mysql.jdbc.Util;
import com.mysql.jdbc.exceptions.MySQLStatementCancelledException;
import com.mysql.jdbc.exceptions.MySQLTimeoutException;
import com.mysql.jdbc.profiler.ProfilerEvent;
import com.mysql.jdbc.profiler.ProfilerEventHandler;
import com.mysql.jdbc.profiler.ProfilerEventHandlerFactory;
import java.io.InputStream;
import java.sql.BatchUpdateException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import java.util.TimerTask;

public class StatementImpl
implements Statement {
    protected static final String PING_MARKER = "/* ping */";
    protected Object cancelTimeoutMutex = new Object();
    protected static int statementCounter = 1;
    public static final byte USES_VARIABLES_FALSE = 0;
    public static final byte USES_VARIABLES_TRUE = 1;
    public static final byte USES_VARIABLES_UNKNOWN = -1;
    protected boolean wasCancelled = false;
    protected boolean wasCancelledByTimeout = false;
    protected List batchedArgs;
    protected SingleByteCharsetConverter charConverter = null;
    protected String charEncoding = null;
    protected ConnectionImpl connection = null;
    protected long connectionId = 0L;
    protected String currentCatalog = null;
    protected boolean doEscapeProcessing = true;
    protected ProfilerEventHandler eventSink = null;
    private int fetchSize = 0;
    protected boolean isClosed = false;
    protected long lastInsertId = -1L;
    protected int maxFieldSize = MysqlIO.getMaxBuf();
    protected int maxRows = -1;
    protected boolean maxRowsChanged = false;
    protected List openResults = new ArrayList();
    protected boolean pedantic = false;
    protected Throwable pointOfOrigin;
    protected boolean profileSQL = false;
    protected ResultSetInternalMethods results = null;
    protected int resultSetConcurrency = 0;
    protected int resultSetType = 0;
    protected int statementId;
    protected int timeoutInMillis = 0;
    protected long updateCount = -1L;
    protected boolean useUsageAdvisor = false;
    protected SQLWarning warningChain = null;
    protected boolean holdResultsOpenOverClose = false;
    protected ArrayList batchedGeneratedKeys = null;
    protected boolean retrieveGeneratedKeys = false;
    protected boolean continueBatchOnError = false;
    protected PingTarget pingTarget = null;
    protected boolean useLegacyDatetimeCode;
    private int originalResultSetType = 0;
    private int originalFetchSize = 0;
    private boolean isPoolable = true;
    private InputStream localInfileInputStream;

    public StatementImpl(ConnectionImpl c, String catalog) throws SQLException {
        int maxRowsConn;
        boolean profiling;
        if (c == null || c.isClosed()) {
            throw SQLError.createSQLException(Messages.getString("Statement.0"), "08003");
        }
        this.connection = c;
        this.connectionId = this.connection.getId();
        this.currentCatalog = catalog;
        this.pedantic = this.connection.getPedantic();
        this.continueBatchOnError = this.connection.getContinueBatchOnError();
        this.useLegacyDatetimeCode = this.connection.getUseLegacyDatetimeCode();
        if (!this.connection.getDontTrackOpenResources()) {
            this.connection.registerStatement(this);
        }
        if (this.connection != null) {
            this.maxFieldSize = this.connection.getMaxAllowedPacket();
            int defaultFetchSize = this.connection.getDefaultFetchSize();
            if (defaultFetchSize != 0) {
                this.setFetchSize(defaultFetchSize);
            }
        }
        if (this.connection.getUseUnicode()) {
            this.charEncoding = this.connection.getEncoding();
            this.charConverter = this.connection.getCharsetConverter(this.charEncoding);
        }
        boolean bl = profiling = this.connection.getProfileSql() || this.connection.getUseUsageAdvisor() || this.connection.getLogSlowQueries();
        if (this.connection.getAutoGenerateTestcaseScript() || profiling) {
            this.statementId = statementCounter++;
        }
        if (profiling) {
            this.pointOfOrigin = new Throwable();
            this.profileSQL = this.connection.getProfileSql();
            this.useUsageAdvisor = this.connection.getUseUsageAdvisor();
            this.eventSink = ProfilerEventHandlerFactory.getInstance(this.connection);
        }
        if ((maxRowsConn = this.connection.getMaxRows()) != -1) {
            this.setMaxRows(maxRowsConn);
        }
    }

    public synchronized void addBatch(String sql) throws SQLException {
        if (this.batchedArgs == null) {
            this.batchedArgs = new ArrayList();
        }
        if (sql != null) {
            this.batchedArgs.add(sql);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() throws SQLException {
        if (!this.isClosed && this.connection != null && this.connection.versionMeetsMinimum(5, 0, 0)) {
            Connection cancelConn;
            block6: {
                cancelConn = null;
                java.sql.Statement cancelStmt = null;
                try {
                    cancelConn = this.connection.duplicate();
                    cancelStmt = cancelConn.createStatement();
                    cancelStmt.execute("KILL QUERY " + this.connection.getIO().getThreadId());
                    this.wasCancelled = true;
                    Object var4_3 = null;
                    if (cancelStmt == null) break block6;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    if (cancelStmt != null) {
                        cancelStmt.close();
                    }
                    if (cancelConn != null) {
                        cancelConn.close();
                    }
                    throw throwable;
                }
                cancelStmt.close();
            }
            if (cancelConn != null) {
                cancelConn.close();
            }
        }
    }

    protected void checkClosed() throws SQLException {
        if (this.isClosed) {
            throw SQLError.createSQLException(Messages.getString("Statement.49"), "08003");
        }
    }

    protected void checkForDml(String sql, char firstStatementChar) throws SQLException {
        String noCommentSql;
        if ((firstStatementChar == 'I' || firstStatementChar == 'U' || firstStatementChar == 'D' || firstStatementChar == 'A' || firstStatementChar == 'C') && (StringUtils.startsWithIgnoreCaseAndWs(noCommentSql = StringUtils.stripComments(sql, "'\"", "'\"", true, false, true, true), "INSERT") || StringUtils.startsWithIgnoreCaseAndWs(noCommentSql, "UPDATE") || StringUtils.startsWithIgnoreCaseAndWs(noCommentSql, "DELETE") || StringUtils.startsWithIgnoreCaseAndWs(noCommentSql, "DROP") || StringUtils.startsWithIgnoreCaseAndWs(noCommentSql, "CREATE") || StringUtils.startsWithIgnoreCaseAndWs(noCommentSql, "ALTER"))) {
            throw SQLError.createSQLException(Messages.getString("Statement.57"), "S1009");
        }
    }

    protected void checkNullOrEmptyQuery(String sql) throws SQLException {
        if (sql == null) {
            throw SQLError.createSQLException(Messages.getString("Statement.59"), "S1009");
        }
        if (sql.length() == 0) {
            throw SQLError.createSQLException(Messages.getString("Statement.61"), "S1009");
        }
    }

    public synchronized void clearBatch() throws SQLException {
        if (this.batchedArgs != null) {
            this.batchedArgs.clear();
        }
    }

    public void clearWarnings() throws SQLException {
        this.warningChain = null;
    }

    public synchronized void close() throws SQLException {
        this.realClose(true, true);
    }

    protected void closeAllOpenResults() {
        if (this.openResults != null) {
            Iterator iter = this.openResults.iterator();
            while (iter.hasNext()) {
                ResultSetInternalMethods element = (ResultSetInternalMethods)iter.next();
                try {
                    element.realClose(false);
                }
                catch (SQLException sqlEx) {
                    AssertionFailedException.shouldNotHappen(sqlEx);
                }
            }
            this.openResults.clear();
        }
    }

    private ResultSetInternalMethods createResultSetUsingServerFetch(String sql) throws SQLException {
        java.sql.PreparedStatement pStmt = this.connection.prepareStatement(sql, this.resultSetType, this.resultSetConcurrency);
        pStmt.setFetchSize(this.fetchSize);
        if (this.maxRows > -1) {
            pStmt.setMaxRows(this.maxRows);
        }
        pStmt.execute();
        ResultSetInternalMethods rs = ((StatementImpl)((Object)pStmt)).getResultSetInternal();
        rs.setStatementUsedForFetchingRows((PreparedStatement)pStmt);
        this.results = rs;
        return rs;
    }

    protected boolean createStreamingResultSet() {
        return this.resultSetType == 1003 && this.resultSetConcurrency == 1007 && this.fetchSize == Integer.MIN_VALUE;
    }

    public void enableStreamingResults() throws SQLException {
        this.originalResultSetType = this.resultSetType;
        this.originalFetchSize = this.fetchSize;
        this.setFetchSize(Integer.MIN_VALUE);
        this.setResultSetType(1003);
    }

    public void disableStreamingResults() throws SQLException {
        if (this.fetchSize == Integer.MIN_VALUE && this.resultSetType == 1003) {
            this.setFetchSize(this.originalFetchSize);
            this.setResultSetType(this.originalResultSetType);
        }
    }

    public boolean execute(String sql) throws SQLException {
        return this.execute(sql, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean execute(String sql, boolean returnGeneratedKeys) throws SQLException {
        this.checkClosed();
        ConnectionImpl locallyScopedConn = this.connection;
        Object object = locallyScopedConn.getMutex();
        synchronized (object) {
            ResultSetInternalMethods rs;
            CachedResultSetMetaData cachedMetaData;
            char firstNonWsChar;
            block32: {
                String oldCatalog;
                block30: {
                    boolean doStreaming;
                    boolean isSelect;
                    block31: {
                        this.retrieveGeneratedKeys = returnGeneratedKeys;
                        this.resetCancelledState();
                        this.checkNullOrEmptyQuery(sql);
                        this.checkClosed();
                        firstNonWsChar = StringUtils.firstAlphaCharUc(sql, this.findStartOfStatement(sql));
                        isSelect = true;
                        if (firstNonWsChar != 'S') {
                            isSelect = false;
                            if (locallyScopedConn.isReadOnly()) {
                                throw SQLError.createSQLException(Messages.getString("Statement.27") + Messages.getString("Statement.28"), "S1009");
                            }
                        }
                        if ((doStreaming = this.createStreamingResultSet()) && this.connection.getNetTimeoutForStreamingResults() > 0) {
                            this.executeSimpleNonQuery(locallyScopedConn, "SET net_write_timeout=" + this.connection.getNetTimeoutForStreamingResults());
                        }
                        if (this.doEscapeProcessing) {
                            Object escapedSqlResult = EscapeProcessor.escapeSQL(sql, locallyScopedConn.serverSupportsConvertFn(), locallyScopedConn);
                            sql = escapedSqlResult instanceof String ? (String)escapedSqlResult : ((EscapeProcessorResult)escapedSqlResult).escapedSql;
                        }
                        if (this.results != null && !locallyScopedConn.getHoldResultsOpenOverStatementClose()) {
                            this.results.realClose(false);
                        }
                        if (sql.charAt(0) == '/' && sql.startsWith(PING_MARKER)) {
                            this.doPingInstead();
                            return true;
                        }
                        cachedMetaData = null;
                        rs = null;
                        this.batchedGeneratedKeys = null;
                        if (!this.useServerFetch()) break block31;
                        rs = this.createResultSetUsingServerFetch(sql);
                        break block32;
                    }
                    TimerTask timeoutTask = null;
                    oldCatalog = null;
                    try {
                        block35: {
                            Field[] cachedFields;
                            block33: {
                                int rowLimit;
                                block29: {
                                    block34: {
                                        if (locallyScopedConn.getEnableQueryTimeouts() && this.timeoutInMillis != 0 && locallyScopedConn.versionMeetsMinimum(5, 0, 0)) {
                                            timeoutTask = new CancelTask(this);
                                            ConnectionImpl.getCancelTimer().schedule(timeoutTask, this.timeoutInMillis);
                                        }
                                        if (!locallyScopedConn.getCatalog().equals(this.currentCatalog)) {
                                            oldCatalog = locallyScopedConn.getCatalog();
                                            locallyScopedConn.setCatalog(this.currentCatalog);
                                        }
                                        cachedFields = null;
                                        if (locallyScopedConn.getCacheResultSetMetadata() && (cachedMetaData = locallyScopedConn.getCachedMetaData(sql)) != null) {
                                            cachedFields = cachedMetaData.fields;
                                        }
                                        if (!locallyScopedConn.useMaxRows()) break block33;
                                        rowLimit = -1;
                                        if (!isSelect) break block34;
                                        if (StringUtils.indexOfIgnoreCase(sql, "LIMIT") != -1) {
                                            rowLimit = this.maxRows;
                                            break block29;
                                        } else if (this.maxRows <= 0) {
                                            this.executeSimpleNonQuery(locallyScopedConn, "SET OPTION SQL_SELECT_LIMIT=DEFAULT");
                                            break block29;
                                        } else {
                                            this.executeSimpleNonQuery(locallyScopedConn, "SET OPTION SQL_SELECT_LIMIT=" + this.maxRows);
                                        }
                                        break block29;
                                    }
                                    this.executeSimpleNonQuery(locallyScopedConn, "SET OPTION SQL_SELECT_LIMIT=DEFAULT");
                                }
                                rs = locallyScopedConn.execSQL(this, sql, rowLimit, null, this.resultSetType, this.resultSetConcurrency, doStreaming, this.currentCatalog, cachedFields);
                                break block35;
                            }
                            rs = locallyScopedConn.execSQL(this, sql, -1, null, this.resultSetType, this.resultSetConcurrency, doStreaming, this.currentCatalog, cachedFields);
                        }
                        if (timeoutTask != null) {
                            if (((CancelTask)timeoutTask).caughtWhileCancelling != null) {
                                throw ((CancelTask)timeoutTask).caughtWhileCancelling;
                            }
                            timeoutTask.cancel();
                            timeoutTask = null;
                        }
                        Object object2 = this.cancelTimeoutMutex;
                        synchronized (object2) {
                            if (this.wasCancelled) {
                                SQLException cause = null;
                                cause = this.wasCancelledByTimeout ? new MySQLTimeoutException() : new MySQLStatementCancelledException();
                                this.resetCancelledState();
                                throw cause;
                            }
                        }
                        Object var17_16 = null;
                        if (timeoutTask == null) break block30;
                    }
                    catch (Throwable throwable) {
                        Object var17_17 = null;
                        if (timeoutTask != null) {
                            timeoutTask.cancel();
                        }
                        if (oldCatalog == null) throw throwable;
                        locallyScopedConn.setCatalog(oldCatalog);
                        throw throwable;
                    }
                    timeoutTask.cancel();
                }
                if (oldCatalog != null) {
                    locallyScopedConn.setCatalog(oldCatalog);
                }
            }
            if (rs != null) {
                this.lastInsertId = rs.getUpdateID();
                this.results = rs;
                rs.setFirstCharOfQuery(firstNonWsChar);
                if (rs.reallyResult()) {
                    if (cachedMetaData != null) {
                        locallyScopedConn.initializeResultsMetadataFromCache(sql, cachedMetaData, this.results);
                    } else if (this.connection.getCacheResultSetMetadata()) {
                        locallyScopedConn.initializeResultsMetadataFromCache(sql, null, this.results);
                    }
                }
            }
            if (rs == null) return false;
            if (!rs.reallyResult()) return false;
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void resetCancelledState() {
        if (this.cancelTimeoutMutex == null) {
            return;
        }
        Object object = this.cancelTimeoutMutex;
        synchronized (object) {
            this.wasCancelled = false;
            this.wasCancelledByTimeout = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(String sql, int returnGeneratedKeys) throws SQLException {
        if (returnGeneratedKeys == 1) {
            this.checkClosed();
            ConnectionImpl locallyScopedConn = this.connection;
            Object object = locallyScopedConn.getMutex();
            synchronized (object) {
                boolean bl;
                boolean readInfoMsgState = this.connection.isReadInfoMsgEnabled();
                locallyScopedConn.setReadInfoMsgEnabled(true);
                try {
                    bl = this.execute(sql, true);
                    locallyScopedConn.setReadInfoMsgEnabled(readInfoMsgState);
                }
                catch (Throwable throwable) {
                    locallyScopedConn.setReadInfoMsgEnabled(readInfoMsgState);
                    throw throwable;
                }
                return bl;
            }
        }
        return this.execute(sql);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(String sql, int[] generatedKeyIndices) throws SQLException {
        if (generatedKeyIndices != null && generatedKeyIndices.length > 0) {
            this.checkClosed();
            ConnectionImpl locallyScopedConn = this.connection;
            Object object = locallyScopedConn.getMutex();
            synchronized (object) {
                boolean bl;
                this.retrieveGeneratedKeys = true;
                boolean readInfoMsgState = locallyScopedConn.isReadInfoMsgEnabled();
                locallyScopedConn.setReadInfoMsgEnabled(true);
                try {
                    bl = this.execute(sql, true);
                    locallyScopedConn.setReadInfoMsgEnabled(readInfoMsgState);
                }
                catch (Throwable throwable) {
                    locallyScopedConn.setReadInfoMsgEnabled(readInfoMsgState);
                    throw throwable;
                }
                return bl;
            }
        }
        return this.execute(sql);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(String sql, String[] generatedKeyNames) throws SQLException {
        if (generatedKeyNames != null && generatedKeyNames.length > 0) {
            this.checkClosed();
            ConnectionImpl locallyScopedConn = this.connection;
            Object object = locallyScopedConn.getMutex();
            synchronized (object) {
                boolean bl;
                this.retrieveGeneratedKeys = true;
                boolean readInfoMsgState = this.connection.isReadInfoMsgEnabled();
                locallyScopedConn.setReadInfoMsgEnabled(true);
                try {
                    bl = this.execute(sql, true);
                    locallyScopedConn.setReadInfoMsgEnabled(readInfoMsgState);
                }
                catch (Throwable throwable) {
                    locallyScopedConn.setReadInfoMsgEnabled(readInfoMsgState);
                    throw throwable;
                }
                return bl;
            }
        }
        return this.execute(sql);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized int[] executeBatch() throws SQLException {
        this.checkClosed();
        ConnectionImpl locallyScopedConn = this.connection;
        if (locallyScopedConn.isReadOnly()) {
            throw SQLError.createSQLException(Messages.getString("Statement.34") + Messages.getString("Statement.35"), "S1009");
        }
        if (this.results != null && !locallyScopedConn.getHoldResultsOpenOverStatementClose()) {
            this.results.realClose(false);
        }
        Object object = locallyScopedConn.getMutex();
        synchronized (object) {
            int[] nArray;
            TimerTask timeoutTask;
            int individualStatementTimeout;
            block25: {
                int[] nArray2;
                block23: {
                    block24: {
                        if (this.batchedArgs == null) return new int[0];
                        if (this.batchedArgs.size() == 0) {
                            return new int[0];
                        }
                        individualStatementTimeout = this.timeoutInMillis;
                        this.timeoutInMillis = 0;
                        timeoutTask = null;
                        try {
                            this.resetCancelledState();
                            this.retrieveGeneratedKeys = true;
                            int[] updateCounts = null;
                            if (this.batchedArgs != null) {
                                int nbrCommands = this.batchedArgs.size();
                                this.batchedGeneratedKeys = new ArrayList(this.batchedArgs.size());
                                boolean multiQueriesEnabled = locallyScopedConn.getAllowMultiQueries();
                                if (locallyScopedConn.versionMeetsMinimum(4, 1, 1) && (multiQueriesEnabled || locallyScopedConn.getRewriteBatchedStatements() && nbrCommands > 4)) {
                                    nArray2 = this.executeBatchUsingMultiQueries(multiQueriesEnabled, nbrCommands, individualStatementTimeout);
                                    Object var14_12 = null;
                                    if (timeoutTask == null) break block23;
                                    break block24;
                                }
                                if (locallyScopedConn.getEnableQueryTimeouts() && individualStatementTimeout != 0 && locallyScopedConn.versionMeetsMinimum(5, 0, 0)) {
                                    timeoutTask = new CancelTask(this);
                                    ConnectionImpl.getCancelTimer().schedule(timeoutTask, individualStatementTimeout);
                                }
                                updateCounts = new int[nbrCommands];
                                for (int i = 0; i < nbrCommands; ++i) {
                                    updateCounts[i] = -3;
                                }
                                Throwable sqlEx = null;
                                int commandIndex = 0;
                                for (commandIndex = 0; commandIndex < nbrCommands; ++commandIndex) {
                                    try {
                                        updateCounts[commandIndex] = this.executeUpdate((String)this.batchedArgs.get(commandIndex), true, true);
                                        this.getBatchedGeneratedKeys();
                                        continue;
                                    }
                                    catch (SQLException ex) {
                                        updateCounts[commandIndex] = -3;
                                        if (this.continueBatchOnError && !(ex instanceof MySQLTimeoutException) && !(ex instanceof MySQLStatementCancelledException) && !this.hasDeadlockOrTimeoutRolledBackTx(ex)) {
                                            sqlEx = ex;
                                            continue;
                                        }
                                        int[] newUpdateCounts = new int[commandIndex];
                                        if (!this.hasDeadlockOrTimeoutRolledBackTx(ex)) {
                                            System.arraycopy(updateCounts, 0, newUpdateCounts, 0, commandIndex);
                                            throw new BatchUpdateException(ex.getMessage(), ex.getSQLState(), ex.getErrorCode(), newUpdateCounts);
                                        }
                                        int i = 0;
                                        while (i < newUpdateCounts.length) {
                                            newUpdateCounts[i] = -3;
                                            ++i;
                                        }
                                        throw new BatchUpdateException(ex.getMessage(), ex.getSQLState(), ex.getErrorCode(), newUpdateCounts);
                                    }
                                }
                                if (sqlEx != null) {
                                    throw new BatchUpdateException(sqlEx.getMessage(), ((SQLException)sqlEx).getSQLState(), ((SQLException)sqlEx).getErrorCode(), updateCounts);
                                }
                            }
                            if (timeoutTask != null) {
                                if (((CancelTask)timeoutTask).caughtWhileCancelling != null) {
                                    throw ((CancelTask)timeoutTask).caughtWhileCancelling;
                                }
                                timeoutTask.cancel();
                                timeoutTask = null;
                            }
                            nArray = updateCounts != null ? updateCounts : new int[]{};
                            break block25;
                        }
                        catch (Throwable throwable) {
                            Object var14_14 = null;
                            if (timeoutTask != null) {
                                timeoutTask.cancel();
                            }
                            this.resetCancelledState();
                            this.timeoutInMillis = individualStatementTimeout;
                            this.clearBatch();
                            throw throwable;
                        }
                    }
                    timeoutTask.cancel();
                }
                this.resetCancelledState();
                this.timeoutInMillis = individualStatementTimeout;
                this.clearBatch();
                return nArray2;
            }
            Object var14_13 = null;
            if (timeoutTask != null) {
                timeoutTask.cancel();
            }
            this.resetCancelledState();
            this.timeoutInMillis = individualStatementTimeout;
            this.clearBatch();
            return nArray;
        }
    }

    protected final boolean hasDeadlockOrTimeoutRolledBackTx(SQLException ex) {
        int vendorCode = ex.getErrorCode();
        switch (vendorCode) {
            case 1206: 
            case 1213: {
                return true;
            }
            case 1205: {
                try {
                    return !this.connection.versionMeetsMinimum(5, 0, 13);
                }
                catch (SQLException sqlEx) {
                    return false;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int[] executeBatchUsingMultiQueries(boolean multiQueriesEnabled, int nbrCommands, int individualStatementTimeout) throws SQLException {
        int[] nArray;
        java.sql.Statement batchStmt;
        ConnectionImpl locallyScopedConn;
        block29: {
            locallyScopedConn = this.connection;
            if (!multiQueriesEnabled) {
                locallyScopedConn.getIO().enableMultiQueries();
            }
            batchStmt = null;
            TimerTask timeoutTask = null;
            try {
                int[] updateCounts = new int[nbrCommands];
                for (int i = 0; i < nbrCommands; ++i) {
                    updateCounts[i] = -3;
                }
                int commandIndex = 0;
                StringBuffer queryBuf = new StringBuffer();
                batchStmt = locallyScopedConn.createStatement();
                if (locallyScopedConn.getEnableQueryTimeouts() && individualStatementTimeout != 0 && locallyScopedConn.versionMeetsMinimum(5, 0, 0)) {
                    timeoutTask = new CancelTask((StatementImpl)batchStmt);
                    ConnectionImpl.getCancelTimer().schedule(timeoutTask, individualStatementTimeout);
                }
                int counter = 0;
                int numberOfBytesPerChar = 1;
                String connectionEncoding = locallyScopedConn.getEncoding();
                if (StringUtils.startsWithIgnoreCase(connectionEncoding, "utf")) {
                    numberOfBytesPerChar = 3;
                } else if (CharsetMapping.isMultibyteCharset(connectionEncoding)) {
                    numberOfBytesPerChar = 2;
                }
                int escapeAdjust = 1;
                if (this.doEscapeProcessing) {
                    escapeAdjust = 2;
                }
                Throwable sqlEx = null;
                int argumentSetsInBatchSoFar = 0;
                for (commandIndex = 0; commandIndex < nbrCommands; ++commandIndex) {
                    String nextQuery = (String)this.batchedArgs.get(commandIndex);
                    if (((queryBuf.length() + nextQuery.length()) * numberOfBytesPerChar + 1 + 4) * escapeAdjust + 32 > this.connection.getMaxAllowedPacket()) {
                        try {
                            batchStmt.execute(queryBuf.toString(), 1);
                        }
                        catch (SQLException ex) {
                            sqlEx = this.handleExceptionForBatch(commandIndex, argumentSetsInBatchSoFar, updateCounts, ex);
                        }
                        counter = this.processMultiCountsAndKeys((StatementImpl)batchStmt, counter, updateCounts);
                        queryBuf = new StringBuffer();
                        argumentSetsInBatchSoFar = 0;
                    }
                    queryBuf.append(nextQuery);
                    queryBuf.append(";");
                    ++argumentSetsInBatchSoFar;
                }
                if (queryBuf.length() > 0) {
                    try {
                        batchStmt.execute(queryBuf.toString(), 1);
                    }
                    catch (SQLException ex) {
                        sqlEx = this.handleExceptionForBatch(commandIndex - 1, argumentSetsInBatchSoFar, updateCounts, ex);
                    }
                    counter = this.processMultiCountsAndKeys((StatementImpl)batchStmt, counter, updateCounts);
                }
                if (timeoutTask != null) {
                    if (((CancelTask)timeoutTask).caughtWhileCancelling != null) {
                        throw ((CancelTask)timeoutTask).caughtWhileCancelling;
                    }
                    timeoutTask.cancel();
                    timeoutTask = null;
                }
                if (sqlEx != null) {
                    throw new BatchUpdateException(sqlEx.getMessage(), ((SQLException)sqlEx).getSQLState(), ((SQLException)sqlEx).getErrorCode(), updateCounts);
                }
                nArray = updateCounts != null ? updateCounts : new int[]{};
                Object var19_19 = null;
                if (timeoutTask == null) break block29;
            }
            catch (Throwable throwable) {
                Object var19_20 = null;
                if (timeoutTask != null) {
                    timeoutTask.cancel();
                }
                this.resetCancelledState();
                try {
                    if (batchStmt != null) {
                        batchStmt.close();
                    }
                }
                finally {
                    if (!multiQueriesEnabled) {
                        locallyScopedConn.getIO().disableMultiQueries();
                    }
                }
                throw throwable;
            }
            timeoutTask.cancel();
        }
        this.resetCancelledState();
        try {
            if (batchStmt != null) {
                batchStmt.close();
            }
        }
        finally {
            if (!multiQueriesEnabled) {
                locallyScopedConn.getIO().disableMultiQueries();
            }
        }
        return nArray;
    }

    protected int processMultiCountsAndKeys(StatementImpl batchedStatement, int updateCountCounter, int[] updateCounts) throws SQLException {
        long generatedKey;
        updateCounts[updateCountCounter++] = batchedStatement.getUpdateCount();
        boolean doGenKeys = this.batchedGeneratedKeys != null;
        Object row = null;
        if (doGenKeys) {
            generatedKey = batchedStatement.getLastInsertID();
            row = new byte[1][];
            row[0] = Long.toString(generatedKey).getBytes();
            this.batchedGeneratedKeys.add(new ByteArrayRow((byte[][])row));
        }
        while (batchedStatement.getMoreResults() || batchedStatement.getUpdateCount() != -1) {
            updateCounts[updateCountCounter++] = batchedStatement.getUpdateCount();
            if (!doGenKeys) continue;
            generatedKey = batchedStatement.getLastInsertID();
            row = new byte[1][];
            row[0] = Long.toString(generatedKey).getBytes();
            this.batchedGeneratedKeys.add(new ByteArrayRow((byte[][])row));
        }
        return updateCountCounter;
    }

    protected SQLException handleExceptionForBatch(int endOfBatchIndex, int numValuesPerBatch, int[] updateCounts, SQLException ex) throws BatchUpdateException {
        for (int j = endOfBatchIndex; j > endOfBatchIndex - numValuesPerBatch; --j) {
            updateCounts[j] = -3;
        }
        if (!this.continueBatchOnError || ex instanceof MySQLTimeoutException || ex instanceof MySQLStatementCancelledException || this.hasDeadlockOrTimeoutRolledBackTx(ex)) {
            int[] newUpdateCounts = new int[endOfBatchIndex];
            System.arraycopy(updateCounts, 0, newUpdateCounts, 0, endOfBatchIndex);
            throw new BatchUpdateException(ex.getMessage(), ex.getSQLState(), ex.getErrorCode(), newUpdateCounts);
        }
        SQLException sqlEx = ex;
        return sqlEx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet executeQuery(String sql) throws SQLException {
        this.checkClosed();
        ConnectionImpl locallyScopedConn = this.connection;
        Object object = locallyScopedConn.getMutex();
        synchronized (object) {
            String oldCatalog;
            CachedResultSetMetaData cachedMetaData;
            block32: {
                this.retrieveGeneratedKeys = false;
                this.resetCancelledState();
                this.checkNullOrEmptyQuery(sql);
                boolean doStreaming = this.createStreamingResultSet();
                if (doStreaming && this.connection.getNetTimeoutForStreamingResults() > 0) {
                    this.executeSimpleNonQuery(locallyScopedConn, "SET net_write_timeout=" + this.connection.getNetTimeoutForStreamingResults());
                }
                if (this.doEscapeProcessing) {
                    Object escapedSqlResult = EscapeProcessor.escapeSQL(sql, locallyScopedConn.serverSupportsConvertFn(), this.connection);
                    sql = escapedSqlResult instanceof String ? (String)escapedSqlResult : ((EscapeProcessorResult)escapedSqlResult).escapedSql;
                }
                char firstStatementChar = StringUtils.firstNonWsCharUc(sql, this.findStartOfStatement(sql));
                if (sql.charAt(0) == '/' && sql.startsWith(PING_MARKER)) {
                    this.doPingInstead();
                    return this.results;
                }
                this.checkForDml(sql, firstStatementChar);
                if (this.results != null && !locallyScopedConn.getHoldResultsOpenOverStatementClose()) {
                    this.results.realClose(false);
                }
                cachedMetaData = null;
                if (this.useServerFetch()) {
                    this.results = this.createResultSetUsingServerFetch(sql);
                    return this.results;
                }
                TimerTask timeoutTask = null;
                oldCatalog = null;
                try {
                    if (locallyScopedConn.getEnableQueryTimeouts() && this.timeoutInMillis != 0 && locallyScopedConn.versionMeetsMinimum(5, 0, 0)) {
                        timeoutTask = new CancelTask(this);
                        ConnectionImpl.getCancelTimer().schedule(timeoutTask, this.timeoutInMillis);
                    }
                    if (!locallyScopedConn.getCatalog().equals(this.currentCatalog)) {
                        oldCatalog = locallyScopedConn.getCatalog();
                        locallyScopedConn.setCatalog(this.currentCatalog);
                    }
                    Field[] cachedFields = null;
                    if (locallyScopedConn.getCacheResultSetMetadata() && (cachedMetaData = locallyScopedConn.getCachedMetaData(sql)) != null) {
                        cachedFields = cachedMetaData.fields;
                    }
                    if (locallyScopedConn.useMaxRows()) {
                        if (StringUtils.indexOfIgnoreCase(sql, "LIMIT") != -1) {
                            this.results = locallyScopedConn.execSQL(this, sql, this.maxRows, null, this.resultSetType, this.resultSetConcurrency, doStreaming, this.currentCatalog, cachedFields);
                        } else {
                            if (this.maxRows <= 0) {
                                this.executeSimpleNonQuery(locallyScopedConn, "SET OPTION SQL_SELECT_LIMIT=DEFAULT");
                            } else {
                                this.executeSimpleNonQuery(locallyScopedConn, "SET OPTION SQL_SELECT_LIMIT=" + this.maxRows);
                            }
                            this.results = locallyScopedConn.execSQL(this, sql, -1, null, this.resultSetType, this.resultSetConcurrency, doStreaming, this.currentCatalog, cachedFields);
                            if (oldCatalog != null) {
                                locallyScopedConn.setCatalog(oldCatalog);
                            }
                        }
                    } else {
                        this.results = locallyScopedConn.execSQL(this, sql, -1, null, this.resultSetType, this.resultSetConcurrency, doStreaming, this.currentCatalog, cachedFields);
                    }
                    if (timeoutTask != null) {
                        if (((CancelTask)timeoutTask).caughtWhileCancelling != null) {
                            throw ((CancelTask)timeoutTask).caughtWhileCancelling;
                        }
                        timeoutTask.cancel();
                        timeoutTask = null;
                    }
                    Object object2 = this.cancelTimeoutMutex;
                    synchronized (object2) {
                        if (this.wasCancelled) {
                            SQLException cause = null;
                            cause = this.wasCancelledByTimeout ? new MySQLTimeoutException() : new MySQLStatementCancelledException();
                            this.resetCancelledState();
                            throw cause;
                        }
                    }
                    Object var14_14 = null;
                    if (timeoutTask == null) break block32;
                }
                catch (Throwable throwable) {
                    Object var14_15 = null;
                    if (timeoutTask != null) {
                        timeoutTask.cancel();
                    }
                    if (oldCatalog != null) {
                        locallyScopedConn.setCatalog(oldCatalog);
                    }
                    throw throwable;
                }
                timeoutTask.cancel();
            }
            if (oldCatalog != null) {
                locallyScopedConn.setCatalog(oldCatalog);
            }
            this.lastInsertId = this.results.getUpdateID();
            if (cachedMetaData != null) {
                locallyScopedConn.initializeResultsMetadataFromCache(sql, cachedMetaData, this.results);
            } else if (this.connection.getCacheResultSetMetadata()) {
                locallyScopedConn.initializeResultsMetadataFromCache(sql, null, this.results);
            }
            return this.results;
        }
    }

    protected void doPingInstead() throws SQLException {
        ResultSetInternalMethods fakeSelectOneResultSet;
        if (this.pingTarget != null) {
            this.pingTarget.doPing();
        } else {
            this.connection.ping();
        }
        this.results = fakeSelectOneResultSet = this.generatePingResultSet();
    }

    protected ResultSetInternalMethods generatePingResultSet() throws SQLException {
        Field[] fields = new Field[]{new Field(null, "1", -5, 1)};
        ArrayList<ByteArrayRow> rows = new ArrayList<ByteArrayRow>();
        byte[] colVal = new byte[]{49};
        rows.add(new ByteArrayRow(new byte[][]{colVal}));
        return (ResultSetInternalMethods)DatabaseMetaData.buildResultSet(fields, rows, this.connection);
    }

    protected void executeSimpleNonQuery(ConnectionImpl c, String nonQuery) throws SQLException {
        c.execSQL(this, nonQuery, -1, null, 1003, 1007, false, this.currentCatalog, null, false).close();
    }

    public int executeUpdate(String sql) throws SQLException {
        return this.executeUpdate(sql, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int executeUpdate(String sql, boolean isBatch, boolean returnGeneratedKeys) throws SQLException {
        this.checkClosed();
        ConnectionImpl locallyScopedConn = this.connection;
        char firstStatementChar = StringUtils.firstAlphaCharUc(sql, this.findStartOfStatement(sql));
        ResultSetInternalMethods rs = null;
        Object object = locallyScopedConn.getMutex();
        synchronized (object) {
            String oldCatalog;
            block21: {
                this.retrieveGeneratedKeys = returnGeneratedKeys;
                this.resetCancelledState();
                this.checkNullOrEmptyQuery(sql);
                if (this.doEscapeProcessing) {
                    Object escapedSqlResult = EscapeProcessor.escapeSQL(sql, this.connection.serverSupportsConvertFn(), this.connection);
                    sql = escapedSqlResult instanceof String ? (String)escapedSqlResult : ((EscapeProcessorResult)escapedSqlResult).escapedSql;
                }
                if (locallyScopedConn.isReadOnly()) {
                    throw SQLError.createSQLException(Messages.getString("Statement.42") + Messages.getString("Statement.43"), "S1009");
                }
                if (StringUtils.startsWithIgnoreCaseAndWs(sql, "select")) {
                    throw SQLError.createSQLException(Messages.getString("Statement.46"), "01S03");
                }
                if (this.results != null && !locallyScopedConn.getHoldResultsOpenOverStatementClose()) {
                    this.results.realClose(false);
                }
                TimerTask timeoutTask = null;
                oldCatalog = null;
                try {
                    if (locallyScopedConn.getEnableQueryTimeouts() && this.timeoutInMillis != 0 && locallyScopedConn.versionMeetsMinimum(5, 0, 0)) {
                        timeoutTask = new CancelTask(this);
                        ConnectionImpl.getCancelTimer().schedule(timeoutTask, this.timeoutInMillis);
                    }
                    if (!locallyScopedConn.getCatalog().equals(this.currentCatalog)) {
                        oldCatalog = locallyScopedConn.getCatalog();
                        locallyScopedConn.setCatalog(this.currentCatalog);
                    }
                    if (locallyScopedConn.useMaxRows()) {
                        this.executeSimpleNonQuery(locallyScopedConn, "SET OPTION SQL_SELECT_LIMIT=DEFAULT");
                    }
                    rs = locallyScopedConn.execSQL(this, sql, -1, null, 1003, 1007, false, this.currentCatalog, null, isBatch);
                    if (timeoutTask != null) {
                        if (((CancelTask)timeoutTask).caughtWhileCancelling != null) {
                            throw ((CancelTask)timeoutTask).caughtWhileCancelling;
                        }
                        timeoutTask.cancel();
                        timeoutTask = null;
                    }
                    Object object2 = this.cancelTimeoutMutex;
                    synchronized (object2) {
                        if (this.wasCancelled) {
                            SQLException cause = null;
                            cause = this.wasCancelledByTimeout ? new MySQLTimeoutException() : new MySQLStatementCancelledException();
                            this.resetCancelledState();
                            throw cause;
                        }
                    }
                    Object var14_14 = null;
                    if (timeoutTask == null) break block21;
                }
                catch (Throwable throwable) {
                    Object var14_15 = null;
                    if (timeoutTask != null) {
                        timeoutTask.cancel();
                    }
                    if (oldCatalog != null) {
                        locallyScopedConn.setCatalog(oldCatalog);
                    }
                    throw throwable;
                }
                timeoutTask.cancel();
            }
            if (oldCatalog != null) {
                locallyScopedConn.setCatalog(oldCatalog);
            }
        }
        this.results = rs;
        rs.setFirstCharOfQuery(firstStatementChar);
        this.updateCount = rs.getUpdateCount();
        int truncatedUpdateCount = 0;
        truncatedUpdateCount = this.updateCount > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)this.updateCount;
        this.lastInsertId = rs.getUpdateID();
        return truncatedUpdateCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeUpdate(String sql, int returnGeneratedKeys) throws SQLException {
        if (returnGeneratedKeys == 1) {
            this.checkClosed();
            ConnectionImpl locallyScopedConn = this.connection;
            Object object = locallyScopedConn.getMutex();
            synchronized (object) {
                int n;
                boolean readInfoMsgState = locallyScopedConn.isReadInfoMsgEnabled();
                locallyScopedConn.setReadInfoMsgEnabled(true);
                try {
                    n = this.executeUpdate(sql, false, true);
                    locallyScopedConn.setReadInfoMsgEnabled(readInfoMsgState);
                }
                catch (Throwable throwable) {
                    locallyScopedConn.setReadInfoMsgEnabled(readInfoMsgState);
                    throw throwable;
                }
                return n;
            }
        }
        return this.executeUpdate(sql);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeUpdate(String sql, int[] generatedKeyIndices) throws SQLException {
        if (generatedKeyIndices != null && generatedKeyIndices.length > 0) {
            this.checkClosed();
            ConnectionImpl locallyScopedConn = this.connection;
            Object object = locallyScopedConn.getMutex();
            synchronized (object) {
                int n;
                boolean readInfoMsgState = locallyScopedConn.isReadInfoMsgEnabled();
                locallyScopedConn.setReadInfoMsgEnabled(true);
                try {
                    n = this.executeUpdate(sql, false, true);
                    locallyScopedConn.setReadInfoMsgEnabled(readInfoMsgState);
                }
                catch (Throwable throwable) {
                    locallyScopedConn.setReadInfoMsgEnabled(readInfoMsgState);
                    throw throwable;
                }
                return n;
            }
        }
        return this.executeUpdate(sql);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeUpdate(String sql, String[] generatedKeyNames) throws SQLException {
        if (generatedKeyNames != null && generatedKeyNames.length > 0) {
            this.checkClosed();
            ConnectionImpl locallyScopedConn = this.connection;
            Object object = locallyScopedConn.getMutex();
            synchronized (object) {
                int n;
                boolean readInfoMsgState = this.connection.isReadInfoMsgEnabled();
                locallyScopedConn.setReadInfoMsgEnabled(true);
                try {
                    n = this.executeUpdate(sql, false, true);
                    locallyScopedConn.setReadInfoMsgEnabled(readInfoMsgState);
                }
                catch (Throwable throwable) {
                    locallyScopedConn.setReadInfoMsgEnabled(readInfoMsgState);
                    throw throwable;
                }
                return n;
            }
        }
        return this.executeUpdate(sql);
    }

    protected Calendar getCalendarInstanceForSessionOrNew() {
        if (this.connection != null) {
            return this.connection.getCalendarInstanceForSessionOrNew();
        }
        return new GregorianCalendar();
    }

    public java.sql.Connection getConnection() throws SQLException {
        return this.connection;
    }

    public int getFetchDirection() throws SQLException {
        return 1000;
    }

    public int getFetchSize() throws SQLException {
        return this.fetchSize;
    }

    public synchronized ResultSet getGeneratedKeys() throws SQLException {
        if (!this.retrieveGeneratedKeys) {
            throw SQLError.createSQLException(Messages.getString("Statement.GeneratedKeysNotRequested"), "S1009");
        }
        if (this.batchedGeneratedKeys == null) {
            return this.getGeneratedKeysInternal();
        }
        Field[] fields = new Field[]{new Field("", "GENERATED_KEY", -5, 17)};
        fields[0].setConnection(this.connection);
        return ResultSetImpl.getInstance(this.currentCatalog, fields, new RowDataStatic(this.batchedGeneratedKeys), this.connection, this, false);
    }

    protected ResultSet getGeneratedKeysInternal() throws SQLException {
        Field[] fields = new Field[]{new Field("", "GENERATED_KEY", -5, 17)};
        fields[0].setConnection(this.connection);
        fields[0].setUseOldNameMetadata(true);
        ArrayList<ByteArrayRow> rowSet = new ArrayList<ByteArrayRow>();
        long beginAt = this.getLastInsertID();
        int numKeys = this.getUpdateCount();
        if (this.results != null) {
            String serverInfo = this.results.getServerInfo();
            if (numKeys > 0 && this.results.getFirstCharOfQuery() == 'R' && serverInfo != null && serverInfo.length() > 0) {
                numKeys = this.getRecordCountFromInfo(serverInfo);
            }
            if (beginAt > 0L && numKeys > 0) {
                for (int i = 0; i < numKeys; ++i) {
                    byte[][] row = new byte[][]{Long.toString(beginAt).getBytes()};
                    rowSet.add(new ByteArrayRow(row));
                    beginAt += (long)this.connection.getAutoIncrementIncrement();
                }
            }
        }
        ResultSetImpl gkRs = ResultSetImpl.getInstance(this.currentCatalog, fields, new RowDataStatic(rowSet), this.connection, this, false);
        this.openResults.add(gkRs);
        return gkRs;
    }

    protected int getId() {
        return this.statementId;
    }

    public long getLastInsertID() {
        return this.lastInsertId;
    }

    public long getLongUpdateCount() {
        if (this.results == null) {
            return -1L;
        }
        if (this.results.reallyResult()) {
            return -1L;
        }
        return this.updateCount;
    }

    public int getMaxFieldSize() throws SQLException {
        return this.maxFieldSize;
    }

    public int getMaxRows() throws SQLException {
        if (this.maxRows <= 0) {
            return 0;
        }
        return this.maxRows;
    }

    public boolean getMoreResults() throws SQLException {
        return this.getMoreResults(1);
    }

    public boolean getMoreResults(int current) throws SQLException {
        if (this.results == null) {
            return false;
        }
        boolean streamingMode = this.createStreamingResultSet();
        if (streamingMode && this.results.reallyResult()) {
            while (this.results.next()) {
            }
        }
        ResultSetInternalMethods nextResultSet = this.results.getNextResultSet();
        switch (current) {
            case 1: {
                if (this.results == null) break;
                if (!streamingMode) {
                    this.results.close();
                }
                this.results.clearNextResult();
                break;
            }
            case 3: {
                if (this.results != null) {
                    if (!streamingMode) {
                        this.results.close();
                    }
                    this.results.clearNextResult();
                }
                this.closeAllOpenResults();
                break;
            }
            case 2: {
                if (!this.connection.getDontTrackOpenResources()) {
                    this.openResults.add(this.results);
                }
                this.results.clearNextResult();
                break;
            }
            default: {
                throw SQLError.createSQLException(Messages.getString("Statement.19"), "S1009");
            }
        }
        this.results = nextResultSet;
        if (this.results == null) {
            this.updateCount = -1L;
            this.lastInsertId = -1L;
        } else if (this.results.reallyResult()) {
            this.updateCount = -1L;
            this.lastInsertId = -1L;
        } else {
            this.updateCount = this.results.getUpdateCount();
            this.lastInsertId = this.results.getUpdateID();
        }
        return this.results != null && this.results.reallyResult();
    }

    public int getQueryTimeout() throws SQLException {
        return this.timeoutInMillis / 1000;
    }

    private int getRecordCountFromInfo(String serverInfo) {
        int i;
        StringBuffer recordsBuf = new StringBuffer();
        int recordsCount = 0;
        int duplicatesCount = 0;
        char c = '\u0000';
        int length = serverInfo.length();
        for (i = 0; i < length && !Character.isDigit(c = serverInfo.charAt(i)); ++i) {
        }
        recordsBuf.append(c);
        ++i;
        while (i < length && Character.isDigit(c = serverInfo.charAt(i))) {
            recordsBuf.append(c);
            ++i;
        }
        recordsCount = Integer.parseInt(recordsBuf.toString());
        StringBuffer duplicatesBuf = new StringBuffer();
        while (i < length && !Character.isDigit(c = serverInfo.charAt(i))) {
            ++i;
        }
        duplicatesBuf.append(c);
        ++i;
        while (i < length && Character.isDigit(c = serverInfo.charAt(i))) {
            duplicatesBuf.append(c);
            ++i;
        }
        duplicatesCount = Integer.parseInt(duplicatesBuf.toString());
        return recordsCount - duplicatesCount;
    }

    public ResultSet getResultSet() throws SQLException {
        return this.results != null && this.results.reallyResult() ? this.results : null;
    }

    public int getResultSetConcurrency() throws SQLException {
        return this.resultSetConcurrency;
    }

    public int getResultSetHoldability() throws SQLException {
        return 1;
    }

    protected ResultSetInternalMethods getResultSetInternal() {
        return this.results;
    }

    public int getResultSetType() throws SQLException {
        return this.resultSetType;
    }

    public int getUpdateCount() throws SQLException {
        if (this.results == null) {
            return -1;
        }
        if (this.results.reallyResult()) {
            return -1;
        }
        int truncatedUpdateCount = 0;
        truncatedUpdateCount = this.results.getUpdateCount() > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)this.results.getUpdateCount();
        return truncatedUpdateCount;
    }

    public SQLWarning getWarnings() throws SQLException {
        this.checkClosed();
        if (this.connection != null && !this.connection.isClosed() && this.connection.versionMeetsMinimum(4, 1, 0)) {
            SQLWarning pendingWarningsFromServer = SQLError.convertShowWarningsToSQLWarnings(this.connection);
            if (this.warningChain != null) {
                this.warningChain.setNextWarning(pendingWarningsFromServer);
            } else {
                this.warningChain = pendingWarningsFromServer;
            }
            return this.warningChain;
        }
        return this.warningChain;
    }

    protected void realClose(boolean calledExplicitly, boolean closeOpenResults) throws SQLException {
        if (this.isClosed) {
            return;
        }
        if (this.useUsageAdvisor && !calledExplicitly) {
            String message = Messages.getString("Statement.63") + Messages.getString("Statement.64");
            this.eventSink.consumeEvent(new ProfilerEvent(0, "", this.currentCatalog, this.connectionId, this.getId(), -1, System.currentTimeMillis(), 0L, Constants.MILLIS_I18N, null, this.pointOfOrigin, message));
        }
        if (closeOpenResults) {
            boolean bl = closeOpenResults = !this.holdResultsOpenOverClose;
        }
        if (closeOpenResults) {
            if (this.results != null) {
                try {
                    this.results.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.closeAllOpenResults();
        }
        if (this.connection != null) {
            if (this.maxRowsChanged) {
                this.connection.unsetMaxRows(this);
            }
            if (!this.connection.getDontTrackOpenResources()) {
                this.connection.unregisterStatement(this);
            }
        }
        this.isClosed = true;
        this.results = null;
        this.connection = null;
        this.warningChain = null;
        this.openResults = null;
        this.batchedGeneratedKeys = null;
        this.localInfileInputStream = null;
        this.pingTarget = null;
    }

    public void setCursorName(String name) throws SQLException {
    }

    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.doEscapeProcessing = enable;
    }

    public void setFetchDirection(int direction) throws SQLException {
        switch (direction) {
            case 1000: 
            case 1001: 
            case 1002: {
                break;
            }
            default: {
                throw SQLError.createSQLException(Messages.getString("Statement.5"), "S1009");
            }
        }
    }

    public void setFetchSize(int rows) throws SQLException {
        if (rows < 0 && rows != Integer.MIN_VALUE || this.maxRows != 0 && this.maxRows != -1 && rows > this.getMaxRows()) {
            throw SQLError.createSQLException(Messages.getString("Statement.7"), "S1009");
        }
        this.fetchSize = rows;
    }

    protected void setHoldResultsOpenOverClose(boolean holdResultsOpenOverClose) {
        this.holdResultsOpenOverClose = holdResultsOpenOverClose;
    }

    public void setMaxFieldSize(int max) throws SQLException {
        int maxBuf;
        if (max < 0) {
            throw SQLError.createSQLException(Messages.getString("Statement.11"), "S1009");
        }
        int n = maxBuf = this.connection != null ? this.connection.getMaxAllowedPacket() : MysqlIO.getMaxBuf();
        if (max > maxBuf) {
            throw SQLError.createSQLException(Messages.getString("Statement.13", new Object[]{Constants.longValueOf(maxBuf)}), "S1009");
        }
        this.maxFieldSize = max;
    }

    public void setMaxRows(int max) throws SQLException {
        if (max > 50000000 || max < 0) {
            throw SQLError.createSQLException(Messages.getString("Statement.15") + max + " > " + 50000000 + ".", "S1009");
        }
        if (max == 0) {
            max = -1;
        }
        this.maxRows = max;
        this.maxRowsChanged = true;
        if (this.maxRows == -1) {
            this.connection.unsetMaxRows(this);
            this.maxRowsChanged = false;
        } else {
            this.connection.maxRowsChanged(this);
        }
    }

    public void setQueryTimeout(int seconds) throws SQLException {
        if (seconds < 0) {
            throw SQLError.createSQLException(Messages.getString("Statement.21"), "S1009");
        }
        this.timeoutInMillis = seconds * 1000;
    }

    void setResultSetConcurrency(int concurrencyFlag) {
        this.resultSetConcurrency = concurrencyFlag;
    }

    void setResultSetType(int typeFlag) {
        this.resultSetType = typeFlag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void getBatchedGeneratedKeys(java.sql.Statement batchedStatement) throws SQLException {
        if (this.retrieveGeneratedKeys) {
            ResultSet rs = null;
            try {
                rs = batchedStatement.getGeneratedKeys();
                while (rs.next()) {
                    this.batchedGeneratedKeys.add(new ByteArrayRow(new byte[][]{rs.getBytes(1)}));
                }
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void getBatchedGeneratedKeys() throws SQLException {
        if (this.retrieveGeneratedKeys) {
            ResultSet rs = null;
            try {
                rs = this.getGeneratedKeysInternal();
                while (rs.next()) {
                    this.batchedGeneratedKeys.add(new ByteArrayRow(new byte[][]{rs.getBytes(1)}));
                }
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
    }

    private boolean useServerFetch() throws SQLException {
        return this.connection.isCursorFetchEnabled() && this.fetchSize > 0 && this.resultSetConcurrency == 1007 && this.resultSetType == 1003;
    }

    public synchronized boolean isClosed() throws SQLException {
        return this.isClosed;
    }

    public boolean isPoolable() throws SQLException {
        return this.isPoolable;
    }

    public void setPoolable(boolean poolable) throws SQLException {
        this.isPoolable = poolable;
    }

    public boolean isWrapperFor(Class iface) throws SQLException {
        this.checkClosed();
        return iface.isInstance(this);
    }

    public Object unwrap(Class iface) throws SQLException {
        try {
            return Util.cast(iface, this);
        }
        catch (ClassCastException cce) {
            throw SQLError.createSQLException("Unable to unwrap to " + iface.toString(), "S1009");
        }
    }

    protected int findStartOfStatement(String sql) {
        int statementStartPos = 0;
        if (StringUtils.startsWithIgnoreCaseAndWs(sql, "/*")) {
            statementStartPos = sql.indexOf("*/");
            statementStartPos = statementStartPos == -1 ? 0 : (statementStartPos += 2);
        } else if ((StringUtils.startsWithIgnoreCaseAndWs(sql, "--") || StringUtils.startsWithIgnoreCaseAndWs(sql, "#")) && (statementStartPos = sql.indexOf(10)) == -1 && (statementStartPos = sql.indexOf(13)) == -1) {
            statementStartPos = 0;
        }
        return statementStartPos;
    }

    public synchronized InputStream getLocalInfileInputStream() {
        return this.localInfileInputStream;
    }

    public synchronized void setLocalInfileInputStream(InputStream stream) {
        this.localInfileInputStream = stream;
    }

    public synchronized void setPingTarget(PingTarget pingTarget) {
        this.pingTarget = pingTarget;
    }

    class CancelTask
    extends TimerTask {
        long connectionId = 0L;
        SQLException caughtWhileCancelling = null;
        StatementImpl toCancel;

        CancelTask(StatementImpl cancellee) throws SQLException {
            this.connectionId = StatementImpl.this.connection.getIO().getThreadId();
            this.toCancel = cancellee;
        }

        public void run() {
            Thread cancelThread = new Thread(this){
                private final /* synthetic */ CancelTask this$1;
                {
                    this.this$1 = this$1;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void run() {
                    java.sql.Connection cancelConn;
                    block22: {
                        cancelConn = null;
                        java.sql.Statement cancelStmt = null;
                        try {
                            try {
                                Object object = CancelTask.access$000((CancelTask)this.this$1).cancelTimeoutMutex;
                                synchronized (object) {
                                    cancelConn = CancelTask.access$000((CancelTask)this.this$1).connection.duplicate();
                                    cancelStmt = cancelConn.createStatement();
                                    cancelStmt.execute("KILL QUERY " + this.this$1.connectionId);
                                    this.this$1.toCancel.wasCancelled = true;
                                    this.this$1.toCancel.wasCancelledByTimeout = true;
                                }
                            }
                            catch (SQLException sqlEx) {
                                this.this$1.caughtWhileCancelling = sqlEx;
                                Object var6_7 = null;
                                if (cancelStmt != null) {
                                    try {
                                        cancelStmt.close();
                                    }
                                    catch (SQLException sqlEx2) {
                                        throw new RuntimeException(sqlEx2.toString());
                                    }
                                }
                                if (cancelConn == null) return;
                                try {
                                    cancelConn.close();
                                    return;
                                }
                                catch (SQLException sqlEx3) {
                                    throw new RuntimeException(sqlEx3.toString());
                                }
                            }
                            catch (NullPointerException nullPointerException) {
                                Object var6_8 = null;
                                if (cancelStmt != null) {
                                    try {}
                                    catch (SQLException sqlEx2) {
                                        throw new RuntimeException(sqlEx2.toString());
                                    }
                                    cancelStmt.close();
                                }
                                if (cancelConn == null) return;
                                try {}
                                catch (SQLException sqlEx3) {
                                    throw new RuntimeException(sqlEx3.toString());
                                }
                                cancelConn.close();
                                return;
                            }
                            Object var6_6 = null;
                            if (cancelStmt == null) break block22;
                        }
                        catch (Throwable throwable) {
                            Object var6_9 = null;
                            if (cancelStmt != null) {
                                try {}
                                catch (SQLException sqlEx2) {
                                    throw new RuntimeException(sqlEx2.toString());
                                }
                                cancelStmt.close();
                            }
                            if (cancelConn == null) throw throwable;
                            try {}
                            catch (SQLException sqlEx3) {
                                throw new RuntimeException(sqlEx3.toString());
                            }
                            cancelConn.close();
                            throw throwable;
                        }
                        try {}
                        catch (SQLException sqlEx2) {
                            throw new RuntimeException(sqlEx2.toString());
                        }
                        cancelStmt.close();
                    }
                    if (cancelConn == null) return;
                    try {}
                    catch (SQLException sqlEx3) {
                        throw new RuntimeException(sqlEx3.toString());
                    }
                    cancelConn.close();
                }
            };
            cancelThread.start();
        }

        static /* synthetic */ StatementImpl access$000(CancelTask x0) {
            return x0.StatementImpl.this;
        }
    }
}

