

<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
        <meta name="layout" content="main" />
        <title>Edit InventoryItem</title>
        <nav:resources override="true"/>
    </head>
    <body>
        <div class="nav">
            <nav:renderSubItems group="nav"/>
        </div>
        <div class="body">
            <g:if test="${flash.message}">
            <div class="message">${flash.message}</div>
            </g:if>
            <g:hasErrors bean="${inventoryItemInstance}">
            <div class="errors">
                <g:renderErrors bean="${inventoryItemInstance}" as="list" />
            </div>
            </g:hasErrors>
            <g:form method="post" >
                <input type="hidden" name="id" value="${inventoryItemInstance?.id}" />
                <input type="hidden" name="version" value="${inventoryItemInstance?.version}" />
                <div class="dialog">
                    <table>
                        <tbody>
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="name">Name:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:inventoryItemInstance,field:'name','errors')}">
                                    <input type="text" maxlength="75" id="name" name="name" value="${fieldValue(bean:inventoryItemInstance,field:'name')}"/>
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="description">Description:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:inventoryItemInstance,field:'description','errors')}">
                                    <input type="text" id="description" name="description" value="${fieldValue(bean:inventoryItemInstance,field:'description')}"/>
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="reorderPoint">Reorder Point:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:inventoryItemInstance,field:'reorderPoint','errors')}">
                                    <input type="text" id="reorderPoint" name="reorderPoint" value="${fieldValue(bean:inventoryItemInstance,field:'reorderPoint')}" />
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="enableReorder">Enable Reorder:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:inventoryItemInstance,field:'enableReorder','errors')}">
                                    <g:checkBox name="enableReorder" value="${inventoryItemInstance?.enableReorder}" ></g:checkBox>
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="isActive">Is Active:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:inventoryItemInstance,field:'isActive','errors')}">
                                    <g:checkBox name="isActive" value="${inventoryItemInstance?.isActive}" ></g:checkBox>
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="isObsolete">Is Obsolete:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:inventoryItemInstance,field:'isObsolete','errors')}">
                                    <g:checkBox name="isObsolete" value="${inventoryItemInstance?.isObsolete}" ></g:checkBox>
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="inventoryGroup">Inventory Group:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:inventoryItemInstance,field:'inventoryGroup','errors')}">
                                    <g:select optionKey="id" from="${InventoryGroup.list()}" name="inventoryGroup.id" value="${inventoryItemInstance?.inventoryGroup?.id}" ></g:select>
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="inventoryType">Inventory Type:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:inventoryItemInstance,field:'inventoryType','errors')}">
                                    <g:select optionKey="id" from="${InventoryType.list()}" name="inventoryType.id" value="${inventoryItemInstance?.inventoryType?.id}" ></g:select>
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="unitOfMeasure">Unit Of Measure:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:inventoryItemInstance,field:'unitOfMeasure','errors')}">
                                    <g:select optionKey="id" from="${UnitOfMeasure.list()}" name="unitOfMeasure.id" value="${inventoryItemInstance?.unitOfMeasure?.id}" ></g:select>
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="manufacturersPartNumber">Manufacturers Part Number:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:inventoryItemInstance,field:'manufacturersPartNumber','errors')}">
                                    <input type="text" id="manufacturersPartNumber" name="manufacturersPartNumber" value="${fieldValue(bean:inventoryItemInstance,field:'manufacturersPartNumber')}"/>
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="suppliersPartNumber">Suppliers Part Number:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:inventoryItemInstance,field:'suppliersPartNumber','errors')}">
                                    <input type="text" id="suppliersPartNumber" name="suppliersPartNumber" value="${fieldValue(bean:inventoryItemInstance,field:'suppliersPartNumber')}"/>
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="recommendedReorderPoint">Recommended Reorder Point:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:inventoryItemInstance,field:'recommendedReorderPoint','errors')}">
                                    <input type="text" id="recommendedReorderPoint" name="recommendedReorderPoint" value="${fieldValue(bean:inventoryItemInstance,field:'recommendedReorderPoint')}" />
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="averageDeliveryTime">Average Delivery Time:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:inventoryItemInstance,field:'averageDeliveryTime','errors')}">
                                    <input type="text" id="averageDeliveryTime" name="averageDeliveryTime" value="${fieldValue(bean:inventoryItemInstance,field:'averageDeliveryTime')}" />
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="alternateItems">Alternate Items:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:inventoryItemInstance,field:'alternateItems','errors')}">
                                    <g:select name="alternateItems"
from="${InventoryItem.list()}"
size="5" multiple="yes" optionKey="id"
value="${inventoryItemInstance?.alternateItems}" />

                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="inventoryMovements">Inventory Movements:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:inventoryItemInstance,field:'inventoryMovements','errors')}">
                                    
<ul>
<g:each var="i" in="${inventoryItemInstance?.inventoryMovements?}">
    <li><g:link controller="inventoryMovementDetailed" action="show" id="${i.id}">${i?.encodeAsHTML()}</g:link></li>
</g:each>
</ul>
<g:link controller="inventoryMovementDetailed" params="['inventoryItem.id':inventoryItemInstance?.id]" action="create">Add InventoryMovement</g:link>

                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="manufacturers">Manufacturers:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:inventoryItemInstance,field:'manufacturers','errors')}">
                                    <g:select name="manufacturers"
from="${Manufacturer.list()}"
size="5" multiple="yes" optionKey="id"
value="${inventoryItemInstance?.manufacturers}" />

                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="spareFor">Spare For:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:inventoryItemInstance,field:'spareFor','errors')}">
                                    <g:select name="spareFor"
from="${Asset.list()}"
size="5" multiple="yes" optionKey="id"
value="${inventoryItemInstance?.spareFor}" />

                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="storedItems">Stored Items:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:inventoryItemInstance,field:'storedItems','errors')}">
                                    
<ul>
<g:each var="s" in="${inventoryItemInstance?.storedItems?}">
    <li><g:link controller="storedItemDetailed" action="show" id="${s.id}">${s?.encodeAsHTML()}</g:link></li>
</g:each>
</ul>
<g:link controller="storedItemDetailed" params="['inventoryItem.id':inventoryItemInstance?.id]" action="create">Add StoredItem</g:link>

                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="suppliers">Suppliers:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:inventoryItemInstance,field:'suppliers','errors')}">
                                    <g:select name="suppliers"
from="${Supplier.list()}"
size="5" multiple="yes" optionKey="id"
value="${inventoryItemInstance?.suppliers}" />

                                </td>
                            </tr> 
                        
                        </tbody>
                    </table>
                </div>
                <div class="buttons">
                    <span class="button"><g:actionSubmit class="save" value="Update" /></span>
                    <span class="button"><g:actionSubmit class="delete" onclick="return confirm('Are you sure?');" value="Delete" /></span>
                </div>
            </g:form>
        </div>
    </body>
</html>
