import org.codehaus.groovy.grails.plugins.springsecurity.Secured

class StoreLocationController extends BaseAppAdminController {
    
    def index = { redirect(action:list,params:params) }

    // the delete, save and update actions only accept POST requests
    static allowedMethods = [delete:'POST', save:'POST', update:'POST']

    def list = {
        params.max = Math.min( params.max ? params.max.toInteger() : 10,  100)
        [ storeLocationInstanceList: StoreLocation.list( params ), storeLocationInstanceTotal: StoreLocation.count() ]
    }

    def show = {
        def storeLocationInstance = StoreLocation.get( params.id )

        if(!storeLocationInstance) {
            flash.message = "StoreLocation not found with id ${params.id}"
            redirect(action:list)
        }
        else { return [ storeLocationInstance : storeLocationInstance ] }
    }

    def delete = {
        def storeLocationInstance = StoreLocation.get( params.id )
        if(storeLocationInstance) {
            try {
                storeLocationInstance.delete()
                flash.message = "StoreLocation ${params.id} deleted"
                redirect(action:list)
            }
            catch(org.springframework.dao.DataIntegrityViolationException e) {
                flash.message = "StoreLocation ${params.id} could not be deleted"
                redirect(action:show,id:params.id)
            }
        }
        else {
            flash.message = "StoreLocation not found with id ${params.id}"
            redirect(action:list)
        }
    }

    def edit = {
        def storeLocationInstance = StoreLocation.get( params.id )

        if(!storeLocationInstance) {
            flash.message = "StoreLocation not found with id ${params.id}"
            redirect(action:list)
        }
        else {
            return [ storeLocationInstance : storeLocationInstance ]
        }
    }

    def update = {
        def storeLocationInstance = StoreLocation.get( params.id )
        if(storeLocationInstance) {
            if(params.version) {
                def version = params.version.toLong()
                if(storeLocationInstance.version > version) {
                    
                    storeLocationInstance.errors.rejectValue("version", "storeLocation.optimistic.locking.failure", "Another user has updated this StoreLocation while you were editing.")
                    render(view:'edit',model:[storeLocationInstance:storeLocationInstance])
                    return
                }
            }
            storeLocationInstance.properties = params
            if(!storeLocationInstance.hasErrors() && storeLocationInstance.save()) {
                flash.message = "StoreLocation ${params.id} updated"
                redirect(action:show,id:storeLocationInstance.id)
            }
            else {
                render(view:'edit',model:[storeLocationInstance:storeLocationInstance])
            }
        }
        else {
            flash.message = "StoreLocation not found with id ${params.id}"
            redirect(action:edit,id:params.id)
        }
    }

    def create = {
        def storeLocationInstance = new StoreLocation()
        storeLocationInstance.properties = params
        return ['storeLocationInstance':storeLocationInstance]
    }

    def save = {
        def storeLocationInstance = new StoreLocation(params)
        if(!storeLocationInstance.hasErrors() && storeLocationInstance.save()) {
            flash.message = "StoreLocation ${storeLocationInstance.id} created"
            redirect(action:show,id:storeLocationInstance.id)
        }
        else {
            render(view:'create',model:[storeLocationInstance:storeLocationInstance])
        }
    }
}
