<head>
    <meta name="layout" content="main" />
    <title>Create Person</title>
    <nav:resources override="true"/>
</head>

<body>

    <div class="nav">
        <nav:renderSubItems group="navAlt"/>
    </div>

    <div class="body">
        <g:if test="${flash.message}">
        <div class="message">${flash.message}</div>
        </g:if>
        <g:if test="${params.message}">
            <div class="message">${params.message}</div>
        </g:if>
        <g:hasErrors bean="${person}">
        <div class="errors">
            <g:renderErrors bean="${person}" as="list" />
        </div>
        </g:hasErrors>
        <g:form action="save">
            <div class="dialog">
                <table>
                <tbody>

                    <tr class="prop">
                        <td valign="top" class="name"><label for="loginName">Login Name:</label></td>
                        <td valign="top" class="value ${hasErrors(bean:person,field:'loginName','errors')}">
                            <input type="text" id="loginName" name="loginName" value="${person.loginName?.encodeAsHTML()}"/>
                        </td>
                    </tr>

                    <tr class="prop">
                        <td valign="top" class="name"><label for="firstName">First Name:</label></td>
                        <td valign="top" class="value ${hasErrors(bean:person,field:'firstName','errors')}">
                            <input type="text" id="firstName" name="firstName" value="${person.firstName?.encodeAsHTML()}"/>
                        </td>
                    </tr>

                    <tr class="prop">
                        <td valign="top" class="name"><label for="lastName">Last Name:</label></td>
                        <td valign="top" class="value ${hasErrors(bean:person,field:'lastName','errors')}">
                            <input type="text" id="lastName" name="lastName" value="${person.lastName?.encodeAsHTML()}"/>
                        </td>
                    </tr>


                    <tr class="prop">
                        <td valign="top" class="name"><label for="pass">Password:</label></td>
                        <td valign="top" class="value ${hasErrors(bean:person,field:'pass','errors')}">
                            <input type="password" id="pass" name="pass"/>
                        </td>
                    </tr>

                    <tr class="prop">
                        <td valign="top" class="name"><label for="isActive">isActive:</label></td>
                        <td valign="top" class="value ${hasErrors(bean:person,field:'isActive','errors')}">
                            <g:checkBox name="isActive" value="${person.isActive}" ></g:checkBox>
                        </td>
                    </tr>

                    <tr class="prop">
                        <td valign="top" class="name"><label for="description">Description:</label></td>
                        <td valign="top" class="value ${hasErrors(bean:person,field:'description','errors')}">
                            <input type="text" id="description" name="description" value="${person.description?.encodeAsHTML()}"/>
                        </td>
                    </tr>

                    <tr class="prop">
                        <td valign="top" class="name"><label for="email">Email:</label></td>
                        <td valign="top" class="value ${hasErrors(bean:person,field:'email','errors')}">
                            <input type="text" id="email" name="email" value="${person.email?.encodeAsHTML()}"/>
                        </td>
                    </tr>

                    <tr class="prop">
                        <td valign="top" class="name"><label for="emailShow">Show Email:</label></td>
                        <td valign="top" class="value ${hasErrors(bean:person,field:'emailShow','errors')}">
                            <g:checkBox name="emailShow" value="${person.emailShow}"/>
                        </td>
                    </tr>

                    <tr class="prop">
                        <td valign="top" class="name"><label for="employeeID">employee ID:</label></td>
                        <td valign="top" class="value ${hasErrors(bean:person,field:'employeeID','errors')}">
                            <input type="text" id="employeeID" name="employeeID" value="${person.employeeID?.encodeAsHTML()}"/>
                        </td>
                    </tr>

                    <tr class="prop">
                        <td valign="top" class="name" align="left">Authorities:</td>
                    </tr>

                    <g:each in="${authorityList}">
                    <tr>
                        <td valign="top" class="name" align="left">${it.authority.encodeAsHTML()}</td>
                        <td align="left"><g:checkBox name="${it.authority}"/></td>
                    </tr>
                    </g:each>

                </tbody>
                </table>
            </div>

            <div class="buttons">
                <span class="button"><input class="save" type="submit" value="Create" /></span>
            </div>

        </g:form>

    </div>
</body>
