import org.codehaus.groovy.grails.plugins.springsecurity.Secured

class SystemSectionController extends BaseAppAdminController {
    
    def index = { redirect(action:list,params:params) }

    // the delete, save and update actions only accept POST requests
    static allowedMethods = [delete:'POST', save:'POST', update:'POST']

    def list = {
        params.max = Math.min( params.max ? params.max.toInteger() : 10,  100)
        [ systemSectionInstanceList: SystemSection.list( params ), systemSectionInstanceTotal: SystemSection.count() ]
    }

    def show = {
        def systemSectionInstance = SystemSection.get( params.id )

        if(!systemSectionInstance) {
            flash.message = "SystemSection not found with id ${params.id}"
            redirect(action:list)
        }
        else { return [ systemSectionInstance : systemSectionInstance ] }
    }

    def delete = {
        def systemSectionInstance = SystemSection.get( params.id )
        if(systemSectionInstance) {
            try {
                systemSectionInstance.delete()
                flash.message = "SystemSection ${params.id} deleted"
                redirect(action:list)
            }
            catch(org.springframework.dao.DataIntegrityViolationException e) {
                flash.message = "SystemSection ${params.id} could not be deleted"
                redirect(action:show,id:params.id)
            }
        }
        else {
            flash.message = "SystemSection not found with id ${params.id}"
            redirect(action:list)
        }
    }

    def edit = {
        def systemSectionInstance = SystemSection.get( params.id )

        if(!systemSectionInstance) {
            flash.message = "SystemSection not found with id ${params.id}"
            redirect(action:list)
        }
        else {
            return [ systemSectionInstance : systemSectionInstance ]
        }
    }

    def update = {
        def systemSectionInstance = SystemSection.get( params.id )
        if(systemSectionInstance) {
            if(params.version) {
                def version = params.version.toLong()
                if(systemSectionInstance.version > version) {
                    
                    systemSectionInstance.errors.rejectValue("version", "systemSection.optimistic.locking.failure", "Another user has updated this SystemSection while you were editing.")
                    render(view:'edit',model:[systemSectionInstance:systemSectionInstance])
                    return
                }
            }
            systemSectionInstance.properties = params
            if(!systemSectionInstance.hasErrors() && systemSectionInstance.save()) {
                flash.message = "SystemSection ${params.id} updated"
                redirect(action:show,id:systemSectionInstance.id)
            }
            else {
                render(view:'edit',model:[systemSectionInstance:systemSectionInstance])
            }
        }
        else {
            flash.message = "SystemSection not found with id ${params.id}"
            redirect(action:edit,id:params.id)
        }
    }

    def create = {
        def systemSectionInstance = new SystemSection()
        systemSectionInstance.properties = params
        return ['systemSectionInstance':systemSectionInstance]
    }

    def save = {
        def systemSectionInstance = new SystemSection(params)
        if(!systemSectionInstance.hasErrors() && systemSectionInstance.save()) {
            flash.message = "SystemSection ${systemSectionInstance.id} created"
            redirect(action:show,id:systemSectionInstance.id)
        }
        else {
            render(view:'create',model:[systemSectionInstance:systemSectionInstance])
        }
    }
}
