class  InventoryItem {
    InventoryGroup inventoryGroup
    InventoryType inventoryType
    UnitOfMeasure unitOfMeasure
    String name
    String description = ""
    String manufacturersPartNumber
    String suppliersPartNumber
    Integer reorderPoint
    Integer recommendedReorderPoint
    Integer averageDeliveryTime
    boolean isActive = true
    boolean isObsolete = false
    boolean enableReorder = true

    static hasMany = [alternateItems: InventoryItem,
                                    spareFor: Asset,
                                    storedItems: StoredItem,
                                    inventoryMovements: InventoryMovement,
                                    manufacturers: Manufacturer,
                                    suppliers: Supplier]

//     static belongsTo = []

    static constraints = {
        name(unique:true, blank:false, maxSize:75)
        description()
        reorderPoint()
        enableReorder()
        isActive()
        isObsolete()
        inventoryGroup()
        inventoryType()
        unitOfMeasure()
        manufacturersPartNumber(blank:true, nullable:true)
        suppliersPartNumber(blank:true, nullable:true)
        recommendedReorderPoint(blank:true, nullable:true)
        averageDeliveryTime(blank:true, nullable:true)
    }

    String toString() {"${this.name}"}
}
        
