import org.codehaus.groovy.grails.plugins.springsecurity.Secured

class TaskRecurringScheduleDetailedController extends BaseController {
    
    def index = { redirect(action:list,params:params) }

    // the delete, save and update actions only accept POST requests
    static allowedMethods = [delete:'POST', save:'POST', update:'POST']

    def list = {
        params.max = Math.min( params.max ? params.max.toInteger() : 10,  100)
        [ taskRecurringScheduleInstanceList: TaskRecurringSchedule.list( params ), taskRecurringScheduleInstanceTotal: TaskRecurringSchedule.count() ]
    }

    def show = {
        def taskRecurringScheduleInstance = TaskRecurringSchedule.get( params.id )

        if(!taskRecurringScheduleInstance) {
            flash.message = "TaskRecurringSchedule not found with id ${params.id}"
            redirect(action:list)
        }
        else { return [ taskRecurringScheduleInstance : taskRecurringScheduleInstance ] }
    }

    def delete = {
        def taskRecurringScheduleInstance = TaskRecurringSchedule.get( params.id )
        if(taskRecurringScheduleInstance) {
            try {
                taskRecurringScheduleInstance.delete()
                flash.message = "TaskRecurringSchedule ${params.id} deleted"
                redirect(action:list)
            }
            catch(org.springframework.dao.DataIntegrityViolationException e) {
                flash.message = "TaskRecurringSchedule ${params.id} could not be deleted"
                redirect(action:show,id:params.id)
            }
        }
        else {
            flash.message = "TaskRecurringSchedule not found with id ${params.id}"
            redirect(action:list)
        }
    }

    def edit = {
        def taskRecurringScheduleInstance = TaskRecurringSchedule.get( params.id )

        if(!taskRecurringScheduleInstance) {
            flash.message = "TaskRecurringSchedule not found with id ${params.id}"
            redirect(action:list)
        }
        else {
            return [ taskRecurringScheduleInstance : taskRecurringScheduleInstance ]
        }
    }

    def update = {
        def taskRecurringScheduleInstance = TaskRecurringSchedule.get( params.id )
        if(taskRecurringScheduleInstance) {
            if(params.version) {
                def version = params.version.toLong()
                if(taskRecurringScheduleInstance.version > version) {
                    
                    taskRecurringScheduleInstance.errors.rejectValue("version", "taskRecurringSchedule.optimistic.locking.failure", "Another user has updated this TaskRecurringSchedule while you were editing.")
                    render(view:'edit',model:[taskRecurringScheduleInstance:taskRecurringScheduleInstance])
                    return
                }
            }
            taskRecurringScheduleInstance.properties = params
            if(!taskRecurringScheduleInstance.hasErrors() && taskRecurringScheduleInstance.save()) {
                flash.message = "TaskRecurringSchedule ${params.id} updated"
                redirect(action:show,id:taskRecurringScheduleInstance.id)
            }
            else {
                render(view:'edit',model:[taskRecurringScheduleInstance:taskRecurringScheduleInstance])
            }
        }
        else {
            flash.message = "TaskRecurringSchedule not found with id ${params.id}"
            redirect(action:edit,id:params.id)
        }
    }
	
    def create = {
        try {
            def taskInstance = Task.get(params.taskInstance.id)
			def taskRecurringScheduleInstance = new TaskRecurringSchedule()
            taskRecurringScheduleInstance.task = taskInstance
            return [taskRecurringScheduleInstance: taskRecurringScheduleInstance]
        }
        catch(Exception e) {
            flash.message = "Please select a task, then Create a Recurring Schedule for it"
            redirect(controller:"taskDetailed", action:"list")
        }
    }

    def save = {
        def taskRecurringScheduleInstance = new TaskRecurringSchedule(params)
		def taskInstance = Task.get(params.task.id)
				
		if(taskInstance.taskRecurringSchedule) {
			flash.message = "This task already has a recurring schedule"
			redirect(controller:"taskDetailed", action:"show", id: params.task.id)
		}
		else {
			
			taskRecurringScheduleInstance.nextDueDate = new Date()
				
// 			taskRecurringScheduleInstance.nextDueDate = calculateNextDueDate(new Date()) 
			
			if(!taskRecurringScheduleInstance.hasErrors() && taskRecurringScheduleInstance.save()) {
				
				taskInstance.taskRecurringSchedule = taskRecurringScheduleInstance
						
				if(taskInstance.save()) {
					flash.message = "TaskRecurringSchedule ${taskRecurringScheduleInstance.id} created"
					redirect(action:show,id:taskRecurringScheduleInstance.id)
				}
				else {
					flash.message = "Task could not be saved and therefore the Recurring Schedule has been disgarded, cause unknown."				
					render(view:'create',model:[taskRecurringScheduleInstance:taskRecurringScheduleInstance])
				}
			}
			else {
				render(view:'create',model:[taskRecurringScheduleInstance:taskRecurringScheduleInstance])
			}
		}

    }
	
// 	private Date calculateNextDueDate(nextDue) {
// // 		def now = new Date()
// // 		def calculatedDays = new Integer()
// // 		def nextDue = new Date()
// 				
// // 		switch (period) {
// // 			case "Day(s)":
// // 				calculatedDays = period
// // 				nextDue = now + calculatedDays
// // 			case "Week(s)":
// // 				calculatedDays = period * 7
// // 				nextDue = now + calculatedDays
// // // 			default:
// // 		}
// 		nextDue = nextDue + 1
// 		return nextDue
// 	}
	
}
