

<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
        <meta name="layout" content="main" />
        <title>Create Entry</title>         
    </head>
    <body>
        <div class="nav">
            <span class="menuButton"><a class="home" href="${createLinkTo(dir:'')}">Home</a></span>
            <span class="menuButton"><g:link class="list" action="list">Entry List</g:link></span>
        </div>
        <div class="body">
            <h1>Create Entry</h1>
            <g:if test="${flash.message}">
            <div class="message">${flash.message}</div>
            </g:if>
            <g:hasErrors bean="${entryInstance}">
            <div class="errors">
                <g:renderErrors bean="${entryInstance}" as="list" />
            </div>
            </g:hasErrors>
            <g:form action="save" method="post" >
                <g:hiddenField name="task.id" value="${entryInstance.task.id}" />
                <div class="dialog">
                    <table>
                        <tbody>
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="task">Task:</label>
                                </td>
                                <td valign="top" class="name">
                                    ${entryInstance?.task?.description}
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="comment">Comment:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:entryInstance,field:'comment','errors')}">
                                    <textarea rows="5" cols="40" name="comment">${fieldValue(bean:entryInstance, field:'comment')}</textarea>
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="dateDone">Date Done:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:entryInstance,field:'dateDone','errors')}">
                                    <g:datePicker name="dateDone" value="${entryInstance?.dateDone}" precision="day"></g:datePicker>
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="durationHour">Duration:</label>
                                </td>

                                <td valign="top" class="value">
                                    <input class="duration ${hasErrors(bean:entryInstance,field:'durationHour','errors')}" 
                                        type="text" id="durationHour" name="durationHour" 
                                        value="${fieldValue(bean:entryInstance,field:'durationHour')}" />
                                    :
                                    <input class="duration ${hasErrors(bean:entryInstance,field:'durationMinute','errors')}" 
                                        type="text" id="durationMinute" name="durationMinute" 
                                        value="${fieldValue(bean:entryInstance,field:'durationMinute')}" />
                                    <g:helpBalloon code="entry.duration" />
                                </td> 
                            </tr>
                     
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="entryType">Entry Type:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:entryInstance,field:'entryType','errors')}">
                                    <g:select optionKey="id" from="${EntryType.list()}" name="entryType.id" value="${entryInstance?.entryType?.id}" ></g:select>
                                </td>
                            </tr> 
                        
                        </tbody>
                    </table>
                </div>
                <div class="buttons">
                    <span class="button"><input class="save" type="submit" value="Create" /></span>
                </div>
            </g:form>
        </div>
    </body>
</html>
